/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.Menus;
import ij.io.OpenDialog;
import ij.macro.Interpreter;
import ij.plugin.PlugIn;
import ij.plugin.frame.Editor;
import java.io.File;
import java.util.Scanner;

public class BIOP_LibInstaller
implements PlugIn {
    public void run(String what) {
        if (what.equals("Show Functions")) {
            BIOP_LibInstaller.showAvaialableFunctions();
        } else {
            OpenDialog od = new OpenDialog("Choose the file with your macros");
            String fileName = od.getFileName();
            String fileDir = od.getDirectory();
            what = String.valueOf(fileDir) + fileName;
            BIOP_LibInstaller.installLibrary(what);
        }
    }

    public static void installLibrary(String libPath) {
        block7: {
            File f = new File(libPath);
            String fullPath = f.getAbsolutePath();
            String libName = f.getName().substring(0, f.getName().length() - 4);
            if (!f.isAbsolute()) {
                String fijiPath = Menus.getPlugInsPath();
                libPath = String.valueOf(fijiPath) + libPath;
                f = new File(libPath);
                fullPath = f.getAbsolutePath();
            }
            if (f.exists()) {
                try {
                    Scanner sc = new Scanner(f);
                    String libFunctions = sc.useDelimiter("\\Z").next();
                    sc.close();
                    String IdStart = "// From: " + libName + " START \n\r";
                    String IdEnd = "\n\r// " + libName + " END";
                    libFunctions = String.valueOf(IdStart) + libFunctions + IdEnd;
                    String oldFunctions = Interpreter.getAdditionalFunctions();
                    if (oldFunctions != null) {
                        if (oldFunctions.indexOf(IdStart) != -1) {
                            int startInd = oldFunctions.indexOf(IdStart);
                            int endInd = oldFunctions.indexOf(IdEnd) + IdEnd.length();
                            oldFunctions = String.valueOf(oldFunctions.substring(startInd, startInd)) + oldFunctions.substring(endInd, oldFunctions.length());
                        }
                        Interpreter.setAdditionalFunctions((String)(String.valueOf(oldFunctions) + libFunctions));
                        break block7;
                    }
                    Interpreter.setAdditionalFunctions((String)libFunctions);
                }
                catch (Exception e) {
                    IJ.error((String)e.getMessage());
                }
            } else {
                IJ.showMessage((String)(String.valueOf(libName) + " not found. in " + libPath + ".\n" + "Make sure you placed " + libName + " in the right place."));
            }
        }
    }

    public static void showAvaialableFunctions() throws NullPointerException {
        String str = "Displaying all available functions from the macro interpreter.\n";
        String[] allFun = Interpreter.getAdditionalFunctions().split("\n");
        int i = 0;
        while (i < allFun.length) {
            if (allFun[i].trim().startsWith("// From:")) {
                str = String.valueOf(str) + "---------- From " + allFun[i].trim().substring(8, allFun[i].trim().indexOf("START")).trim() + " Library ----------\n\n";
            }
            if (allFun[i].trim().startsWith("function")) {
                str = String.valueOf(str) + allFun[i].substring(9, allFun[i].indexOf("{")).trim() + "\n";
                String comments = "";
                int j = 0;
                if (allFun[i - 1].trim().startsWith("*/")) {
                    int ind = j = i - 2;
                    while (j > 0) {
                        if (allFun[j].trim().startsWith("/*")) {
                            ind = j;
                            j = 0;
                            continue;
                        }
                        --j;
                    }
                    int k = i - 2;
                    while (k >= ind + 1) {
                        comments = "        " + allFun[k].substring(2).trim() + "\n" + comments + "\r\n";
                        --k;
                    }
                    str = String.valueOf(str) + comments;
                }
            }
            ++i;
        }
        Editor ed = Editor.getInstance();
        if (ed == null) {
            ed = new Editor();
        }
        ed.display("Available Macro Functions", str);
    }
}

