/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.geom.integer;

import java.util.Iterator;
import net.imglib2.AbstractInterval;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RealPoint;

public class IterableLine
extends AbstractInterval
implements IterableInterval<Void> {
    private final long nPoints;
    private final Localizable start;
    private final Localizable end;

    public IterableLine(Localizable start, Localizable end) {
        super(start.numDimensions());
        this.start = new Point(start);
        this.end = new Point(end);
        Point diff = new Point(this.n);
        long maxDiff = -1L;
        for (int d = 0; d < this.n; ++d) {
            this.min[d] = Math.min(start.getLongPosition(d), end.getLongPosition(d));
            this.max[d] = Math.max(start.getLongPosition(d), end.getLongPosition(d));
            long dx = end.getLongPosition(d) - start.getLongPosition(d);
            diff.setPosition(dx, d);
            if (Math.abs(dx) <= maxDiff) continue;
            maxDiff = Math.abs(dx);
        }
        this.nPoints = maxDiff;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IterableLine)) {
            return false;
        }
        IterableLine ol = (IterableLine)((Object)o);
        return IterableLine.locationsEqual(this.start, ol.start) && IterableLine.locationsEqual(this.end, ol.end);
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + IterableLine.hash(this.start);
        hash = 31 * hash + IterableLine.hash(this.end);
        return hash;
    }

    public long size() {
        return 1L + this.nPoints;
    }

    public Void firstElement() {
        return (Void)this.cursor().next();
    }

    public Object iterationOrder() {
        return this;
    }

    public Iterator<Void> iterator() {
        return this.cursor();
    }

    public Cursor<Void> cursor() {
        return this.localizingCursor();
    }

    public Cursor<Void> localizingCursor() {
        return new LineCursor();
    }

    private static final boolean locationsEqual(Localizable l1, Localizable l2) {
        int numDims = l1.numDimensions();
        if (l2.numDimensions() != numDims) {
            return false;
        }
        for (int d = 0; d < numDims; ++d) {
            if (l1.getLongPosition(d) == l2.getLongPosition(d)) continue;
            return false;
        }
        return true;
    }

    private static final int hash(Localizable l) {
        int hash = 17;
        for (int d = 0; d < l.numDimensions(); ++d) {
            hash = 31 * hash + Long.hashCode(l.getLongPosition(d));
        }
        return hash;
    }

    private final class LineCursor
    implements Cursor<Void> {
        private final RealPoint increment;
        private final RealPoint current;
        private long index;

        public LineCursor() {
            int d;
            this.current = new RealPoint(IterableLine.this.n);
            Point diff = new Point(IterableLine.this.n);
            long maxDiff = -1L;
            for (d = 0; d < IterableLine.this.n; ++d) {
                long dx = IterableLine.this.end.getLongPosition(d) - IterableLine.this.start.getLongPosition(d);
                diff.setPosition(dx, d);
                if (Math.abs(dx) <= maxDiff) continue;
                maxDiff = Math.abs(dx);
            }
            this.increment = new RealPoint(IterableLine.this.n);
            if (maxDiff != 0L) {
                for (d = 0; d < IterableLine.this.n; ++d) {
                    this.increment.setPosition(diff.getDoublePosition(d) / (double)maxDiff, d);
                }
            }
            this.reset();
        }

        public LineCursor(LineCursor c) {
            this();
            this.index = c.index;
            this.current.setPosition((Localizable)c);
        }

        public boolean hasNext() {
            return this.index < IterableLine.this.nPoints;
        }

        public Void get() {
            return null;
        }

        public void fwd() {
            ++this.index;
            for (int d = 0; d < IterableLine.this.n; ++d) {
                this.current.move(this.increment.getDoublePosition(d), d);
            }
        }

        public void jumpFwd(long steps) {
            if (steps < 0L || steps > IterableLine.this.nPoints) {
                throw new IllegalArgumentException("Cannot jump by " + steps + " points.");
            }
            this.index += steps;
            for (int d = 0; d < IterableLine.this.n; ++d) {
                this.current.move((double)steps * this.increment.getDoublePosition(d), d);
            }
        }

        public void reset() {
            this.index = -1L;
            this.current.setPosition(IterableLine.this.start);
            for (int d = 0; d < IterableLine.this.n; ++d) {
                this.current.move(-this.increment.getDoublePosition(d), d);
            }
        }

        public Void next() {
            this.fwd();
            return null;
        }

        public void localize(long[] position) {
            for (int d = 0; d < IterableLine.this.n; ++d) {
                position[d] = this.getLongPosition(d);
            }
        }

        public long getLongPosition(int d) {
            return Math.round(this.current.getDoublePosition(d));
        }

        public void localize(int[] position) {
            for (int d = 0; d < IterableLine.this.n; ++d) {
                position[d] = this.getIntPosition(d);
            }
        }

        public int getIntPosition(int d) {
            return (int)this.getLongPosition(d);
        }

        public Cursor<Void> copy() {
            return new LineCursor(this);
        }

        public void localize(float[] position) {
            for (int d = 0; d < position.length; ++d) {
                position[d] = this.getLongPosition(d);
            }
        }

        public void localize(double[] position) {
            for (int d = 0; d < position.length; ++d) {
                position[d] = this.getLongPosition(d);
            }
        }

        public float getFloatPosition(int d) {
            return Math.round(this.current.getFloatPosition(d));
        }

        public double getDoublePosition(int d) {
            return Math.round(this.current.getFloatPosition(d));
        }

        public int numDimensions() {
            return this.current.numDimensions();
        }
    }
}

