/*
 * Decompiled with CFR 0.152.
 */
package com.bitplane.xt;

import Ice.Communicator;
import Ice.InitializationData;
import Ice.LocalException;
import Ice.Object;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import Ice.Properties;
import Ice.Util;
import ImarisServer.IServerPrx;
import ImarisServer.IServerPrxHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class IceClient {
    Communicator mCommunicator = null;
    ObjectAdapter mAdapter = null;
    IServerPrx mServer = null;
    String mError = "";

    public IceClient(String string, String string2, int n) {
        try {
            InitializationData initializationData = new InitializationData();
            Properties properties = Util.createProperties();
            properties.setProperty("Ice.Default.EncodingVersion", "1.0");
            properties.setProperty("Ice.MessageSizeMax", "1000000000");
            properties.setProperty("IceClient.Adapter.Endpoints", "default");
            String string3 = "0";
            for (int i = 0; i < 5; ++i) {
                string3 = string3 + " " + n * (i * 2 + 1) / 25;
            }
            properties.setProperty("Ice.RetryIntervals", string3);
            initializationData.properties = properties;
            this.mCommunicator = Util.initialize(initializationData);
            ObjectPrx objectPrx = this.mCommunicator.stringToProxy(string + ":" + string2);
            this.mServer = IServerPrxHelper.checkedCast(objectPrx);
            this.mAdapter = this.mCommunicator.createObjectAdapter("IceClient.Adapter");
            this.mAdapter.activate();
            this.mServer.ice_getConnection().setAdapter(this.mAdapter);
        }
        catch (LocalException localException) {
            localException.printStackTrace(new PrintStream(new OutputStream(){

                @Override
                public void write(int n) throws IOException {
                    IceClient.this.mError = IceClient.this.mError + (char)n;
                }
            }));
        }
        catch (Exception exception) {
            this.mError = this.mError + exception.getMessage();
        }
    }

    public void Terminate() {
        this.mError = "";
        if (this.mCommunicator != null) {
            try {
                this.mCommunicator.shutdown();
                this.mCommunicator.destroy();
            }
            catch (Exception exception) {
                this.mError = exception.getMessage();
            }
        }
    }

    public ObjectPrx Activate(Object object) {
        return this.mAdapter.addWithUUID(object);
    }

    public IServerPrx GetServer() {
        return this.mServer;
    }

    public String GetError() {
        return this.mError;
    }
}

