/*
 * Decompiled with CFR 0.152.
 */
package IceUtilInternal;

import IceUtilInternal.OutputBase;
import java.io.PrintWriter;
import java.util.LinkedList;

public class XMLOutput
extends OutputBase {
    private LinkedList<String> _elementStack = new LinkedList();
    boolean _se = false;
    boolean _text = false;
    private boolean _sgml = false;
    private boolean _escape = false;

    public XMLOutput() {
    }

    public XMLOutput(PrintWriter printWriter) {
        super(printWriter);
    }

    public XMLOutput(String string) {
        super(string);
    }

    public void setSGML(boolean bl) {
        this._sgml = true;
    }

    @Override
    public void print(String string) {
        if (this._se) {
            this._out.print('>');
            this._se = false;
        }
        this._text = true;
        if (this._escape) {
            String string2 = this.escape(string);
            super.print(string2);
        } else {
            super.print(string);
        }
    }

    public XMLOutput write(String string) {
        this.print(string);
        return this;
    }

    @Override
    public void nl() {
        if (this._se) {
            this._se = false;
            this._out.print('>');
        }
        super.nl();
    }

    public XMLOutput se(String string) {
        this.nl();
        if (this._escape) {
            this._out.print('<');
            this._out.print(this.escape(string));
        } else {
            this._out.print('<');
            this._out.print(string);
        }
        this._se = true;
        this._text = false;
        int n = string.indexOf(32);
        if (n == -1) {
            n = string.indexOf(9);
        }
        if (n == -1) {
            this._elementStack.addFirst(string);
        } else {
            this._elementStack.addFirst(string.substring(0, n));
        }
        ++this._pos;
        this.inc();
        this._separator = false;
        return this;
    }

    public XMLOutput ee() {
        String string = this._elementStack.removeFirst();
        this.dec();
        if (this._se) {
            if (this._sgml) {
                this._out.print("></");
                this._out.print(string);
                this._out.print(">");
            } else {
                this._out.print("/>");
            }
        } else {
            if (!this._text) {
                this.nl();
            }
            this._out.print("</");
            this._out.print(string);
            this._out.print(">");
        }
        --this._pos;
        this._se = false;
        this._text = false;
        return this;
    }

    public XMLOutput attr(String string, String string2) {
        assert (this._se);
        this._out.print(" ");
        this._out.print(string);
        this._out.print("=\"");
        this._out.print(this.escape(string2));
        this._out.print("\"");
        return this;
    }

    public XMLOutput startEscapes() {
        this._escape = true;
        return this;
    }

    public XMLOutput endEscapes() {
        this._escape = false;
        return this;
    }

    public String currentElement() {
        if (this._elementStack.size() > 0) {
            return this._elementStack.getFirst();
        }
        return "";
    }

    private String escape(String string) {
        String string2 = string;
        boolean bl = false;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if ("<>'\"&".indexOf(cArray[i]) == -1) continue;
            bl = true;
            break;
        }
        if (bl) {
            if (string2.indexOf(38) != -1) {
                string2 = string2.replaceAll("&", "&amp;");
            }
            if (string2.indexOf(62) != -1) {
                string2 = string2.replaceAll(">", "&gt;");
            }
            if (string2.indexOf(60) != -1) {
                string2 = string2.replaceAll("<", "&lt;");
            }
            if (string2.indexOf(39) != -1) {
                string2 = string2.replaceAll("'", "&apos;");
            }
            if (string2.indexOf(34) != -1) {
                string2 = string2.replaceAll("\"", "&quot;");
            }
        }
        return string2;
    }
}

