/*
 * Decompiled with CFR 0.152.
 */
package IceUtilInternal;

import Ice.Holder;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public final class StringUtil {
    public static int findFirstOf(String string, String string2) {
        return StringUtil.findFirstOf(string, string2, 0);
    }

    public static int findFirstOf(String string, String string2, int n) {
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (string2.indexOf(c) == -1) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstNotOf(String string, String string2) {
        return StringUtil.findFirstNotOf(string, string2, 0);
    }

    public static int findFirstNotOf(String string, String string2, int n) {
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (string2.indexOf(c) != -1) continue;
            return i;
        }
        return -1;
    }

    private static void encodeChar(byte n, StringBuilder stringBuilder, String string) {
        switch (n) {
            case 92: {
                stringBuilder.append("\\\\");
                break;
            }
            case 39: {
                stringBuilder.append("\\'");
                break;
            }
            case 34: {
                stringBuilder.append("\\\"");
                break;
            }
            case 8: {
                stringBuilder.append("\\b");
                break;
            }
            case 12: {
                stringBuilder.append("\\f");
                break;
            }
            case 10: {
                stringBuilder.append("\\n");
                break;
            }
            case 13: {
                stringBuilder.append("\\r");
                break;
            }
            case 9: {
                stringBuilder.append("\\t");
                break;
            }
            default: {
                if (n < 32 || n > 126) {
                    stringBuilder.append('\\');
                    String string2 = Integer.toOctalString(n < 0 ? n + 256 : n);
                    for (int i = string2.length(); i < 3; ++i) {
                        stringBuilder.append('0');
                    }
                    stringBuilder.append(string2);
                    break;
                }
                if (string != null && string.indexOf((char)n) != -1) {
                    stringBuilder.append('\\');
                    stringBuilder.append((char)n);
                    break;
                }
                stringBuilder.append((char)n);
            }
        }
    }

    public static String escapeString(String string, String string2) {
        if (string2 != null) {
            for (int i = 0; i < string2.length(); ++i) {
                if (string2.charAt(i) >= ' ' && string2.charAt(i) <= '~') continue;
                throw new IllegalArgumentException("special characters must be in ASCII range 32-126");
            }
        }
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            assert (false);
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            StringUtil.encodeChar(byArray[i], stringBuilder, string2);
        }
        return stringBuilder.toString();
    }

    private static char checkChar(String string, int n) {
        char c = string.charAt(n);
        if (c < ' ' || c > '~') {
            String string2 = n > 0 ? "character after `" + string.substring(0, n) + "'" : "first character";
            string2 = string2 + " is not a printable ASCII character (ordinal " + c + ")";
            throw new IllegalArgumentException(string2);
        }
        return c;
    }

    private static char decodeChar(String string, int n, int n2, Holder<Integer> holder) {
        int n3;
        assert (n >= 0);
        assert (n < n2);
        assert (n2 <= string.length());
        if (string.charAt(n) != '\\') {
            n3 = StringUtil.checkChar(string, n++);
        } else {
            if (n + 1 == n2) {
                throw new IllegalArgumentException("trailing backslash");
            }
            switch (string.charAt(++n)) {
                case '\"': 
                case '\'': 
                case '\\': {
                    n3 = string.charAt(n++);
                    break;
                }
                case 'b': {
                    ++n;
                    n3 = 8;
                    break;
                }
                case 'f': {
                    ++n;
                    n3 = 12;
                    break;
                }
                case 'n': {
                    ++n;
                    n3 = 10;
                    break;
                }
                case 'r': {
                    ++n;
                    n3 = 13;
                    break;
                }
                case 't': {
                    ++n;
                    n3 = 9;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int n4 = 0;
                    for (int i = 0; i < 3 && n < n2; ++i) {
                        int n5;
                        if ((n5 = string.charAt(n++) - 48) < 0 || n5 > 7) {
                            --n;
                            break;
                        }
                        n4 = n4 * 8 + n5;
                    }
                    if (n4 > 255) {
                        String string2 = "octal value \\" + Integer.toOctalString(n4) + " (" + n4 + ") is out of range";
                        throw new IllegalArgumentException(string2);
                    }
                    n3 = (char)n4;
                    break;
                }
                default: {
                    n3 = StringUtil.checkChar(string, n++);
                }
            }
        }
        holder.value = n;
        return (char)n3;
    }

    private static void decodeString(String string, int n, int n2, StringBuilder stringBuilder) {
        Holder<Integer> holder = new Holder<Integer>();
        while (n < n2) {
            stringBuilder.append(StringUtil.decodeChar(string, n, n2, holder));
            n = (Integer)holder.value;
        }
    }

    public static String unescapeString(String string, int n, int n2) {
        assert (n >= 0 && n <= n2 && n2 <= string.length());
        StringBuilder stringBuilder = new StringBuilder(n2 - n);
        StringUtil.decodeString(string, n, n2, stringBuilder);
        String string2 = stringBuilder.toString();
        byte[] byArray = new byte[string2.length()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)string2.charAt(i);
        }
        try {
            return new String(byArray, 0, byArray.length, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("unsupported encoding", unsupportedEncodingException);
        }
    }

    public static String joinString(List<String> list, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (String string2 : list) {
            if (!bl) {
                stringBuffer.append(string);
            }
            stringBuffer.append(string2);
            bl = false;
        }
        return stringBuffer.toString();
    }

    public static String[] splitString(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        char[] cArray = new char[string.length()];
        int n = 0;
        int n2 = 0;
        char c = '\u0000';
        while (n < string.length()) {
            if (c == '\u0000' && (string.charAt(n) == '\"' || string.charAt(n) == '\'')) {
                c = string.charAt(n++);
                continue;
            }
            if (c == '\u0000' && string.charAt(n) == '\\' && n + 1 < string.length() && (string.charAt(n + 1) == '\"' || string.charAt(n + 1) == '\'')) {
                ++n;
            } else if (c != '\u0000' && string.charAt(n) == '\\' && n + 1 < string.length() && string.charAt(n + 1) == c) {
                ++n;
            } else {
                if (c != '\u0000' && string.charAt(n) == c) {
                    ++n;
                    c = '\u0000';
                    continue;
                }
                if (string2.indexOf(string.charAt(n)) != -1 && c == '\u0000') {
                    ++n;
                    if (n2 <= 0) continue;
                    arrayList.add(new String(cArray, 0, n2));
                    n2 = 0;
                    continue;
                }
            }
            if (n >= string.length()) continue;
            cArray[n2++] = string.charAt(n++);
        }
        if (n2 > 0) {
            arrayList.add(new String(cArray, 0, n2));
        }
        if (c != '\u0000') {
            return null;
        }
        return arrayList.toArray(new String[0]);
    }

    public static int checkQuote(String string) {
        return StringUtil.checkQuote(string, 0);
    }

    public static int checkQuote(String string, int n) {
        char c = string.charAt(n);
        if (c == '\"' || c == '\'') {
            int n2;
            ++n;
            int n3 = string.length();
            while (n < n3 && (n2 = string.indexOf(c, n)) != -1) {
                if (string.charAt(n2 - 1) != '\\') {
                    return n2;
                }
                n = n2 + 1;
            }
            return -1;
        }
        return 0;
    }

    public static boolean match(String string, String string2, boolean bl) {
        assert (string.length() > 0);
        assert (string2.length() > 0);
        int n = string2.indexOf(42);
        if (n < 0) {
            return string.equals(string2);
        }
        if (n > string.length() || !string.substring(0, n).equals(string2.substring(0, n))) {
            return false;
        }
        int n2 = string2.length() - n - 1;
        if (n2 == 0) {
            return true;
        }
        if (n2 > string.length()) {
            return false;
        }
        int n3 = string.length() - n2;
        if (n3 < n || !bl && n3 == n) {
            return false;
        }
        return string.substring(n3, string.length() - n3).equals(string2.substring(n + 1, string2.length() - n - 1));
    }
}

