/*
 * Decompiled with CFR 0.152.
 */
package IceUtilInternal;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;

public class OutputBase {
    protected PrintWriter _out;
    protected int _pos;
    protected int _indent;
    protected int _indentSize;
    protected LinkedList<Integer> _indentSave = new LinkedList();
    protected boolean _useTab;
    protected boolean _separator;

    public OutputBase() {
        this._out = null;
        this._pos = 0;
        this._indent = 0;
        this._indentSize = 4;
        this._useTab = true;
        this._separator = true;
    }

    public OutputBase(PrintWriter printWriter) {
        this._out = printWriter;
        this._pos = 0;
        this._indent = 0;
        this._indentSize = 4;
        this._useTab = true;
        this._separator = true;
    }

    public OutputBase(String string) {
        this._out = null;
        this._pos = 0;
        this._indent = 0;
        this._indentSize = 4;
        this._useTab = true;
        this._separator = true;
        this.open(string);
    }

    public void setIndent(int n) {
        this._indentSize = n;
    }

    public void setUseTab(boolean bl) {
        this._useTab = bl;
    }

    public void open(String string) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            this._out = new PrintWriter(bufferedWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void print(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\n') {
                this._pos = 0;
                continue;
            }
            ++this._pos;
        }
        this._out.print(string);
    }

    public void inc() {
        this._indent += this._indentSize;
    }

    public void dec() {
        assert (this._indent >= this._indentSize);
        this._indent -= this._indentSize;
    }

    public void useCurrentPosAsIndent() {
        this._indentSave.addFirst(this._indent);
        this._indent = this._pos;
    }

    public void zeroIndent() {
        this._indentSave.addFirst(this._indent);
        this._indent = 0;
    }

    public void restoreIndent() {
        assert (!this._indentSave.isEmpty());
        this._indent = this._indentSave.removeFirst();
    }

    public void nl() {
        this._out.println();
        this._pos = 0;
        this._separator = true;
        int n = this._indent;
        if (this._useTab) {
            while (n >= 8) {
                n -= 8;
                this._out.print('\t');
                this._pos += 8;
            }
        } else {
            while (n >= this._indentSize) {
                n -= this._indentSize;
                this._out.print("    ");
                this._pos += this._indentSize;
            }
        }
        while (n > 0) {
            --n;
            this._out.print(' ');
            ++this._pos;
        }
        this._out.flush();
    }

    public void sp() {
        if (this._separator) {
            this._out.println();
        }
    }

    public boolean valid() {
        return this._out != null;
    }
}

