/*
 * Decompiled with CFR 0.152.
 */
package IceUtil;

import IceUtil.Store;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

public class Cache {
    private final Map<Object, CacheValue> _map = new HashMap<Object, CacheValue>();
    private final Store _store;

    public Cache(Store store) {
        this._store = store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getIfPinned(Object object) {
        Map<Object, CacheValue> map = this._map;
        synchronized (map) {
            CacheValue cacheValue = this._map.get(object);
            return cacheValue == null ? null : cacheValue.obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unpin(Object object) {
        Map<Object, CacheValue> map = this._map;
        synchronized (map) {
            CacheValue cacheValue = this._map.remove(object);
            return cacheValue == null ? null : cacheValue.obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<Object, CacheValue> map = this._map;
        synchronized (map) {
            this._map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Map<Object, CacheValue> map = this._map;
        synchronized (map) {
            return this._map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object pin(Object object, Object object2) {
        Map<Object, CacheValue> map = this._map;
        synchronized (map) {
            CacheValue cacheValue = this._map.put(object, new CacheValue(object2));
            if (cacheValue != null) {
                this._map.put(object, cacheValue);
                return cacheValue.obj;
            }
            return null;
        }
    }

    public Object pin(Object object) {
        return this.pinImpl(object, null);
    }

    public Object putIfAbsent(Object object, Object object2) {
        return this.pinImpl(object, object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object pinImpl(Object object, Object object2) {
        Object object3;
        CountDownLatch countDownLatch;
        CacheValue cacheValue;
        while (true) {
            cacheValue = null;
            countDownLatch = null;
            object3 = this._map;
            synchronized (object3) {
                cacheValue = this._map.get(object);
                if (cacheValue == null) {
                    cacheValue = new CacheValue();
                    this._map.put(object, cacheValue);
                } else {
                    if (cacheValue.obj != null) {
                        return cacheValue.obj;
                    }
                    if (cacheValue.latch == null) {
                        cacheValue.latch = new CountDownLatch(1);
                    }
                    countDownLatch = cacheValue.latch;
                }
            }
            if (countDownLatch == null) break;
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            object3 = this._store.load(object);
        }
        catch (RuntimeException runtimeException) {
            Map<Object, CacheValue> map = this._map;
            synchronized (map) {
                this._map.remove(object);
                countDownLatch = cacheValue.latch;
                cacheValue.latch = null;
            }
            if (countDownLatch != null) {
                countDownLatch.countDown();
                assert (countDownLatch.getCount() == 0L);
            }
            throw runtimeException;
        }
        Map<Object, CacheValue> map = this._map;
        synchronized (map) {
            if (object3 != null) {
                cacheValue.obj = object3;
            } else if (object2 == null) {
                this._map.remove(object);
            } else {
                cacheValue.obj = object2;
            }
            countDownLatch = cacheValue.latch;
            cacheValue.latch = null;
        }
        if (countDownLatch != null) {
            countDownLatch.countDown();
            assert (countDownLatch.getCount() == 0L);
        }
        return object3;
    }

    private static class CacheValue {
        Object obj = null;
        CountDownLatch latch = null;

        CacheValue() {
        }

        CacheValue(Object object) {
            this.obj = object;
        }
    }
}

