/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CloseConnectionException;
import Ice.CommunicatorDestroyedException;
import Ice.ConnectionInfo;
import Ice.ConnectionLostException;
import Ice.Holder;
import Ice.LocalException;
import Ice.MemoryLimitException;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ProtocolException;
import IceInternal.Buffer;
import IceInternal.EndpointI;
import IceInternal.HttpParser;
import IceInternal.ProtocolInstance;
import IceInternal.Transceiver;
import IceInternal.WSTransceiverDelegate;
import IceInternal.WebSocketException;
import IceUtilInternal.Base64;
import IceUtilInternal.StringUtil;
import java.nio.ByteOrder;
import java.nio.channels.SelectableChannel;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

final class WSTransceiver
implements Transceiver {
    private ProtocolInstance _instance;
    private Transceiver _delegate;
    private String _host;
    private int _port;
    private String _resource;
    private boolean _incoming;
    private static final int StateInitializeDelegate = 0;
    private static final int StateConnected = 1;
    private static final int StateUpgradeRequestPending = 2;
    private static final int StateUpgradeResponsePending = 3;
    private static final int StateOpened = 4;
    private static final int StatePingPending = 5;
    private static final int StatePongPending = 6;
    private static final int StateClosingRequestPending = 7;
    private static final int StateClosingResponsePending = 8;
    private static final int StateClosed = 9;
    private int _state;
    private int _nextState;
    private HttpParser _parser;
    private String _key;
    private static final int ReadStateOpcode = 0;
    private static final int ReadStateHeader = 1;
    private static final int ReadStateControlFrame = 2;
    private static final int ReadStatePayload = 3;
    private int _readState;
    private Buffer _readBuffer;
    private int _readBufferPos;
    private int _readBufferSize;
    private boolean _readLastFrame;
    private int _readOpCode;
    private int _readHeaderLength;
    private int _readPayloadLength;
    private int _readStart;
    private int _readFrameStart;
    private byte[] _readMask;
    private static final int WriteStateHeader = 0;
    private static final int WriteStatePayload = 1;
    private static final int WriteStateControlFrame = 2;
    private static final int WriteStateFlush = 3;
    private int _writeState;
    private Buffer _writeBuffer;
    private int _writeBufferSize;
    private byte[] _writeMask;
    private int _writePayloadLength;
    private boolean _closingInitiator;
    private int _closingReason;
    private byte[] _pingPayload;
    private Random _rand;
    private static final int OP_CONT = 0;
    private static final int OP_TEXT = 1;
    private static final int OP_DATA = 2;
    private static final int OP_RES_0x3 = 3;
    private static final int OP_RES_0x4 = 4;
    private static final int OP_RES_0x5 = 5;
    private static final int OP_RES_0x6 = 6;
    private static final int OP_RES_0x7 = 7;
    private static final int OP_CLOSE = 8;
    private static final int OP_PING = 9;
    private static final int OP_PONG = 10;
    private static final int OP_RES_0xB = 11;
    private static final int OP_RES_0xC = 12;
    private static final int OP_RES_0xD = 13;
    private static final int OP_RES_0xE = 14;
    private static final int OP_RES_0xF = 15;
    private static final int FLAG_FINAL = 128;
    private static final int FLAG_MASKED = 128;
    private static final int CLOSURE_NORMAL = 1000;
    private static final int CLOSURE_SHUTDOWN = 1001;
    private static final int CLOSURE_PROTOCOL_ERROR = 1002;
    private static final int CLOSURE_TOO_BIG = 1009;
    private static final String _iceProtocol = "ice.zeroc.com";
    private static final String _wsUUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    static final Charset _ascii = Charset.forName("US-ASCII");

    @Override
    public SelectableChannel fd() {
        return this._delegate.fd();
    }

    @Override
    public int initialize(Buffer buffer, Buffer buffer2, Holder<Boolean> holder) {
        if (this._state == 0) {
            int n = this._delegate.initialize(buffer, buffer2, holder);
            if (n != 0) {
                return n;
            }
            this._state = 1;
        }
        try {
            block26: {
                block25: {
                    int n;
                    if (this._state == 1) {
                        this._readBuffer.resize(1024, true);
                        this._readBuffer.b.position(0);
                        this._readBufferPos = 0;
                        this._state = 2;
                        if (!this._incoming) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("GET " + this._resource + " HTTP/1.1\r\n");
                            stringBuffer.append("Host: " + this._host + ":");
                            stringBuffer.append(this._port);
                            stringBuffer.append("\r\n");
                            stringBuffer.append("Upgrade: websocket\r\n");
                            stringBuffer.append("Connection: Upgrade\r\n");
                            stringBuffer.append("Sec-WebSocket-Protocol: ice.zeroc.com\r\n");
                            stringBuffer.append("Sec-WebSocket-Version: 13\r\n");
                            stringBuffer.append("Sec-WebSocket-Key: ");
                            byte[] byArray = new byte[16];
                            this._rand.nextBytes(byArray);
                            this._key = Base64.encode(byArray);
                            stringBuffer.append(this._key + "\r\n\r\n");
                            this._writeBuffer.resize(stringBuffer.length(), false);
                            this._writeBuffer.b.position(0);
                            this._writeBuffer.b.put(stringBuffer.toString().getBytes(_ascii));
                            this._writeBuffer.b.flip();
                        }
                    }
                    if (this._state == 2 && !this._incoming) {
                        int n2;
                        if (this._writeBuffer.b.hasRemaining() && (n2 = this._delegate.write(this._writeBuffer)) != 0) {
                            return n2;
                        }
                        assert (!this._writeBuffer.b.hasRemaining());
                        this._state = 3;
                    }
                    while (true) {
                        int n3;
                        if (this._readBuffer.b.hasRemaining() && ((n3 = this._delegate.read(this._readBuffer, holder)) == 4 || this._readBuffer.b.position() == 0)) {
                            return n3;
                        }
                        if ((this._state != 2 || !this._incoming) && (this._state != 3 || this._incoming)) break block25;
                        n = this._parser.isCompleteMessage(this._readBuffer.b, 0, this._readBuffer.b.position());
                        if (n != -1) break;
                        if (this._readBuffer.b.hasRemaining()) {
                            return 1;
                        }
                        int n4 = this._readBuffer.b.position();
                        if (n4 + 1024 > this._instance.messageSizeMax()) {
                            throw new MemoryLimitException();
                        }
                        this._readBuffer.resize(n4 + 1024, true);
                        this._readBuffer.b.position(n4);
                    }
                    this._readBufferPos = n;
                }
                try {
                    if (this._state == 2 && this._incoming) {
                        if (this._parser.parse(this._readBuffer.b, 0, this._readBufferPos)) {
                            this.handleRequest(this._writeBuffer);
                            this._state = 3;
                        } else {
                            throw new ProtocolException("incomplete request message");
                        }
                    }
                    if (this._state != 3) break block26;
                    if (this._incoming) {
                        int n;
                        if (this._writeBuffer.b.hasRemaining() && (n = this._delegate.write(this._writeBuffer)) != 0) {
                            return n;
                        }
                        break block26;
                    }
                    if (this._parser.parse(this._readBuffer.b, 0, this._readBufferPos)) {
                        this.handleResponse();
                        break block26;
                    }
                    throw new ProtocolException("incomplete response message");
                }
                catch (WebSocketException webSocketException) {
                    throw new ProtocolException(webSocketException.getMessage());
                }
            }
            this._state = 4;
            this._nextState = 4;
            holder.value = this._readBufferPos < this._readBuffer.b.position() || (Boolean)holder.value != false;
        }
        catch (LocalException localException) {
            if (this._instance.traceLevel() >= 2) {
                this._instance.logger().trace(this._instance.traceCategory(), this.protocol() + " connection HTTP upgrade request failed\n" + this.toString() + "\n" + localException);
            }
            throw localException;
        }
        if (this._instance.traceLevel() >= 1) {
            if (this._incoming) {
                this._instance.logger().trace(this._instance.traceCategory(), "accepted " + this.protocol() + " connection HTTP upgrade request\n" + this.toString());
            } else {
                this._instance.logger().trace(this._instance.traceCategory(), this.protocol() + " connection HTTP upgrade request accepted\n" + this.toString());
            }
        }
        return 0;
    }

    @Override
    public int closing(boolean bl, LocalException localException) {
        int n;
        if (this._instance.traceLevel() >= 1) {
            this._instance.logger().trace(this._instance.traceCategory(), "gracefully closing " + this.protocol() + " connection\n" + this.toString());
        }
        int n2 = n = this._nextState == 4 ? this._state : this._nextState;
        if (n == 7 && this._closingInitiator) {
            assert (!bl);
            this._closingInitiator = false;
            return 4;
        }
        if (n >= 7) {
            return 0;
        }
        this._closingInitiator = bl;
        if (localException instanceof CloseConnectionException) {
            this._closingReason = 1000;
        } else if (localException instanceof ObjectAdapterDeactivatedException || localException instanceof CommunicatorDestroyedException) {
            this._closingReason = 1001;
        } else if (localException instanceof ProtocolException) {
            this._closingReason = 1002;
        } else if (localException instanceof MemoryLimitException) {
            this._closingReason = 1009;
        }
        if (this._state == 4) {
            this._state = 7;
            return bl ? 1 : 4;
        }
        this._nextState = 7;
        return 0;
    }

    @Override
    public void close() {
        this._delegate.close();
        this._state = 9;
        this._writeBuffer.clear();
        this._readBuffer.clear();
    }

    @Override
    public EndpointI bind() {
        assert (false);
        return null;
    }

    @Override
    public int write(Buffer buffer) {
        if (this._state < 4) {
            if (this._state < 1) {
                return this._delegate.write(buffer);
            }
            return this._delegate.write(this._writeBuffer);
        }
        int n = 0;
        do {
            if (!this.preWrite(buffer)) continue;
            if (this._writeState == 3) {
                assert (!buffer.b.hasRemaining());
                n = this._delegate.write(buffer);
            }
            if (n == 0 && this._writeBuffer.b.hasRemaining()) {
                n = this._delegate.write(this._writeBuffer);
                continue;
            }
            if (n != 0 || !this._incoming || buffer.empty() || this._writeState != 1) continue;
            n = this._delegate.write(buffer);
        } while (this.postWrite(buffer, n));
        if (n != 0) {
            return n;
        }
        if (this._state == 8 && !this._closingInitiator) {
            return 1;
        }
        return 0;
    }

    @Override
    public int read(Buffer buffer, Holder<Boolean> holder) {
        if (this._state < 4) {
            if (this._state < 1) {
                return this._delegate.read(buffer, holder);
            }
            if (this._delegate.read(this._readBuffer, holder) == 4) {
                return 4;
            }
            return 0;
        }
        if (!buffer.b.hasRemaining()) {
            Holder<Boolean> holder2 = holder;
            holder2.value = (Boolean)holder2.value | this._readBufferPos < this._readBuffer.b.position();
            return 0;
        }
        int n = 0;
        do {
            if (!this.preRead(buffer)) continue;
            if (this._readState == 3) {
                int n2 = this._readPayloadLength - (buffer.b.position() - this._readStart);
                if (buffer.b.remaining() > n2) {
                    int n3 = buffer.size();
                    buffer.resize(buffer.b.position() + n2, true);
                    n = this._delegate.read(buffer, holder);
                    buffer.resize(n3, true);
                } else {
                    n = this._delegate.read(buffer, holder);
                }
            } else {
                n = this._delegate.read(this._readBuffer, holder);
            }
            if (n != 4) continue;
            this.postRead(buffer);
            return n;
        } while (this.postRead(buffer));
        if (!buffer.b.hasRemaining()) {
            Holder<Boolean> holder3 = holder;
            holder3.value = (Boolean)holder3.value | this._readBufferPos < this._readBuffer.b.position();
            n = 0;
        } else {
            holder.value = false;
            n = 1;
        }
        if ((this._state == 7 && !this._closingInitiator || this._state == 8 && this._closingInitiator || this._state == 5 || this._state == 6) && this._writeState == 0) {
            n |= 4;
        }
        return n;
    }

    @Override
    public String protocol() {
        return this._instance.protocol();
    }

    @Override
    public String toString() {
        return this._delegate.toString();
    }

    @Override
    public String toDetailedString() {
        return this._delegate.toDetailedString();
    }

    @Override
    public ConnectionInfo getInfo() {
        assert (this._delegate instanceof WSTransceiverDelegate);
        return ((WSTransceiverDelegate)((Object)this._delegate)).getWSInfo(this._parser.getHeaders());
    }

    @Override
    public void checkSendSize(Buffer buffer) {
        this._delegate.checkSendSize(buffer);
    }

    @Override
    public void setBufferSize(int n, int n2) {
        this._delegate.setBufferSize(n, n2);
    }

    WSTransceiver(ProtocolInstance protocolInstance, Transceiver transceiver, String string, int n, String string2) {
        this.init(protocolInstance, transceiver);
        this._host = string;
        this._port = n;
        this._resource = string2;
        this._incoming = false;
        this._writeBufferSize = 16384;
        assert (this._writeBufferSize > 256);
        assert (this._readBufferSize > 256);
    }

    WSTransceiver(ProtocolInstance protocolInstance, Transceiver transceiver) {
        this.init(protocolInstance, transceiver);
        this._host = "";
        this._port = -1;
        this._resource = "";
        this._incoming = true;
        assert (this._writeBufferSize > 256);
        assert (this._readBufferSize > 256);
    }

    private void init(ProtocolInstance protocolInstance, Transceiver transceiver) {
        this._instance = protocolInstance;
        this._delegate = transceiver;
        this._state = 0;
        this._parser = new HttpParser();
        this._readState = 0;
        this._readBuffer = new Buffer(false, ByteOrder.BIG_ENDIAN);
        this._readBufferSize = 1024;
        this._readLastFrame = true;
        this._readOpCode = 0;
        this._readHeaderLength = 0;
        this._readPayloadLength = 0;
        this._readMask = new byte[4];
        this._writeState = 0;
        this._writeBuffer = new Buffer(false, ByteOrder.BIG_ENDIAN);
        this._writeBufferSize = 1024;
        this._readMask = new byte[4];
        this._writeMask = new byte[4];
        this._key = "";
        this._pingPayload = new byte[0];
        this._rand = new Random();
    }

    private void handleRequest(Buffer buffer) {
        Object object2;
        if (this._parser.versionMajor() != 1 || this._parser.versionMinor() != 1) {
            throw new WebSocketException("unsupported HTTP version");
        }
        String string = this._parser.getHeader("Upgrade", true);
        if (string == null) {
            throw new WebSocketException("missing value for Upgrade field");
        }
        if (!string.equals("websocket")) {
            throw new WebSocketException("invalid value `" + string + "' for Upgrade field");
        }
        string = this._parser.getHeader("Connection", true);
        if (string == null) {
            throw new WebSocketException("missing value for Connection field");
        }
        if (string.indexOf("upgrade") == -1) {
            throw new WebSocketException("invalid value `" + string + "' for Connection field");
        }
        string = this._parser.getHeader("Sec-WebSocket-Version", false);
        if (string == null) {
            throw new WebSocketException("missing value for WebSocket version");
        }
        if (!string.equals("13")) {
            throw new WebSocketException("unsupported WebSocket version `" + string + "'");
        }
        boolean bl = false;
        string = this._parser.getHeader("Sec-WebSocket-Protocol", true);
        if (string != null) {
            object2 = StringUtil.splitString(string, ",");
            if (object2 == null) {
                throw new WebSocketException("invalid value `" + string + "' for WebSocket protocol");
            }
            for (String noSuchAlgorithmException : object2) {
                if (!noSuchAlgorithmException.trim().equals(_iceProtocol)) {
                    throw new WebSocketException("unknown value `" + noSuchAlgorithmException + "' for WebSocket protocol");
                }
                bl = true;
            }
        }
        if ((object2 = this._parser.getHeader("Sec-WebSocket-Key", false)) == null) {
            throw new WebSocketException("missing value for WebSocket key");
        }
        byte[] byArray = Base64.decode((String)object2);
        if (byArray.length != 16) {
            throw new WebSocketException("invalid value `" + (String)object2 + "' for WebSocket key");
        }
        this._resource = this._parser.uri();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HTTP/1.1 101 Switching Protocols\r\n");
        stringBuffer.append("Upgrade: websocket\r\n");
        stringBuffer.append("Connection: Upgrade\r\n");
        if (bl) {
            stringBuffer.append("Sec-WebSocket-Protocol: ice.zeroc.com\r\n");
        }
        stringBuffer.append("Sec-WebSocket-Accept: ");
        String string2 = (String)object2 + _wsUUID;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.update(string2.getBytes(_ascii));
            byte[] byArray2 = messageDigest.digest();
            stringBuffer.append(Base64.encode(byArray2) + "\r\n\r\n");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new WebSocketException(noSuchAlgorithmException);
        }
        byte[] byArray3 = stringBuffer.toString().getBytes(_ascii);
        assert (byArray3.length == stringBuffer.length());
        buffer.resize(byArray3.length, false);
        buffer.b.position(0);
        buffer.b.put(byArray3);
        buffer.b.flip();
    }

    private void handleResponse() {
        if (this._parser.versionMajor() != 1 || this._parser.versionMinor() != 1) {
            throw new WebSocketException("unsupported HTTP version");
        }
        if (this._parser.status() != 101) {
            StringBuffer stringBuffer = new StringBuffer("unexpected status value " + this._parser.status());
            if (this._parser.reason().length() > 0) {
                stringBuffer.append(":\n" + this._parser.reason());
            }
            throw new WebSocketException(stringBuffer.toString());
        }
        String string = this._parser.getHeader("Upgrade", true);
        if (string == null) {
            throw new WebSocketException("missing value for Upgrade field");
        }
        if (!string.equals("websocket")) {
            throw new WebSocketException("invalid value `" + string + "' for Upgrade field");
        }
        string = this._parser.getHeader("Connection", true);
        if (string == null) {
            throw new WebSocketException("missing value for Connection field");
        }
        if (string.indexOf("upgrade") == -1) {
            throw new WebSocketException("invalid value `" + string + "' for Connection field");
        }
        string = this._parser.getHeader("Sec-WebSocket-Protocol", true);
        if (string != null && !string.equals(_iceProtocol)) {
            throw new WebSocketException("invalid value `" + string + "' for WebSocket protocol");
        }
        string = this._parser.getHeader("Sec-WebSocket-Accept", false);
        if (string == null) {
            throw new WebSocketException("missing value for Sec-WebSocket-Accept");
        }
        try {
            String string2 = this._key + _wsUUID;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.update(string2.getBytes(_ascii));
            if (!string.equals(Base64.encode(messageDigest.digest()))) {
                throw new WebSocketException("invalid value `" + string + "' for Sec-WebSocket-Accept");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new WebSocketException(noSuchAlgorithmException);
        }
    }

    private boolean preRead(Buffer buffer) {
        int n;
        do {
            if (this._readState == 0) {
                int n2;
                if (!this.readBuffered(2)) {
                    return true;
                }
                if ((n2 = this._readBuffer.b.get(this._readBufferPos++)) < 0) {
                    n2 += 256;
                }
                this._readOpCode = n2 & 0xF;
                if (this._readOpCode == 2) {
                    if (!this._readLastFrame) {
                        throw new ProtocolException("invalid data frame, no FIN on previous frame");
                    }
                    this._readLastFrame = (n2 & 0x80) == 128;
                } else if (this._readOpCode == 0) {
                    if (this._readLastFrame) {
                        throw new ProtocolException("invalid continuation frame, previous frame FIN set");
                    }
                    this._readLastFrame = (n2 & 0x80) == 128;
                }
                n2 = this._readBuffer.b.get(this._readBufferPos++);
                if (n2 < 0) {
                    n2 += 256;
                }
                int n3 = n = (n2 & 0x80) == 128 ? 1 : 0;
                if (n != this._incoming) {
                    throw new ProtocolException("invalid masking");
                }
                this._readPayloadLength = n2 & 0x7F;
                this._readHeaderLength = this._readPayloadLength < 126 ? 0 : (this._readPayloadLength == 126 ? 2 : 8);
                if (n != 0) {
                    this._readHeaderLength += 4;
                }
                this._readState = 1;
            }
            if (this._readState == 1) {
                if (this._readHeaderLength > 0 && !this.readBuffered(this._readHeaderLength)) {
                    return true;
                }
                if (this._readPayloadLength == 126) {
                    this._readPayloadLength = this._readBuffer.b.getShort(this._readBufferPos);
                    if (this._readPayloadLength < 0) {
                        this._readPayloadLength += 65536;
                    }
                    this._readBufferPos += 2;
                } else if (this._readPayloadLength == 127) {
                    long l = this._readBuffer.b.getLong(this._readBufferPos);
                    this._readBufferPos += 8;
                    if (l < 0L || l > Integer.MAX_VALUE) {
                        throw new ProtocolException("invalid WebSocket payload length: " + l);
                    }
                    this._readPayloadLength = (int)l;
                }
                if (this._incoming) {
                    assert (this._readBuffer.b.position() - this._readBufferPos >= 4);
                    for (int i = 0; i < 4; ++i) {
                        this._readMask[i] = this._readBuffer.b.get(this._readBufferPos++);
                    }
                }
                switch (this._readOpCode) {
                    case 1: {
                        throw new ProtocolException("text frames not supported");
                    }
                    case 0: 
                    case 2: {
                        if (this._instance.traceLevel() >= 2) {
                            this._instance.logger().trace(this._instance.traceCategory(), "received " + this.protocol() + (this._readOpCode == 2 ? " data" : " continuation") + " frame with payload length of " + this._readPayloadLength + " bytes\n" + this.toString());
                        }
                        if (this._readPayloadLength <= 0) {
                            throw new ProtocolException("payload length is 0");
                        }
                        this._readState = 3;
                        assert (buffer.b.hasRemaining());
                        this._readFrameStart = buffer.b.position();
                        break;
                    }
                    case 8: {
                        int n4;
                        if (this._instance.traceLevel() >= 2) {
                            this._instance.logger().trace(this._instance.traceCategory(), "received " + this.protocol() + " connection close frame\n" + this.toString());
                        }
                        int n5 = n4 = this._nextState == 4 ? this._state : this._nextState;
                        if (n4 == 7) {
                            if (!this._closingInitiator) {
                                this._closingInitiator = true;
                            }
                            if (this._state == 7) {
                                this._state = 8;
                            } else {
                                this._nextState = 8;
                            }
                            return false;
                        }
                        throw new ConnectionLostException();
                    }
                    case 9: {
                        if (this._instance.traceLevel() >= 2) {
                            this._instance.logger().trace(this._instance.traceCategory(), "received " + this.protocol() + " connection ping frame\n" + this.toString());
                        }
                        this._readState = 2;
                        break;
                    }
                    case 10: {
                        if (this._instance.traceLevel() >= 2) {
                            this._instance.logger().trace(this._instance.traceCategory(), "received " + this.protocol() + " connection pong frame\n" + this.toString());
                        }
                        this._readState = 2;
                        break;
                    }
                    default: {
                        throw new ProtocolException("unsupported opcode: " + this._readOpCode);
                    }
                }
            }
            if (this._readState != 2) continue;
            if (this._readPayloadLength > 0 && !this.readBuffered(this._readPayloadLength)) {
                return true;
            }
            if (this._readPayloadLength > 0 && this._readOpCode == 9) {
                this._pingPayload = new byte[this._readPayloadLength];
                if (this._readBuffer.b.hasArray()) {
                    System.arraycopy(this._readBuffer.b.array(), this._readBuffer.b.arrayOffset() + this._readBufferPos, this._pingPayload, 0, this._readPayloadLength);
                } else {
                    for (int i = 0; i < this._readPayloadLength; ++i) {
                        this._pingPayload[i] = this._readBuffer.b.get(this._readBufferPos + i);
                    }
                }
            }
            this._readBufferPos += this._readPayloadLength;
            this._readPayloadLength = 0;
            if (this._readOpCode == 9) {
                if (this._state == 4) {
                    this._state = 6;
                } else if (this._nextState < 6) {
                    this._nextState = 6;
                }
            }
            this._readState = 0;
        } while (this._readState != 3);
        this._readStart = buffer.b.position();
        if (buffer.empty() || !buffer.b.hasRemaining()) {
            return false;
        }
        int n6 = Math.min(this._readBuffer.b.position() - this._readBufferPos, buffer.b.remaining());
        if (n6 > this._readPayloadLength) {
            n6 = this._readPayloadLength;
        }
        if (n6 > 0) {
            if (buffer.b.hasArray() && this._readBuffer.b.hasArray()) {
                System.arraycopy(this._readBuffer.b.array(), this._readBuffer.b.arrayOffset() + this._readBufferPos, buffer.b.array(), buffer.b.arrayOffset() + buffer.b.position(), n6);
                buffer.b.position(buffer.b.position() + n6);
            } else {
                for (n = 0; n < n6; ++n) {
                    buffer.b.put(this._readBuffer.b.get(this._readBufferPos + n));
                }
            }
            this._readBufferPos += n6;
        }
        return buffer.b.hasRemaining() && n6 < this._readPayloadLength;
    }

    private boolean postRead(Buffer buffer) {
        if (this._readState != 3) {
            return this._readStart < this._readBuffer.b.position();
        }
        if (this._readStart == buffer.b.position()) {
            return false;
        }
        assert (this._readStart < buffer.b.position());
        if (this._incoming) {
            int n = buffer.b.position();
            if (buffer.b.hasArray()) {
                byte[] byArray = buffer.b.array();
                int n2 = buffer.b.arrayOffset();
                for (int i = this._readStart; i < n; ++i) {
                    byArray[i + n2] = (byte)(byArray[i + n2] ^ this._readMask[(i - this._readFrameStart) % 4]);
                }
            } else {
                for (int i = this._readStart; i < n; ++i) {
                    byte by = (byte)(buffer.b.get(i) ^ this._readMask[(i - this._readFrameStart) % 4]);
                    buffer.b.put(i, by);
                }
            }
        }
        this._readPayloadLength -= buffer.b.position() - this._readStart;
        this._readStart = buffer.b.position();
        if (this._readPayloadLength == 0) {
            this._readState = 0;
        }
        return buffer.b.hasRemaining();
    }

    private boolean preWrite(Buffer buffer) {
        int n;
        int n2;
        if (this._writeState == 0) {
            if (this._state == 4) {
                if (buffer.empty() || !buffer.b.hasRemaining()) {
                    return false;
                }
                assert (buffer.b.position() == 0);
                this.prepareWriteHeader((byte)2, buffer.size());
                this._writeState = 1;
            } else if (this._state == 5) {
                this.prepareWriteHeader((byte)9, 0);
                this._writeState = 2;
                this._writeBuffer.b.flip();
            } else if (this._state == 6) {
                this.prepareWriteHeader((byte)10, this._pingPayload.length);
                if (this._pingPayload.length > this._writeBuffer.b.remaining()) {
                    n2 = this._writeBuffer.b.position();
                    this._writeBuffer.resize(n2 + this._pingPayload.length, false);
                    this._writeBuffer.b.position(n2);
                }
                this._writeBuffer.b.put(this._pingPayload);
                this._pingPayload = new byte[0];
                this._writeState = 2;
                this._writeBuffer.b.flip();
            } else if (this._state == 7 && !this._closingInitiator || this._state == 8 && this._closingInitiator) {
                this.prepareWriteHeader((byte)8, 2);
                this._writeBuffer.b.putShort((short)this._closingReason);
                if (!this._incoming) {
                    n = this._writeBuffer.b.position() - 2;
                    n2 = (byte)(this._writeBuffer.b.get(n) ^ this._writeMask[0]);
                    this._writeBuffer.b.put(n, (byte)n2);
                    n2 = (byte)(this._writeBuffer.b.get(++n) ^ this._writeMask[1]);
                    this._writeBuffer.b.put(n, (byte)n2);
                }
                this._writeState = 2;
                this._writeBuffer.b.flip();
            } else {
                assert (this._state != 9);
                return false;
            }
            this._writePayloadLength = 0;
        }
        if (this._writeState == 1) {
            if (!(this._incoming || this._writePayloadLength != 0 && this._writeBuffer.b.hasRemaining())) {
                if (!this._writeBuffer.b.hasRemaining()) {
                    this._writeBuffer.b.position(0);
                }
                n = buffer.size();
                if (buffer.b.hasArray() && this._writeBuffer.b.hasArray()) {
                    int n3 = this._writeBuffer.b.position();
                    int n4 = Math.min(n - n2, this._writeBuffer.b.remaining());
                    byte[] byArray = buffer.b.array();
                    int n5 = buffer.b.arrayOffset();
                    byte[] byArray2 = this._writeBuffer.b.array();
                    int n6 = this._writeBuffer.b.arrayOffset();
                    int n7 = 0;
                    while (n7 < n4) {
                        byArray2[n6 + n3] = (byte)(byArray[n5 + n2] ^ this._writeMask[n2 % 4]);
                        ++n7;
                        ++n2;
                        ++n3;
                    }
                    this._writeBuffer.b.position(n3);
                } else {
                    for (n2 = buffer.b.position(); n2 < n && this._writeBuffer.b.hasRemaining(); ++n2) {
                        byte by = (byte)(buffer.b.get(n2) ^ this._writeMask[n2 % 4]);
                        this._writeBuffer.b.put(by);
                    }
                }
                this._writePayloadLength = n2;
                this._writeBuffer.b.flip();
            } else if (this._writePayloadLength == 0) {
                assert (this._incoming);
                if (this._writeBuffer.b.hasRemaining()) {
                    assert (buffer.b.position() == 0);
                    n2 = this._writeBuffer.b.remaining();
                    if (buffer.b.remaining() > n2) {
                        n = buffer.b.limit();
                        buffer.b.limit(n2);
                        this._writeBuffer.b.put(buffer.b);
                        buffer.b.limit(n);
                        this._writePayloadLength = n2;
                    } else {
                        this._writePayloadLength = buffer.b.remaining();
                        this._writeBuffer.b.put(buffer.b);
                    }
                    buffer.b.position(0);
                }
                this._writeBuffer.b.flip();
            }
            return true;
        }
        if (this._writeState == 2) {
            return this._writeBuffer.b.hasRemaining();
        }
        assert (this._writeState == 3);
        return true;
    }

    private boolean postWrite(Buffer buffer, int n) {
        if (this._state > 4 && this._writeState == 2) {
            if (!this._writeBuffer.b.hasRemaining()) {
                if (this._state == 5) {
                    if (this._instance.traceLevel() >= 2) {
                        this._instance.logger().trace(this._instance.traceCategory(), "sent " + this.protocol() + " connection ping frame\n" + this.toString());
                    }
                } else if (this._state == 6) {
                    if (this._instance.traceLevel() >= 2) {
                        this._instance.logger().trace(this._instance.traceCategory(), "sent " + this.protocol() + " connection pong frame\n" + this.toString());
                    }
                } else {
                    if (this._state == 7 && !this._closingInitiator || this._state == 8 && this._closingInitiator) {
                        if (this._instance.traceLevel() >= 2) {
                            this._instance.logger().trace(this._instance.traceCategory(), "sent " + this.protocol() + " connection close frame\n" + this.toString());
                        }
                        if (this._state == 7 && !this._closingInitiator) {
                            this._writeState = 0;
                            this._state = 8;
                            return false;
                        }
                        throw new ConnectionLostException();
                    }
                    if (this._state == 9) {
                        return false;
                    }
                }
                this._state = this._nextState;
                this._nextState = 4;
                this._writeState = 0;
            } else {
                return n == 0;
            }
        }
        if (!(this._incoming && buffer.b.position() != 0 || this._writePayloadLength <= 0 || this._writeBuffer.b.hasRemaining())) {
            buffer.b.position(this._writePayloadLength);
        }
        if (n == 4 && !buffer.b.hasRemaining() && !this._writeBuffer.b.hasRemaining()) {
            this._writeState = 3;
            return false;
        }
        if (!buffer.b.hasRemaining()) {
            this._writeState = 0;
            if (this._state == 5 || this._state == 6 || this._state == 7 && !this._closingInitiator || this._state == 8 && this._closingInitiator) {
                return true;
            }
        } else if (this._state == 4) {
            return n == 0;
        }
        return false;
    }

    private boolean readBuffered(int n) {
        if (this._readBufferPos == this._readBuffer.b.position()) {
            this._readBuffer.resize(this._readBufferSize, true);
            this._readBufferPos = 0;
            this._readBuffer.b.position(0);
        } else {
            int n2 = this._readBuffer.b.position() - this._readBufferPos;
            if (n2 < n) {
                if (this._readBufferPos > 0) {
                    this._readBuffer.b.limit(this._readBuffer.b.position());
                    this._readBuffer.b.position(this._readBufferPos);
                    this._readBuffer.b.compact();
                    assert (this._readBuffer.b.position() == n2);
                }
                this._readBuffer.resize(Math.max(this._readBufferSize, n), true);
                this._readBufferPos = 0;
                this._readBuffer.b.position(n2);
            }
        }
        this._readStart = this._readBuffer.b.position();
        if (this._readBufferPos + n > this._readBuffer.b.position()) {
            return false;
        }
        assert (this._readBuffer.b.position() > this._readBufferPos);
        return true;
    }

    private void prepareWriteHeader(byte by, int n) {
        this._writeBuffer.resize(this._writeBufferSize, false);
        this._writeBuffer.b.limit(this._writeBufferSize);
        this._writeBuffer.b.position(0);
        this._writeBuffer.b.put((byte)(by | 0x80));
        if (n <= 125) {
            this._writeBuffer.b.put((byte)n);
        } else if (n > 125 && n <= 65535) {
            this._writeBuffer.b.put((byte)126);
            this._writeBuffer.b.putShort((short)n);
        } else if (n > 65535) {
            this._writeBuffer.b.put((byte)127);
            this._writeBuffer.b.putLong(n);
        }
        if (!this._incoming) {
            this._writeBuffer.b.put(1, (byte)(this._writeBuffer.b.get(1) | 0x80));
            this._rand.nextBytes(this._writeMask);
            this._writeBuffer.b.put(this._writeMask);
        }
    }
}

