/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.EndpointInfo;
import Ice.EndpointParseException;
import Ice.EndpointSelectionType;
import Ice.LocalException;
import IceInternal.Acceptor;
import IceInternal.BasicStream;
import IceInternal.Connector;
import IceInternal.EndpointI;
import IceInternal.EndpointI_connectors;
import IceInternal.HashUtil;
import IceInternal.IPEndpointI;
import IceInternal.ProtocolInstance;
import IceInternal.Transceiver;
import IceInternal.WSAcceptor;
import IceInternal.WSConnector;
import IceInternal.WSEndpointDelegate;
import java.util.ArrayList;
import java.util.List;

final class WSEndpoint
extends EndpointI {
    private ProtocolInstance _instance;
    private IPEndpointI _delegate;
    private String _resource;

    public WSEndpoint(ProtocolInstance protocolInstance, EndpointI endpointI, String string) {
        this._instance = protocolInstance;
        this._delegate = (IPEndpointI)endpointI;
        this._resource = string;
    }

    public WSEndpoint(ProtocolInstance protocolInstance, EndpointI endpointI, ArrayList<String> arrayList) {
        this._instance = protocolInstance;
        this._delegate = (IPEndpointI)endpointI;
        this.initWithOptions(arrayList);
        if (this._resource == null) {
            this._resource = "/";
        }
    }

    public WSEndpoint(ProtocolInstance protocolInstance, EndpointI endpointI, BasicStream basicStream) {
        this._instance = protocolInstance;
        this._delegate = (IPEndpointI)endpointI;
        this._resource = basicStream.readString();
    }

    @Override
    public EndpointInfo getInfo() {
        assert (this._delegate instanceof WSEndpointDelegate);
        return ((WSEndpointDelegate)((Object)this._delegate)).getWSInfo(this._resource);
    }

    @Override
    public short type() {
        return this._delegate.type();
    }

    @Override
    public String protocol() {
        return this._delegate.protocol();
    }

    @Override
    public void streamWrite(BasicStream basicStream) {
        basicStream.startWriteEncaps();
        this._delegate.streamWriteImpl(basicStream);
        basicStream.writeString(this._resource);
        basicStream.endWriteEncaps();
    }

    @Override
    public int timeout() {
        return this._delegate.timeout();
    }

    @Override
    public EndpointI timeout(int n) {
        if (n == this._delegate.timeout()) {
            return this;
        }
        return new WSEndpoint(this._instance, this._delegate.timeout(n), this._resource);
    }

    @Override
    public String connectionId() {
        return this._delegate.connectionId();
    }

    @Override
    public EndpointI connectionId(String string) {
        if (string.equals(this._delegate.connectionId())) {
            return this;
        }
        return new WSEndpoint(this._instance, this._delegate.connectionId(string), this._resource);
    }

    @Override
    public boolean compress() {
        return this._delegate.compress();
    }

    @Override
    public EndpointI compress(boolean bl) {
        if (bl == this._delegate.compress()) {
            return this;
        }
        return new WSEndpoint(this._instance, this._delegate.compress(bl), this._resource);
    }

    @Override
    public boolean datagram() {
        return this._delegate.datagram();
    }

    @Override
    public boolean secure() {
        return this._delegate.secure();
    }

    @Override
    public Transceiver transceiver() {
        return null;
    }

    @Override
    public void connectors_async(EndpointSelectionType endpointSelectionType, final EndpointI_connectors endpointI_connectors) {
        EndpointI_connectors endpointI_connectors2 = new EndpointI_connectors(){

            @Override
            public void connectors(List<Connector> list) {
                ArrayList<Connector> arrayList = new ArrayList<Connector>();
                for (Connector connector : list) {
                    arrayList.add(new WSConnector(WSEndpoint.this._instance, connector, WSEndpoint.this._delegate.host(), WSEndpoint.this._delegate.port(), WSEndpoint.this._resource));
                }
                endpointI_connectors.connectors(arrayList);
            }

            @Override
            public void exception(LocalException localException) {
                endpointI_connectors.exception(localException);
            }
        };
        this._delegate.connectors_async(endpointSelectionType, endpointI_connectors2);
    }

    @Override
    public Acceptor acceptor(String string) {
        Acceptor acceptor = this._delegate.acceptor(string);
        return new WSAcceptor(this, this._instance, acceptor);
    }

    public WSEndpoint endpoint(EndpointI endpointI) {
        return new WSEndpoint(this._instance, endpointI, this._resource);
    }

    @Override
    public List<EndpointI> expand() {
        List<EndpointI> list = this._delegate.expand();
        ArrayList<EndpointI> arrayList = new ArrayList<EndpointI>();
        for (EndpointI endpointI : list) {
            arrayList.add(endpointI == this._delegate ? this : new WSEndpoint(this._instance, endpointI, this._resource));
        }
        return arrayList;
    }

    @Override
    public boolean equivalent(EndpointI endpointI) {
        if (!(endpointI instanceof WSEndpoint)) {
            return false;
        }
        WSEndpoint wSEndpoint = (WSEndpoint)endpointI;
        return this._delegate.equivalent(wSEndpoint._delegate);
    }

    public synchronized int hashCode() {
        int n = this._delegate.hashCode();
        n = HashUtil.hashAdd(n, this._resource);
        return n;
    }

    @Override
    public String options() {
        String string = this._delegate.options();
        if (this._resource != null && this._resource.length() > 0) {
            boolean bl;
            string = string + " -r ";
            boolean bl2 = bl = this._resource.indexOf(58) != -1;
            if (bl) {
                string = string + "\"";
            }
            string = string + this._resource;
            if (bl) {
                string = string + "\"";
            }
        }
        return string;
    }

    @Override
    public int compareTo(EndpointI endpointI) {
        if (!(endpointI instanceof WSEndpoint)) {
            return this.type() < endpointI.type() ? -1 : 1;
        }
        WSEndpoint wSEndpoint = (WSEndpoint)endpointI;
        if (this == wSEndpoint) {
            return 0;
        }
        int n = this._resource.compareTo(wSEndpoint._resource);
        if (n != 0) {
            return n;
        }
        return this._delegate.compareTo(wSEndpoint._delegate);
    }

    public EndpointI delegate() {
        return this._delegate;
    }

    @Override
    protected boolean checkOption(String string, String string2, String string3) {
        switch (string.charAt(1)) {
            case 'r': {
                if (string2 == null) {
                    throw new EndpointParseException("no argument provided for -r option in endpoint " + string3 + this._delegate.options());
                }
                this._resource = string2;
                return true;
            }
        }
        return false;
    }
}

