/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Object;
import Ice.ObjectPrxHelperBase;
import IceUtilInternal.OutputBase;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;

public final class ValueWriter {
    public static void write(java.lang.Object object, OutputBase outputBase) {
        ValueWriter.writeValue(null, object, null, outputBase);
    }

    private static void writeValue(String string, java.lang.Object object, Map<java.lang.Object, java.lang.Object> map, OutputBase outputBase) {
        if (object == null) {
            ValueWriter.writeName(string, outputBase);
            outputBase.print("(null)");
        } else {
            Class<?> clazz = object.getClass();
            if (clazz.equals(Byte.class) || clazz.equals(Short.class) || clazz.equals(Integer.class) || clazz.equals(Long.class) || clazz.equals(Double.class) || clazz.equals(Float.class) || clazz.equals(Boolean.class)) {
                ValueWriter.writeName(string, outputBase);
                outputBase.print(object.toString());
            } else if (clazz.equals(String.class)) {
                int n;
                ValueWriter.writeName(string, outputBase);
                outputBase.print("\"");
                outputBase.useCurrentPosAsIndent();
                String string2 = object.toString();
                int n2 = 0;
                while (n2 < string2.length() && (n = string2.indexOf(10, n2)) != -1) {
                    outputBase.print(string2.substring(n2, n));
                    outputBase.nl();
                    n2 = n + 1;
                }
                if (n2 < string2.length()) {
                    outputBase.print(string2.substring(n2));
                }
                outputBase.print("\"");
                outputBase.restoreIndent();
            } else if (clazz.isArray()) {
                int n = Array.getLength(object);
                for (int i = 0; i < n; ++i) {
                    String string3 = string != null ? string : "";
                    string3 = string3 + "[" + i + "]";
                    ValueWriter.writeValue(string3, Array.get(object, i), map, outputBase);
                }
            } else if (object instanceof Map) {
                Map map2 = (Map)object;
                for (Map.Entry entry : map2.entrySet()) {
                    String string4 = string != null ? string + "." : "";
                    ValueWriter.writeValue(string4 + "key", entry.getKey(), map, outputBase);
                    ValueWriter.writeValue(string4 + "value", entry.getValue(), map, outputBase);
                }
            } else if (object instanceof ObjectPrxHelperBase) {
                ValueWriter.writeName(string, outputBase);
                ObjectPrxHelperBase objectPrxHelperBase = (ObjectPrxHelperBase)object;
                outputBase.print(objectPrxHelperBase.__reference().toString());
            } else if (object instanceof Object) {
                if (map != null && map.containsKey(object)) {
                    ValueWriter.writeName(string, outputBase);
                    outputBase.print("(recursive)");
                } else {
                    if (map == null) {
                        map = new IdentityHashMap<java.lang.Object, java.lang.Object>();
                    }
                    map.put(object, null);
                    ValueWriter.writeFields(string, object, clazz, map, outputBase);
                }
            } else if (object instanceof Enum) {
                ValueWriter.writeName(string, outputBase);
                outputBase.print(((Enum)object).name());
            } else {
                ValueWriter.writeFields(string, object, clazz, map, outputBase);
            }
        }
    }

    private static void writeFields(String string, java.lang.Object object, Class<?> clazz, Map<java.lang.Object, java.lang.Object> map, OutputBase outputBase) {
        if (!clazz.equals(java.lang.Object.class)) {
            ValueWriter.writeFields(string, object, clazz.getSuperclass(), map, outputBase);
            Field[] fieldArray = null;
            try {
                fieldArray = clazz.getDeclaredFields();
            }
            catch (SecurityException securityException) {
                try {
                    fieldArray = clazz.getFields();
                }
                catch (SecurityException securityException2) {
                    return;
                }
            }
            assert (fieldArray != null);
            for (Field field : fieldArray) {
                int n = field.getModifiers();
                if (!Modifier.isPublic(n) || Modifier.isStatic(n)) continue;
                String string2 = string != null ? string + '.' + field.getName() : field.getName();
                try {
                    java.lang.Object object2 = field.get(object);
                    ValueWriter.writeValue(string2, object2, map, outputBase);
                }
                catch (IllegalAccessException illegalAccessException) {
                    assert (false);
                }
            }
        }
    }

    private static void writeName(String string, OutputBase outputBase) {
        if (string != null) {
            outputBase.nl();
            outputBase.print(string + " = ");
        }
    }
}

