/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Communicator;
import Ice.CommunicatorI;
import Ice.Properties;
import IceInternal.Instance;
import IceInternal.ProtocolPluginFacade;
import IceInternal.ProtocolPluginFacadeI;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ThreadFactory;

public final class Util {
    static String createThreadName(Properties properties, String string) {
        String string2 = properties.getProperty("Ice.ProgramName");
        if (string2.length() > 0) {
            string2 = string2 + "-";
        }
        string2 = string2 + string;
        return string2;
    }

    static ThreadFactory createThreadFactory(final Properties properties, final String string) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName(string);
                if (properties.getProperty("Ice.ThreadPriority").length() > 0) {
                    thread.setPriority(Util.getThreadPriorityProperty(properties, "Ice"));
                }
                return thread;
            }
        };
    }

    public static Instance getInstance(Communicator communicator) {
        CommunicatorI communicatorI = (CommunicatorI)communicator;
        return communicatorI.getInstance();
    }

    public static ProtocolPluginFacade getProtocolPluginFacade(Communicator communicator) {
        return new ProtocolPluginFacadeI(communicator);
    }

    public static InputStream openResource(ClassLoader classLoader, String string) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = classLoader.getResourceAsStream(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (inputStream == null) {
            try {
                File file = new File(string);
                if (file.exists()) {
                    inputStream = new FileInputStream(file);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return inputStream;
    }

    public static Class<?> findClass(String string, ClassLoader classLoader) throws LinkageError {
        Class<?> clazz = null;
        if (classLoader != null) {
            clazz = Util.loadClass(string, classLoader);
        }
        if (clazz == null) {
            try {
                classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader != null) {
                    clazz = Util.loadClass(string, classLoader);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        try {
            if (clazz == null) {
                clazz = Class.forName(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                classLoader = ClassLoader.getSystemClassLoader();
                if (classLoader != null) {
                    clazz = Util.loadClass(string, classLoader);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return clazz;
    }

    private static Class<?> loadClass(String string, ClassLoader classLoader) {
        if (classLoader != null) {
            try {
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static int getThreadPriorityProperty(Properties properties, String string) {
        String string2 = properties.getProperty(string + ".ThreadPriority");
        if (string2.equals("MIN_PRIORITY") || string2.equals("java.lang.Thread.MIN_PRIORITY")) {
            return 1;
        }
        if (string2.equals("NORM_PRIORITY") || string2.equals("java.lang.Thread.NORM_PRIORITY")) {
            return 5;
        }
        if (string2.equals("MAX_PRIORITY") || string2.equals("java.lang.Thread.MAX_PRIORITY")) {
            return 10;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 5;
        }
    }

    public static boolean isAndroid() {
        return System.getProperty("java.vm.name").startsWith("Dalvik");
    }
}

