/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectionInfo;
import Ice.ConnectionLostException;
import Ice.DatagramLimitException;
import Ice.Holder;
import Ice.LocalException;
import Ice.SocketException;
import Ice.UDPConnectionInfo;
import IceInternal.BufSizeWarnInfo;
import IceInternal.Buffer;
import IceInternal.EndpointI;
import IceInternal.Network;
import IceInternal.ProtocolInstance;
import IceInternal.Transceiver;
import IceInternal.UdpEndpointI;
import IceInternal.Util;
import IceUtilInternal.Assert;
import IceUtilInternal.StringUtil;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.util.ArrayList;
import java.util.Collections;

final class UdpTransceiver
implements Transceiver {
    private UdpEndpointI _endpoint = null;
    private ProtocolInstance _instance;
    private int _state;
    private int _rcvSize;
    private int _sndSize;
    private DatagramChannel _fd;
    private InetSocketAddress _addr;
    private InetSocketAddress _mcastAddr = null;
    private String _mcastInterface;
    private InetSocketAddress _peerAddr = null;
    private boolean _incoming = false;
    private int _port = 0;
    private boolean _bound = false;
    private static final int _udpOverhead = 28;
    private static final int _maxPacketSize = 65507;
    private static final int StateNeedConnect = 0;
    private static final int StateConnected = 1;
    private static final int StateNotConnected = 2;

    @Override
    public SelectableChannel fd() {
        assert (this._fd != null);
        return this._fd;
    }

    @Override
    public int initialize(Buffer buffer, Buffer buffer2, Holder<Boolean> holder) {
        return 0;
    }

    @Override
    public int closing(boolean bl, LocalException localException) {
        return 0;
    }

    @Override
    public void close() {
        assert (this._fd != null);
        try {
            this._fd.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._fd = null;
    }

    @Override
    public EndpointI bind() {
        if (this._addr.getAddress().isMulticastAddress()) {
            Network.setReuseAddress(this._fd, true);
            this._mcastAddr = this._addr;
            if (System.getProperty("os.name").startsWith("Windows") || System.getProperty("java.vm.name").startsWith("OpenJDK")) {
                int n = this._mcastAddr.getAddress().getAddress().length == 4 ? 0 : 1;
                this._addr = Network.getAddressForServer("", this._port, n, this._instance.preferIPv6());
            }
            this._addr = Network.doBind(this._fd, this._addr);
            this.configureMulticast(this._mcastAddr, this._mcastInterface, -1);
            if (this._port == 0) {
                this._mcastAddr = new InetSocketAddress(this._mcastAddr.getAddress(), this._addr.getPort());
            }
        } else {
            if (!System.getProperty("os.name").startsWith("Windows")) {
                Network.setReuseAddress(this._fd, true);
            }
            this._addr = Network.doBind(this._fd, this._addr);
        }
        this._bound = true;
        this._endpoint = this._endpoint.endpoint(this);
        return this._endpoint;
    }

    @Override
    public int write(Buffer buffer) {
        if (!buffer.b.hasRemaining()) {
            return 0;
        }
        assert (buffer.b.position() == 0);
        assert (this._fd != null && this._state >= 1);
        assert (Math.min(65507, this._sndSize - 28) >= buffer.size());
        int n = 0;
        while (true) {
            try {
                if (this._state == 1) {
                    n = this._fd.write(buffer.b);
                    break;
                }
                if (this._peerAddr == null) {
                    throw new SocketException();
                }
                n = this._fd.send(buffer.b, this._peerAddr);
            }
            catch (AsynchronousCloseException asynchronousCloseException) {
                throw new ConnectionLostException(asynchronousCloseException);
            }
            catch (PortUnreachableException portUnreachableException) {
                throw new ConnectionLostException(portUnreachableException);
            }
            catch (InterruptedIOException interruptedIOException) {
                continue;
            }
            catch (IOException iOException) {
                throw new SocketException(iOException);
            }
            break;
        }
        if (n == 0) {
            return 4;
        }
        assert (n == buffer.b.limit());
        buffer.b.position(buffer.b.limit());
        return 0;
    }

    @Override
    public int read(Buffer buffer, Holder<Boolean> holder) {
        Object object;
        if (!buffer.b.hasRemaining()) {
            return 0;
        }
        assert (buffer.b.position() == 0);
        int n = Math.min(65507, this._rcvSize - 28);
        buffer.resize(n, true);
        buffer.b.position(0);
        int n2 = 0;
        while (true) {
            try {
                object = this._fd.receive(buffer.b);
                if (object == null || buffer.b.position() == 0) {
                    return 1;
                }
                this._peerAddr = (InetSocketAddress)object;
                n2 = buffer.b.position();
            }
            catch (AsynchronousCloseException asynchronousCloseException) {
                throw new ConnectionLostException(asynchronousCloseException);
            }
            catch (PortUnreachableException portUnreachableException) {
                throw new ConnectionLostException(portUnreachableException);
            }
            catch (InterruptedIOException interruptedIOException) {
                continue;
            }
            catch (IOException iOException) {
                throw new ConnectionLostException(iOException);
            }
            break;
        }
        if (this._state == 0) {
            Network.doConnect(this._fd, this._peerAddr, null);
            this._state = 1;
            if (this._instance.traceLevel() >= 1) {
                object = "connected " + this._instance.protocol() + " socket\n" + this.toString();
                this._instance.logger().trace(this._instance.traceCategory(), (String)object);
            }
        }
        buffer.resize(n2, true);
        buffer.b.position(n2);
        return 0;
    }

    @Override
    public String protocol() {
        return this._instance.protocol();
    }

    @Override
    public String toString() {
        String string;
        if (this._fd == null) {
            return "<closed>";
        }
        if (this._incoming && !this._bound) {
            string = "local address = " + Network.addrToString(this._addr);
        } else if (this._state == 2) {
            DatagramSocket datagramSocket = this._fd.socket();
            string = "local address = " + Network.addrToString((InetSocketAddress)datagramSocket.getLocalSocketAddress());
            if (this._peerAddr != null) {
                string = string + "\nremote address = " + Network.addrToString(this._peerAddr);
            }
        } else {
            string = Network.fdToString(this._fd);
        }
        if (this._mcastAddr != null) {
            string = string + "\nmulticast address = " + Network.addrToString(this._mcastAddr);
        }
        return string;
    }

    @Override
    public String toDetailedString() {
        StringBuilder stringBuilder = new StringBuilder(this.toString());
        ArrayList<String> arrayList = Network.getHostsForEndpointExpand(this._addr.getAddress().getHostAddress(), this._instance.protocolSupport(), true);
        if (!arrayList.isEmpty()) {
            stringBuilder.append("\nlocal interfaces = ");
            stringBuilder.append(StringUtil.joinString(arrayList, ", "));
        }
        return stringBuilder.toString();
    }

    @Override
    public ConnectionInfo getInfo() {
        UDPConnectionInfo uDPConnectionInfo = new UDPConnectionInfo();
        if (this._fd != null) {
            DatagramSocket datagramSocket = this._fd.socket();
            uDPConnectionInfo.localAddress = datagramSocket.getLocalAddress().getHostAddress();
            uDPConnectionInfo.localPort = datagramSocket.getLocalPort();
            if (this._state == 2) {
                if (this._peerAddr != null) {
                    uDPConnectionInfo.remoteAddress = this._peerAddr.getAddress().getHostAddress();
                    uDPConnectionInfo.remotePort = this._peerAddr.getPort();
                }
            } else if (datagramSocket.getInetAddress() != null) {
                uDPConnectionInfo.remoteAddress = datagramSocket.getInetAddress().getHostAddress();
                uDPConnectionInfo.remotePort = datagramSocket.getPort();
            }
            if (!datagramSocket.isClosed()) {
                uDPConnectionInfo.rcvSize = Network.getRecvBufferSize(this._fd);
                uDPConnectionInfo.sndSize = Network.getSendBufferSize(this._fd);
            }
        }
        if (this._mcastAddr != null) {
            uDPConnectionInfo.mcastAddress = this._mcastAddr.getAddress().getHostAddress();
            uDPConnectionInfo.mcastPort = this._mcastAddr.getPort();
        }
        return uDPConnectionInfo;
    }

    @Override
    public void checkSendSize(Buffer buffer) {
        int n = Math.min(65507, this._sndSize - 28);
        if (n < buffer.size()) {
            throw new DatagramLimitException();
        }
    }

    @Override
    public void setBufferSize(int n, int n2) {
        this.setBufSize(n, n2);
    }

    public final int effectivePort() {
        return this._addr.getPort();
    }

    UdpTransceiver(ProtocolInstance protocolInstance, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, String string, int n) {
        this._instance = protocolInstance;
        this._state = 0;
        this._addr = inetSocketAddress;
        try {
            this._fd = Network.createUdpSocket(this._addr);
            this.setBufSize(-1, -1);
            Network.setBlock(this._fd, false);
            if (this._addr.getAddress().isMulticastAddress()) {
                this.configureMulticast(null, string, n);
            }
            Network.doConnect(this._fd, this._addr, inetSocketAddress2);
            this._state = 1;
        }
        catch (LocalException localException) {
            this._fd = null;
            throw localException;
        }
    }

    UdpTransceiver(UdpEndpointI udpEndpointI, ProtocolInstance protocolInstance, String string, int n, String string2, boolean bl) {
        this._endpoint = udpEndpointI;
        this._instance = protocolInstance;
        this._state = bl ? 0 : 2;
        this._mcastInterface = string2;
        this._incoming = true;
        this._port = n;
        try {
            this._addr = Network.getAddressForServer(string, n, protocolInstance.protocolSupport(), protocolInstance.preferIPv6());
            this._fd = Network.createUdpSocket(this._addr);
            this.setBufSize(-1, -1);
            Network.setBlock(this._fd, false);
        }
        catch (LocalException localException) {
            this._fd = null;
            throw localException;
        }
    }

    private synchronized void setBufSize(int n, int n2) {
        assert (this._fd != null);
        for (int i = 0; i < 2; ++i) {
            int n3;
            int n4;
            int n5;
            String string;
            String string2;
            boolean bl;
            if (i == 0) {
                bl = false;
                string2 = "receive";
                string = "Ice.UDP.RcvSize";
                n5 = Network.getRecvBufferSize(this._fd);
                n4 = n;
                this._rcvSize = n5;
            } else {
                bl = true;
                string2 = "send";
                string = "Ice.UDP.SndSize";
                n5 = Network.getSendBufferSize(this._fd);
                n4 = n2;
                this._sndSize = n5;
            }
            if (n4 == -1) {
                n4 = this._instance.properties().getPropertyAsIntWithDefault(string, n5);
            }
            if (n4 < 42) {
                this._instance.logger().warning("Invalid " + string + " value of " + n4 + " adjusted to " + n5);
                n4 = n5;
            }
            if (n4 == n5) continue;
            if (i == 0) {
                Network.setRecvBufferSize(this._fd, n4);
                n3 = this._rcvSize = Network.getRecvBufferSize(this._fd);
            } else {
                Network.setSendBufferSize(this._fd, n4);
                n3 = this._sndSize = Network.getSendBufferSize(this._fd);
            }
            if (n3 >= n4) continue;
            BufSizeWarnInfo bufSizeWarnInfo = this._instance.getBufSizeWarn((short)3);
            if ((!bl || bufSizeWarnInfo.sndWarn && bufSizeWarnInfo.sndSize == n4) && (bl || bufSizeWarnInfo.rcvWarn && bufSizeWarnInfo.rcvSize == n4)) continue;
            this._instance.logger().warning("UDP " + string2 + " buffer size: requested size of " + n4 + " adjusted to " + n3);
            if (bl) {
                this._instance.setSndBufSizeWarn((short)3, n4);
                continue;
            }
            this._instance.setRcvBufSizeWarn((short)3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void configureMulticast(InetSocketAddress inetSocketAddress, String string, int n) {
        try {
            AnnotatedElement annotatedElement;
            Class[] classArray;
            Class<?> clazz = Util.findClass("java.nio.channels.MulticastChannel", null);
            Method method = null;
            DatagramSocketImpl datagramSocketImpl = null;
            Field field = null;
            NetworkInterface networkInterface = null;
            if (clazz == null || !clazz.isAssignableFrom(this._fd.getClass())) {
                clazz = Util.findClass("java.net.PlainDatagramSocketImpl", null);
                if (clazz == null) {
                    throw new SocketException();
                }
                classArray = clazz.getDeclaredConstructor(null);
                classArray.setAccessible(true);
                datagramSocketImpl = (DatagramSocketImpl)classArray.newInstance(null);
                try {
                    method = clazz.getDeclaredMethod("create", null);
                    method.setAccessible(true);
                    method.invoke((Object)datagramSocketImpl, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                clazz = Util.findClass("sun.nio.ch.DatagramChannelImpl", null);
                if (clazz == null) {
                    throw new SocketException();
                }
                annotatedElement = clazz.getDeclaredField("fd");
                ((Field)annotatedElement).setAccessible(true);
                field = DatagramSocketImpl.class.getDeclaredField("fd");
                field.setAccessible(true);
                field.set(datagramSocketImpl, ((Field)annotatedElement).get(this._fd));
            }
            try {
                if (string.length() != 0 && (networkInterface = NetworkInterface.getByName(string)) == null) {
                    classArray = Network.getAddressForServer(string, 0, 0, false);
                    networkInterface = NetworkInterface.getByInetAddress(classArray.getAddress());
                }
                if (inetSocketAddress != null) {
                    if (datagramSocketImpl == null) {
                        classArray = new Class[]{InetAddress.class, NetworkInterface.class};
                        method = this._fd.getClass().getDeclaredMethod("join", classArray);
                        method.setAccessible(true);
                        boolean bl = false;
                        if (networkInterface != null) {
                            method.invoke((Object)this._fd, inetSocketAddress.getAddress(), networkInterface);
                            bl = true;
                        } else {
                            boolean bl2 = inetSocketAddress.getAddress().getAddress().length != 4;
                            ArrayList<NetworkInterface> arrayList = Collections.list(NetworkInterface.getNetworkInterfaces());
                            for (NetworkInterface networkInterface2 : arrayList) {
                                if (!networkInterface2.supportsMulticast()) continue;
                                boolean bl3 = false;
                                ArrayList<InetAddress> arrayList2 = Collections.list(networkInterface2.getInetAddresses());
                                for (InetAddress inetAddress : arrayList2) {
                                    if ((inetAddress.getAddress().length != 4 || bl2) && (inetAddress.getAddress().length == 4 || !bl2)) continue;
                                    bl3 = true;
                                    break;
                                }
                                if (!bl3) continue;
                                method.invoke((Object)this._fd, inetSocketAddress.getAddress(), networkInterface2);
                                bl = true;
                            }
                            if (!bl) {
                                throw new SocketException(new IllegalArgumentException("There aren't any interfaces that support multicast, or the interfaces that support it\nare not configured for the group protocol. Cannot join the mulitcast group."));
                            }
                        }
                    } else {
                        try {
                            classArray = new Class[]{SocketAddress.class, NetworkInterface.class};
                            method = datagramSocketImpl.getClass().getDeclaredMethod("joinGroup", classArray);
                            annotatedElement = new Object[]{inetSocketAddress, networkInterface};
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            classArray = new Class[]{InetAddress.class, NetworkInterface.class};
                            method = datagramSocketImpl.getClass().getDeclaredMethod("join", classArray);
                            annotatedElement = new Object[]{inetSocketAddress.getAddress(), networkInterface};
                        }
                        method.setAccessible(true);
                        method.invoke((Object)datagramSocketImpl, (Object[])annotatedElement);
                    }
                } else if (networkInterface != null) {
                    classArray = new Class[]{Integer.TYPE, Object.class};
                    if (datagramSocketImpl == null) {
                        annotatedElement = Util.findClass("java.net.SocketOption", null);
                        Class<?> clazz2 = Util.findClass("java.net.StandardSocketOptions", null);
                        method = this._fd.getClass().getDeclaredMethod("setOption", new Class[]{annotatedElement, Object.class});
                        method.setAccessible(true);
                        Field field2 = clazz2.getDeclaredField("IP_MULTICAST_IF");
                        field2.setAccessible(true);
                        method.invoke((Object)this._fd, field2.get(null), networkInterface);
                    } else {
                        try {
                            method = datagramSocketImpl.getClass().getDeclaredMethod("setOption", classArray);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            method = datagramSocketImpl.getClass().getDeclaredMethod("socketSetOption", classArray);
                        }
                        method.setAccessible(true);
                        annotatedElement = new Object[]{31, networkInterface};
                        method.invoke((Object)datagramSocketImpl, (Object[])annotatedElement);
                    }
                }
                if (n != -1) {
                    if (datagramSocketImpl == null) {
                        classArray = Util.findClass("java.net.SocketOption", null);
                        annotatedElement = Util.findClass("java.net.StandardSocketOptions", null);
                        method = this._fd.getClass().getDeclaredMethod("setOption", classArray, Object.class);
                        method.setAccessible(true);
                        Field field3 = ((Class)annotatedElement).getDeclaredField("IP_MULTICAST_TTL");
                        field3.setAccessible(true);
                        method.invoke((Object)this._fd, field3.get(null), n);
                    } else {
                        classArray = new Class[]{Integer.TYPE};
                        method = DatagramSocketImpl.class.getDeclaredMethod("setTimeToLive", classArray);
                        method.setAccessible(true);
                        method.invoke((Object)datagramSocketImpl, n);
                    }
                }
                if (field == null || datagramSocketImpl == null) return;
            }
            catch (Throwable throwable) {
                if (field == null || datagramSocketImpl == null) throw throwable;
                field.set(datagramSocketImpl, null);
                throw throwable;
            }
            field.set(datagramSocketImpl, null);
            return;
        }
        catch (Exception exception) {
            throw new SocketException(exception);
        }
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._fd == null);
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }
}

