/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.EncodingVersion;
import Ice.EndpointInfo;
import Ice.EndpointParseException;
import Ice.IPEndpointInfo;
import Ice.UDPEndpointInfo;
import Ice.Util;
import Ice.VersionParseException;
import IceInternal.Acceptor;
import IceInternal.BasicStream;
import IceInternal.Connector;
import IceInternal.EndpointI;
import IceInternal.HashUtil;
import IceInternal.IPEndpointI;
import IceInternal.NetworkProxy;
import IceInternal.ProtocolInstance;
import IceInternal.Transceiver;
import IceInternal.UdpConnector;
import IceInternal.UdpTransceiver;
import java.net.InetSocketAddress;

final class UdpEndpointI
extends IPEndpointI {
    private String _mcastInterface = "";
    private int _mcastTtl = -1;
    private boolean _connect;
    private boolean _compress;

    public UdpEndpointI(ProtocolInstance protocolInstance, String string, int n, InetSocketAddress inetSocketAddress, String string2, int n2, boolean bl, String string3, boolean bl2) {
        super(protocolInstance, string, n, inetSocketAddress, string3);
        this._mcastInterface = string2;
        this._mcastTtl = n2;
        this._connect = bl;
        this._compress = bl2;
    }

    public UdpEndpointI(ProtocolInstance protocolInstance) {
        super(protocolInstance);
        this._connect = false;
        this._compress = false;
    }

    public UdpEndpointI(ProtocolInstance protocolInstance, BasicStream basicStream) {
        super(protocolInstance, basicStream);
        if (basicStream.getReadEncoding().equals(Util.Encoding_1_0)) {
            basicStream.readByte();
            basicStream.readByte();
            basicStream.readByte();
            basicStream.readByte();
        }
        this._connect = false;
        this._compress = basicStream.readBool();
    }

    @Override
    public EndpointInfo getInfo() {
        UDPEndpointInfo uDPEndpointInfo = new UDPEndpointInfo(){

            @Override
            public short type() {
                return UdpEndpointI.this.type();
            }

            @Override
            public boolean datagram() {
                return UdpEndpointI.this.datagram();
            }

            @Override
            public boolean secure() {
                return UdpEndpointI.this.secure();
            }
        };
        this.fillEndpointInfo(uDPEndpointInfo);
        return uDPEndpointInfo;
    }

    @Override
    public int timeout() {
        return -1;
    }

    @Override
    public EndpointI timeout(int n) {
        return this;
    }

    @Override
    public boolean compress() {
        return this._compress;
    }

    @Override
    public EndpointI compress(boolean bl) {
        if (bl == this._compress) {
            return this;
        }
        return new UdpEndpointI(this._instance, this._host, this._port, this._sourceAddr, this._mcastInterface, this._mcastTtl, this._connect, this._connectionId, bl);
    }

    @Override
    public boolean datagram() {
        return true;
    }

    @Override
    public Transceiver transceiver() {
        return new UdpTransceiver(this, this._instance, this._host, this._port, this._mcastInterface, this._connect);
    }

    @Override
    public Acceptor acceptor(String string) {
        return null;
    }

    public UdpEndpointI endpoint(UdpTransceiver udpTransceiver) {
        return new UdpEndpointI(this._instance, this._host, udpTransceiver.effectivePort(), this._sourceAddr, this._mcastInterface, this._mcastTtl, this._connect, this._connectionId, this._compress);
    }

    @Override
    public String options() {
        String string = super.options();
        if (this._mcastInterface.length() != 0) {
            string = string + " --interface " + this._mcastInterface;
        }
        if (this._mcastTtl != -1) {
            string = string + " --ttl " + this._mcastTtl;
        }
        if (this._connect) {
            string = string + " -c";
        }
        if (this._compress) {
            string = string + " -z";
        }
        return string;
    }

    @Override
    public int compareTo(EndpointI endpointI) {
        if (!(endpointI instanceof UdpEndpointI)) {
            return this.type() < endpointI.type() ? -1 : 1;
        }
        UdpEndpointI udpEndpointI = (UdpEndpointI)endpointI;
        if (this == udpEndpointI) {
            return 0;
        }
        if (!this._connect && udpEndpointI._connect) {
            return -1;
        }
        if (!udpEndpointI._connect && this._connect) {
            return 1;
        }
        if (!this._compress && udpEndpointI._compress) {
            return -1;
        }
        if (!udpEndpointI._compress && this._compress) {
            return 1;
        }
        if (this._mcastTtl < udpEndpointI._mcastTtl) {
            return -1;
        }
        if (udpEndpointI._mcastTtl < this._mcastTtl) {
            return 1;
        }
        int n = this._mcastInterface.compareTo(udpEndpointI._mcastInterface);
        if (n != 0) {
            return n;
        }
        return super.compareTo(endpointI);
    }

    @Override
    public void streamWriteImpl(BasicStream basicStream) {
        super.streamWriteImpl(basicStream);
        if (basicStream.getWriteEncoding().equals(Util.Encoding_1_0)) {
            Util.Protocol_1_0.__write(basicStream);
            Util.Encoding_1_0.__write(basicStream);
        }
        basicStream.writeBool(this._compress);
    }

    @Override
    public int hashInit(int n) {
        n = super.hashInit(n);
        n = HashUtil.hashAdd(n, this._mcastInterface);
        n = HashUtil.hashAdd(n, this._mcastTtl);
        n = HashUtil.hashAdd(n, this._connect);
        n = HashUtil.hashAdd(n, this._compress);
        return n;
    }

    @Override
    public void fillEndpointInfo(IPEndpointInfo iPEndpointInfo) {
        super.fillEndpointInfo(iPEndpointInfo);
        if (iPEndpointInfo instanceof UDPEndpointInfo) {
            UDPEndpointInfo uDPEndpointInfo = (UDPEndpointInfo)iPEndpointInfo;
            uDPEndpointInfo.timeout = -1;
            uDPEndpointInfo.compress = this._compress;
            uDPEndpointInfo.mcastInterface = this._mcastInterface;
            uDPEndpointInfo.mcastTtl = this._mcastTtl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean checkOption(String string, String string2, String string3) {
        if (super.checkOption(string, string2, string3)) {
            return true;
        }
        if (string.equals("-c")) {
            if (string2 != null) {
                throw new EndpointParseException("unexpected argument `" + string2 + "' provided for -c option in " + string3);
            }
            this._connect = true;
            return true;
        }
        if (string.equals("-z")) {
            if (string2 != null) {
                throw new EndpointParseException("unexpected argument `" + string2 + "' provided for -z option in " + string3);
            }
            this._compress = true;
            return true;
        }
        if (string.equals("-v") || string.equals("-e")) {
            if (string2 == null) {
                throw new EndpointParseException("no argument provided for " + string + " option in endpoint " + string3);
            }
            try {
                EncodingVersion encodingVersion = Util.stringToEncodingVersion(string2);
                if (encodingVersion.major == 1 && encodingVersion.minor == 0) return true;
                this._instance.logger().warning("deprecated udp endpoint option: " + string);
                return true;
            }
            catch (VersionParseException versionParseException) {
                throw new EndpointParseException("invalid version `" + string2 + "' in endpoint " + string3 + ":\n" + versionParseException.str);
            }
        }
        if (string.equals("--ttl")) {
            if (string2 == null) {
                throw new EndpointParseException("no argument provided for --ttl option in endpoint " + string3);
            }
            try {
                this._mcastTtl = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new EndpointParseException("invalid TTL value `" + string2 + "' in endpoint " + string3);
            }
            if (this._mcastTtl >= 0) return true;
            throw new EndpointParseException("TTL value `" + string2 + "' out of range in endpoint " + string3);
        }
        if (!string.equals("--interface")) return false;
        if (string2 == null) {
            throw new EndpointParseException("no argument provided for --interface option in endpoint " + string3);
        }
        this._mcastInterface = string2;
        return true;
    }

    @Override
    protected Connector createConnector(InetSocketAddress inetSocketAddress, NetworkProxy networkProxy) {
        return new UdpConnector(this._instance, inetSocketAddress, this._sourceAddr, this._mcastInterface, this._mcastTtl, this._connectionId);
    }

    @Override
    protected IPEndpointI createEndpoint(String string, int n, String string2) {
        return new UdpEndpointI(this._instance, string, n, this._sourceAddr, this._mcastInterface, this._mcastTtl, this._connect, string2, this._compress);
    }
}

