/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import IceInternal.Connector;
import IceInternal.HashUtil;
import IceInternal.Network;
import IceInternal.ProtocolInstance;
import IceInternal.Transceiver;
import IceInternal.UdpTransceiver;
import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;

final class UdpConnector
implements Connector {
    private ProtocolInstance _instance;
    private InetSocketAddress _addr;
    private InetSocketAddress _sourceAddr;
    private String _mcastInterface;
    private int _mcastTtl;
    private String _connectionId;
    private int _hashCode;

    @Override
    public Transceiver connect() {
        return new UdpTransceiver(this._instance, this._addr, this._sourceAddr, this._mcastInterface, this._mcastTtl);
    }

    public SelectableChannel fd() {
        assert (false);
        return null;
    }

    @Override
    public short type() {
        return this._instance.type();
    }

    @Override
    public String toString() {
        return Network.addrToString(this._addr);
    }

    public int hashCode() {
        return this._hashCode;
    }

    UdpConnector(ProtocolInstance protocolInstance, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, String string, int n, String string2) {
        this._instance = protocolInstance;
        this._addr = inetSocketAddress;
        this._sourceAddr = inetSocketAddress2;
        this._mcastInterface = string;
        this._mcastTtl = n;
        this._connectionId = string2;
        this._hashCode = 5381;
        this._hashCode = HashUtil.hashAdd(this._hashCode, this._addr.getAddress().getHostAddress());
        this._hashCode = HashUtil.hashAdd(this._hashCode, this._addr.getPort());
        if (this._sourceAddr != null) {
            this._hashCode = HashUtil.hashAdd(this._hashCode, this._sourceAddr.getAddress().getHostAddress());
        }
        this._hashCode = HashUtil.hashAdd(this._hashCode, this._mcastInterface);
        this._hashCode = HashUtil.hashAdd(this._hashCode, this._mcastTtl);
        this._hashCode = HashUtil.hashAdd(this._hashCode, this._connectionId);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof UdpConnector)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        UdpConnector udpConnector = (UdpConnector)object;
        if (!this._connectionId.equals(udpConnector._connectionId)) {
            return false;
        }
        if (this._mcastTtl != udpConnector._mcastTtl) {
            return false;
        }
        if (this._mcastInterface.compareTo(udpConnector._mcastInterface) != 0) {
            return false;
        }
        if (Network.compareAddress(this._sourceAddr, udpConnector._sourceAddr) != 0) {
            return false;
        }
        return Network.compareAddress(this._addr, udpConnector._addr) == 0;
    }
}

