/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.EncodingVersion;
import Ice.Identity;
import Ice.Logger;
import Ice.OperationMode;
import Ice.Util;
import IceInternal.BasicStream;
import IceInternal.TraceLevels;
import IceUtilInternal.StringUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;

public final class TraceUtil {
    private static Set<String> slicingIds = new HashSet<String>();

    public static void traceSend(BasicStream basicStream, Logger logger, TraceLevels traceLevels) {
        if (traceLevels.protocol >= 1) {
            int n = basicStream.pos();
            basicStream.pos(0);
            StringWriter stringWriter = new StringWriter();
            byte by = TraceUtil.printMessage(stringWriter, basicStream);
            logger.trace(traceLevels.protocolCat, "sending " + TraceUtil.getMessageTypeAsString(by) + " " + stringWriter.toString());
            basicStream.pos(n);
        }
    }

    public static void traceRecv(BasicStream basicStream, Logger logger, TraceLevels traceLevels) {
        if (traceLevels.protocol >= 1) {
            int n = basicStream.pos();
            basicStream.pos(0);
            StringWriter stringWriter = new StringWriter();
            byte by = TraceUtil.printMessage(stringWriter, basicStream);
            logger.trace(traceLevels.protocolCat, "received " + TraceUtil.getMessageTypeAsString(by) + " " + stringWriter.toString());
            basicStream.pos(n);
        }
    }

    public static void trace(String string, BasicStream basicStream, Logger logger, TraceLevels traceLevels) {
        if (traceLevels.protocol >= 1) {
            int n = basicStream.pos();
            basicStream.pos(0);
            StringWriter stringWriter = new StringWriter();
            stringWriter.write(string);
            TraceUtil.printMessage(stringWriter, basicStream);
            logger.trace(traceLevels.protocolCat, stringWriter.toString());
            basicStream.pos(n);
        }
    }

    static synchronized void traceSlicing(String string, String string2, String string3, Logger logger) {
        if (slicingIds.add(string2)) {
            StringWriter stringWriter = new StringWriter();
            stringWriter.write("unknown " + string + " type `" + string2 + "'");
            logger.trace(string3, stringWriter.toString());
        }
    }

    public static void dumpStream(BasicStream basicStream) {
        int n = basicStream.pos();
        basicStream.pos(0);
        byte[] byArray = basicStream.readBlob(basicStream.size());
        TraceUtil.dumpOctets(byArray);
        basicStream.pos(n);
    }

    public static void dumpOctets(byte[] byArray) {
        for (int i = 0; i < byArray.length; i += 8) {
            int n = i;
            while (n - i < 8) {
                if (n < byArray.length) {
                    int n2 = byArray[n];
                    if (n2 < 0) {
                        n2 += 256;
                    }
                    String string = n2 < 10 ? "  " + n2 : (n2 < 100 ? " " + n2 : "" + n2);
                    System.out.print(string + " ");
                } else {
                    System.out.print("    ");
                }
                ++n;
            }
            System.out.print('\"');
            for (n = i; n < byArray.length && n - i < 8; ++n) {
                if (byArray[n] >= 32 && byArray[n] < 127) {
                    System.out.print((char)byArray[n]);
                    continue;
                }
                System.out.print('.');
            }
            System.out.println('\"');
        }
    }

    private static void printIdentityFacetOperation(Writer writer, BasicStream basicStream) {
        block3: {
            try {
                Identity identity = new Identity();
                identity.__read(basicStream);
                writer.write("\nidentity = " + basicStream.instance().identityToString(identity));
                String[] stringArray = basicStream.readStringSeq();
                writer.write("\nfacet = ");
                if (stringArray.length > 0) {
                    writer.write(StringUtil.escapeString(stringArray[0], ""));
                }
                String string = basicStream.readString();
                writer.write("\noperation = " + string);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    private static void printRequest(StringWriter stringWriter, BasicStream basicStream) {
        int n = basicStream.readInt();
        stringWriter.write("\nrequest id = " + n);
        if (n == 0) {
            stringWriter.write(" (oneway)");
        }
        TraceUtil.printRequestHeader(stringWriter, basicStream);
    }

    private static void printBatchRequest(StringWriter stringWriter, BasicStream basicStream) {
        int n = basicStream.readInt();
        stringWriter.write("\nnumber of requests = " + n);
        for (int i = 0; i < n; ++i) {
            stringWriter.write("\nrequest #" + i + ':');
            TraceUtil.printRequestHeader(stringWriter, basicStream);
        }
    }

    private static void printReply(StringWriter stringWriter, BasicStream basicStream) {
        Object object;
        int n = basicStream.readInt();
        stringWriter.write("\nrequest id = " + n);
        byte by = basicStream.readByte();
        stringWriter.write("\nreply status = " + by + ' ');
        switch (by) {
            case 0: {
                stringWriter.write("(ok)");
                break;
            }
            case 1: {
                stringWriter.write("(user exception)");
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                switch (by) {
                    case 2: {
                        stringWriter.write("(object not exist)");
                        break;
                    }
                    case 3: {
                        stringWriter.write("(facet not exist)");
                        break;
                    }
                    case 4: {
                        stringWriter.write("(operation not exist)");
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                TraceUtil.printIdentityFacetOperation(stringWriter, basicStream);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                switch (by) {
                    case 7: {
                        stringWriter.write("(unknown exception)");
                        break;
                    }
                    case 5: {
                        stringWriter.write("(unknown local exception)");
                        break;
                    }
                    case 6: {
                        stringWriter.write("(unknown user exception)");
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                object = basicStream.readString();
                stringWriter.write("\nunknown = " + (String)object);
                break;
            }
            default: {
                stringWriter.write("(unknown)");
            }
        }
        if (!(by != 0 && by != 1 || ((EncodingVersion)(object = basicStream.skipEncaps())).equals(Util.Encoding_1_0))) {
            stringWriter.write("\nencoding = ");
            stringWriter.write(Util.encodingVersionToString((EncodingVersion)object));
        }
    }

    private static void printRequestHeader(Writer writer, BasicStream basicStream) {
        block9: {
            TraceUtil.printIdentityFacetOperation(writer, basicStream);
            try {
                Object object;
                byte by = basicStream.readByte();
                writer.write("\nmode = " + by + ' ');
                switch (OperationMode.values()[by]) {
                    case Normal: {
                        writer.write("(normal)");
                        break;
                    }
                    case Nonmutating: {
                        writer.write("(nonmutating)");
                        break;
                    }
                    case Idempotent: {
                        writer.write("(idempotent)");
                        break;
                    }
                    default: {
                        writer.write("(unknown)");
                    }
                }
                int n = basicStream.readSize();
                writer.write("\ncontext = ");
                while (n-- > 0) {
                    object = basicStream.readString();
                    String string = basicStream.readString();
                    writer.write((String)object + '/' + string);
                    if (n <= 0) continue;
                    writer.write(", ");
                }
                object = basicStream.skipEncaps();
                if (!((EncodingVersion)object).equals(Util.Encoding_1_0)) {
                    writer.write("\nencoding = ");
                    writer.write(Util.encodingVersionToString((EncodingVersion)object));
                }
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block9;
                throw new AssertionError();
            }
        }
    }

    private static byte printHeader(Writer writer, BasicStream basicStream) {
        basicStream.readByte();
        basicStream.readByte();
        basicStream.readByte();
        basicStream.readByte();
        basicStream.readByte();
        basicStream.readByte();
        basicStream.readByte();
        basicStream.readByte();
        byte by = basicStream.readByte();
        try {
            writer.write("\nmessage type = " + by + " (" + TraceUtil.getMessageTypeAsString(by) + ')');
            byte by2 = basicStream.readByte();
            writer.write("\ncompression status = " + by2 + ' ');
            switch (by2) {
                case 0: {
                    writer.write("(not compressed; do not compress response, if any)");
                    break;
                }
                case 1: {
                    writer.write("(not compressed; compress response, if any)");
                    break;
                }
                case 2: {
                    writer.write("(compressed; compress response, if any)");
                    break;
                }
                default: {
                    writer.write("(unknown)");
                }
            }
            int n = basicStream.readInt();
            writer.write("\nmessage size = " + n);
            return by;
        }
        catch (IOException iOException) {
            assert (false);
            return 0;
        }
    }

    private static byte printMessage(StringWriter stringWriter, BasicStream basicStream) {
        byte by = TraceUtil.printHeader(stringWriter, basicStream);
        switch (by) {
            case 3: 
            case 4: {
                break;
            }
            case 0: {
                TraceUtil.printRequest(stringWriter, basicStream);
                break;
            }
            case 1: {
                TraceUtil.printBatchRequest(stringWriter, basicStream);
                break;
            }
            case 2: {
                TraceUtil.printReply(stringWriter, basicStream);
                break;
            }
        }
        return by;
    }

    private static String getMessageTypeAsString(byte by) {
        switch (by) {
            case 0: {
                return "request";
            }
            case 1: {
                return "batch request";
            }
            case 2: {
                return "reply";
            }
            case 4: {
                return "close connection";
            }
            case 3: {
                return "validate connection";
            }
        }
        return "unknown";
    }
}

