/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CommunicatorDestroyedException;
import IceInternal.EventHandler;
import IceInternal.EventHandlerOpPair;
import IceInternal.Instance;
import IceInternal.Selector;
import IceInternal.ThreadPool;
import IceInternal.ThreadPoolCurrent;
import IceInternal.ThreadPoolWorkItem;
import IceUtilInternal.Assert;
import java.nio.channels.SelectableChannel;
import java.util.LinkedList;
import java.util.List;

final class ThreadPoolWorkQueue
extends EventHandler {
    private final ThreadPool _threadPool;
    private boolean _destroyed;
    private Selector _selector;
    private EventHandlerOpPair _opPair = new EventHandlerOpPair(this, 1);
    private LinkedList<ThreadPoolWorkItem> _workItems = new LinkedList();

    ThreadPoolWorkQueue(Instance instance, ThreadPool threadPool, Selector selector) {
        this._threadPool = threadPool;
        this._selector = selector;
        this._destroyed = false;
        this._registered = 1;
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._destroyed);
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    synchronized void destroy() {
        assert (!this._destroyed);
        this._destroyed = true;
        this._selector.wakeup();
    }

    synchronized void queue(ThreadPoolWorkItem threadPoolWorkItem) {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        assert (threadPoolWorkItem != null);
        this._workItems.add(threadPoolWorkItem);
        this._selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void message(ThreadPoolCurrent threadPoolCurrent) {
        ThreadPoolWorkItem threadPoolWorkItem = null;
        ThreadPoolWorkQueue threadPoolWorkQueue = this;
        synchronized (threadPoolWorkQueue) {
            if (!this._workItems.isEmpty()) {
                threadPoolWorkItem = this._workItems.removeFirst();
                assert (threadPoolWorkItem != null);
            } else {
                assert (this._destroyed);
                this._selector.wakeup();
            }
        }
        if (threadPoolWorkItem == null) {
            this._threadPool.ioCompleted(threadPoolCurrent);
            throw new ThreadPool.DestroyedException();
        }
        threadPoolWorkItem.execute(threadPoolCurrent);
    }

    @Override
    public void finished(ThreadPoolCurrent threadPoolCurrent, boolean bl) {
        assert (false);
    }

    @Override
    public String toString() {
        return "work queue";
    }

    @Override
    public SelectableChannel fd() {
        return null;
    }

    synchronized int size() {
        int n = this._workItems.size();
        if (this._destroyed) {
            ++n;
        }
        return n;
    }

    synchronized void update(List<EventHandlerOpPair> list) {
        for (int i = this.size(); i > 0; --i) {
            list.add(this._opPair);
        }
    }
}

