/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CommunicatorDestroyedException;
import Ice.Dispatcher;
import Ice.Instrumentation.CommunicatorObserver;
import Ice.Instrumentation.ThreadObserver;
import Ice.Instrumentation.ThreadState;
import Ice.OperationInterruptedException;
import Ice.Properties;
import IceInternal.DispatchWorkItem;
import IceInternal.EventHandler;
import IceInternal.EventHandlerOpPair;
import IceInternal.Ex;
import IceInternal.Instance;
import IceInternal.Selector;
import IceInternal.ThreadPoolCurrent;
import IceInternal.ThreadPoolWorkItem;
import IceInternal.ThreadPoolWorkQueue;
import IceInternal.Time;
import IceInternal.Util;
import IceUtilInternal.Assert;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class ThreadPool {
    private static ThreadPoolWorkItem _interruptWorkItem = new InterruptWorkItem();
    private final Instance _instance;
    private final Dispatcher _dispatcher;
    private final ThreadPoolWorkQueue _workQueue;
    private boolean _destroyed;
    private final String _prefix;
    private final String _threadPrefix;
    private final Selector _selector;
    private final int _size;
    private final int _sizeIO;
    private final int _sizeMax;
    private final int _sizeWarn;
    private final boolean _serialize;
    private final int _priority;
    private final boolean _hasPriority;
    private final long _serverIdleTime;
    private final long _threadIdleTime;
    private final int _stackSize;
    private List<EventHandlerThread> _threads = new ArrayList<EventHandlerThread>();
    private int _threadIndex;
    private int _inUse;
    private int _inUseIO;
    private List<EventHandlerOpPair> _handlers = new ArrayList<EventHandlerOpPair>();
    private Iterator<EventHandlerOpPair> _nextHandler;
    private HashSet<EventHandler> _pendingHandlers = new HashSet();
    private boolean _promote;

    public ThreadPool(Instance instance, String string, int n) {
        String string2;
        int n2;
        int n3;
        Properties properties = instance.initializationData().properties;
        this._instance = instance;
        this._dispatcher = instance.initializationData().dispatcher;
        this._destroyed = false;
        this._prefix = string;
        this._selector = new Selector(instance);
        this._threadIndex = 0;
        this._inUse = 0;
        this._inUseIO = 0;
        this._promote = true;
        this._serialize = properties.getPropertyAsInt(this._prefix + ".Serialize") > 0;
        this._serverIdleTime = n;
        this._threadPrefix = Util.createThreadName(properties, this._prefix);
        int n4 = Runtime.getRuntime().availableProcessors();
        int n5 = properties.getPropertyAsIntWithDefault(this._prefix + ".Size", 1);
        if (n5 < 1) {
            String string3 = this._prefix + ".Size < 1; Size adjusted to 1";
            this._instance.initializationData().logger.warning(string3);
            n5 = 1;
        }
        if ((n3 = properties.getPropertyAsIntWithDefault(this._prefix + ".SizeMax", n5)) == -1) {
            n3 = n4;
        }
        if (n3 < n5) {
            String string4 = this._prefix + ".SizeMax < " + this._prefix + ".Size; SizeMax adjusted to Size (" + n5 + ")";
            this._instance.initializationData().logger.warning(string4);
            n3 = n5;
        }
        if ((n2 = properties.getPropertyAsInt(this._prefix + ".SizeWarn")) != 0 && n2 < n5) {
            string2 = this._prefix + ".SizeWarn < " + this._prefix + ".Size; adjusted SizeWarn to Size (" + n5 + ")";
            this._instance.initializationData().logger.warning(string2);
            n2 = n5;
        } else if (n2 > n3) {
            string2 = this._prefix + ".SizeWarn > " + this._prefix + ".SizeMax; adjusted SizeWarn to SizeMax (" + n3 + ")";
            this._instance.initializationData().logger.warning(string2);
            n2 = n3;
        }
        int n6 = properties.getPropertyAsIntWithDefault(this._prefix + ".ThreadIdleTime", 60);
        if (n6 < 0) {
            String string5 = this._prefix + ".ThreadIdleTime < 0; ThreadIdleTime adjusted to 0";
            this._instance.initializationData().logger.warning(string5);
            n6 = 0;
        }
        this._size = n5;
        this._sizeMax = n3;
        this._sizeWarn = n2;
        this._sizeIO = Math.min(n3, n4);
        this._threadIdleTime = n6;
        int n7 = properties.getPropertyAsInt(this._prefix + ".StackSize");
        if (n7 < 0) {
            String string6 = this._prefix + ".StackSize < 0; Size adjusted to JRE default";
            this._instance.initializationData().logger.warning(string6);
            n7 = 0;
        }
        this._stackSize = n7;
        boolean bl = properties.getProperty(this._prefix + ".ThreadPriority").length() > 0;
        int n8 = properties.getPropertyAsInt(this._prefix + ".ThreadPriority");
        if (!bl) {
            bl = properties.getProperty("Ice.ThreadPriority").length() > 0;
            n8 = properties.getPropertyAsInt("Ice.ThreadPriority");
        }
        this._hasPriority = bl;
        this._priority = n8;
        this._workQueue = new ThreadPoolWorkQueue(this._instance, this, this._selector);
        this._nextHandler = this._handlers.iterator();
        if (this._instance.traceLevels().threadPool >= 1) {
            String string7 = "creating " + this._prefix + ": Size = " + this._size + ", SizeMax = " + this._sizeMax + ", SizeWarn = " + this._sizeWarn;
            this._instance.initializationData().logger.trace(this._instance.traceLevels().threadPoolCat, string7);
        }
        try {
            for (int i = 0; i < this._size; ++i) {
                EventHandlerThread eventHandlerThread = new EventHandlerThread(this._threadPrefix + "-" + this._threadIndex++);
                if (this._hasPriority) {
                    eventHandlerThread.start(this._priority);
                } else {
                    eventHandlerThread.start(5);
                }
                this._threads.add(eventHandlerThread);
            }
        }
        catch (RuntimeException runtimeException) {
            String string8 = "cannot create thread for `" + this._prefix + "':\n" + Ex.toString(runtimeException);
            this._instance.initializationData().logger.error(string8);
            this.destroy();
            try {
                this.joinWithAllThreads();
            }
            catch (InterruptedException interruptedException) {
                throw new OperationInterruptedException();
            }
            throw runtimeException;
        }
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._destroyed);
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void destroy() {
        if (this._destroyed) {
            return;
        }
        this._destroyed = true;
        this._workQueue.destroy();
    }

    public synchronized void updateObservers() {
        for (EventHandlerThread eventHandlerThread : this._threads) {
            eventHandlerThread.updateObserver();
        }
    }

    public synchronized void initialize(EventHandler eventHandler) {
        assert (!this._destroyed);
        this._selector.initialize(eventHandler);
    }

    public void register(EventHandler eventHandler, int n) {
        this.update(eventHandler, 0, n);
    }

    public synchronized void update(EventHandler eventHandler, int n, int n2) {
        assert (!this._destroyed);
        n &= ~n2;
        if ((n = eventHandler._registered & n) == (n2 = ~eventHandler._registered & n2)) {
            return;
        }
        this._selector.update(eventHandler, n, n2);
        if ((n2 & 1) != 0 && ((Boolean)eventHandler._hasMoreData.value).booleanValue() && (eventHandler._disabled & 1) == 0) {
            if (this._pendingHandlers.isEmpty()) {
                this._workQueue.queue(_interruptWorkItem);
            }
            this._pendingHandlers.add(eventHandler);
        } else if ((n & 1) != 0) {
            this._pendingHandlers.remove(eventHandler);
        }
    }

    public void unregister(EventHandler eventHandler, int n) {
        this.update(eventHandler, n, 0);
    }

    public synchronized boolean finish(EventHandler eventHandler, boolean bl) {
        assert (!this._destroyed);
        bl = this._selector.finish(eventHandler, bl);
        this._pendingHandlers.remove(eventHandler);
        this._workQueue.queue(new FinishedWorkItem(eventHandler, !bl));
        return bl;
    }

    public void dispatchFromThisThread(DispatchWorkItem dispatchWorkItem) {
        if (this._dispatcher != null) {
            try {
                this._dispatcher.dispatch(dispatchWorkItem, dispatchWorkItem.getConnection());
            }
            catch (Exception exception) {
                if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 1) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    exception.printStackTrace(printWriter);
                    printWriter.flush();
                    this._instance.initializationData().logger.warning("dispatch exception:\n" + stringWriter.toString());
                }
            }
        } else {
            dispatchWorkItem.run();
        }
    }

    public void dispatch(DispatchWorkItem dispatchWorkItem) {
        this._workQueue.queue(dispatchWorkItem);
    }

    public void joinWithAllThreads() throws InterruptedException {
        for (EventHandlerThread eventHandlerThread : this._threads) {
            eventHandlerThread.join();
        }
        this._selector.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(EventHandlerThread eventHandlerThread) {
        ThreadPoolCurrent threadPoolCurrent = new ThreadPoolCurrent(this._instance, this, eventHandlerThread);
        boolean bl = false;
        while (true) {
            Iterator<EventHandler> iterator;
            if (threadPoolCurrent._handler != null) {
                try {
                    threadPoolCurrent._handler.message(threadPoolCurrent);
                }
                catch (DestroyedException destroyedException) {
                    return;
                }
                catch (Exception exception) {
                    iterator = "exception in `" + this._prefix + "':\n" + Ex.toString(exception);
                    iterator = (String)((Object)iterator) + "\nevent handler: " + threadPoolCurrent._handler.toString();
                    this._instance.initializationData().logger.error((String)((Object)iterator));
                }
            } else if (bl && this._workQueue.size() == 0) {
                try {
                    this._selector.select(this._serverIdleTime);
                }
                catch (Selector.TimeoutException timeoutException) {
                    iterator = this;
                    synchronized (iterator) {
                        if (!this._destroyed && this._inUse == 0) {
                            this._workQueue.queue(new ShutdownWorkItem());
                        }
                        continue;
                    }
                }
            }
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                if (threadPoolCurrent._handler == null) {
                    if (bl) {
                        this._selector.finishSelect(this._handlers);
                        this._workQueue.update(this._handlers);
                        bl = false;
                        if (!this._pendingHandlers.isEmpty()) {
                            for (EventHandlerOpPair eventHandlerOpPair : this._handlers) {
                                this._pendingHandlers.remove(eventHandlerOpPair.handler);
                            }
                            for (EventHandler eventHandler : this._pendingHandlers) {
                                this._handlers.add(new EventHandlerOpPair(eventHandler, 1));
                            }
                            this._pendingHandlers.clear();
                        }
                        this._nextHandler = this._handlers.iterator();
                    } else if (!threadPoolCurrent._leader && this.followerWait(threadPoolCurrent)) {
                        return;
                    }
                } else if (this._sizeMax > 1) {
                    if (!threadPoolCurrent._ioCompleted) {
                        --this._inUseIO;
                        if (((Boolean)threadPoolCurrent._handler._hasMoreData.value).booleanValue() && (threadPoolCurrent._handler._registered & 1) != 0) {
                            if (this._pendingHandlers.isEmpty()) {
                                this._workQueue.queue(_interruptWorkItem);
                            }
                            this._pendingHandlers.add(threadPoolCurrent._handler);
                        }
                    } else {
                        if (this._serialize) {
                            this._selector.enable(threadPoolCurrent._handler, threadPoolCurrent.operation);
                            if (((Boolean)threadPoolCurrent._handler._hasMoreData.value).booleanValue() && (threadPoolCurrent._handler._registered & 1) != 0) {
                                if (this._pendingHandlers.isEmpty()) {
                                    this._workQueue.queue(_interruptWorkItem);
                                }
                                this._pendingHandlers.add(threadPoolCurrent._handler);
                            }
                        }
                        assert (this._inUse > 0);
                        --this._inUse;
                    }
                    if (!threadPoolCurrent._leader && this.followerWait(threadPoolCurrent)) {
                        return;
                    }
                } else if (((Boolean)threadPoolCurrent._handler._hasMoreData.value).booleanValue() && (threadPoolCurrent._handler._registered & 1) != 0) {
                    if (this._pendingHandlers.isEmpty()) {
                        this._workQueue.queue(_interruptWorkItem);
                    }
                    this._pendingHandlers.add(threadPoolCurrent._handler);
                }
                iterator = null;
                while (this._nextHandler.hasNext()) {
                    EventHandlerOpPair eventHandlerOpPair = this._nextHandler.next();
                    if ((eventHandlerOpPair.op & eventHandlerOpPair.handler._registered) == 0) continue;
                    iterator = eventHandlerOpPair;
                    break;
                }
                if (iterator != null) {
                    threadPoolCurrent._ioCompleted = false;
                    threadPoolCurrent._handler = ((EventHandlerOpPair)((Object)iterator)).handler;
                    threadPoolCurrent.operation = ((EventHandlerOpPair)((Object)iterator)).op;
                    eventHandlerThread.setState(ThreadState.ThreadStateInUseForIO);
                } else {
                    threadPoolCurrent._handler = null;
                }
                if (threadPoolCurrent._handler == null) {
                    if (this._inUseIO > 0) {
                        this.promoteFollower(threadPoolCurrent);
                    } else {
                        this._handlers.clear();
                        this._selector.startSelect();
                        bl = true;
                        eventHandlerThread.setState(ThreadState.ThreadStateIdle);
                    }
                } else if (this._sizeMax > 1) {
                    ++this._inUseIO;
                    if (this._nextHandler.hasNext() && this._inUseIO < this._sizeIO) {
                        this.promoteFollower(threadPoolCurrent);
                    }
                }
            }
        }
    }

    synchronized void ioCompleted(ThreadPoolCurrent threadPoolCurrent) {
        threadPoolCurrent._ioCompleted = true;
        threadPoolCurrent._thread.setState(ThreadState.ThreadStateInUseForUser);
        if (this._sizeMax > 1) {
            Object object;
            --this._inUseIO;
            if (!this._destroyed) {
                if (this._serialize) {
                    this._selector.disable(threadPoolCurrent._handler, threadPoolCurrent.operation);
                    this._pendingHandlers.remove(threadPoolCurrent._handler);
                } else if (((Boolean)threadPoolCurrent._handler._hasMoreData.value).booleanValue() && (threadPoolCurrent._handler._registered & 1) != 0) {
                    if (this._pendingHandlers.isEmpty()) {
                        this._workQueue.queue(_interruptWorkItem);
                    }
                    this._pendingHandlers.add(threadPoolCurrent._handler);
                }
            }
            if (threadPoolCurrent._leader) {
                this.promoteFollower(threadPoolCurrent);
            } else if (this._promote && (this._nextHandler.hasNext() || this._inUseIO == 0)) {
                this.notify();
            }
            assert (this._inUse >= 0);
            ++this._inUse;
            if (this._inUse == this._sizeWarn) {
                object = "thread pool `" + this._prefix + "' is running low on threads\nSize=" + this._size + ", SizeMax=" + this._sizeMax + ", SizeWarn=" + this._sizeWarn;
                this._instance.initializationData().logger.warning((String)object);
            }
            if (!this._destroyed) {
                assert (this._inUse <= this._threads.size());
                if (this._inUse < this._sizeMax && this._inUse == this._threads.size()) {
                    if (this._instance.traceLevels().threadPool >= 1) {
                        object = "growing " + this._prefix + ": Size=" + (this._threads.size() + 1);
                        this._instance.initializationData().logger.trace(this._instance.traceLevels().threadPoolCat, (String)object);
                    }
                    try {
                        object = new EventHandlerThread(this._threadPrefix + "-" + this._threadIndex++);
                        this._threads.add((EventHandlerThread)object);
                        if (this._hasPriority) {
                            ((EventHandlerThread)object).start(this._priority);
                        } else {
                            ((EventHandlerThread)object).start(5);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        String string = "cannot create thread for `" + this._prefix + "':\n" + Ex.toString(runtimeException);
                        this._instance.initializationData().logger.error(string);
                    }
                }
            }
        }
    }

    private synchronized void promoteFollower(ThreadPoolCurrent threadPoolCurrent) {
        assert (!this._promote && threadPoolCurrent._leader);
        this._promote = true;
        if (this._inUseIO < this._sizeIO && (this._nextHandler.hasNext() || this._inUseIO == 0)) {
            this.notify();
        }
        threadPoolCurrent._leader = false;
    }

    private synchronized boolean followerWait(ThreadPoolCurrent threadPoolCurrent) {
        assert (!threadPoolCurrent._leader);
        threadPoolCurrent._thread.setState(ThreadState.ThreadStateIdle);
        threadPoolCurrent._handler = null;
        threadPoolCurrent.stream.reset();
        while (!this._promote || this._inUseIO == this._sizeIO || !this._nextHandler.hasNext() && this._inUseIO > 0) {
            if (this._threadIdleTime > 0L) {
                long l = Time.currentMonotonicTimeMillis();
                boolean bl = false;
                try {
                    this.wait(this._threadIdleTime * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
                if (!bl && Time.currentMonotonicTimeMillis() - l < this._threadIdleTime * 1000L || this._destroyed || this._promote && this._inUseIO != this._sizeIO && (this._nextHandler.hasNext() || this._inUseIO <= 0)) continue;
                if (this._instance.traceLevels().threadPool >= 1) {
                    String string = "shrinking " + this._prefix + ": Size=" + (this._threads.size() - 1);
                    this._instance.initializationData().logger.trace(this._instance.traceLevels().threadPoolCat, string);
                }
                assert (this._threads.size() > 1);
                this._threads.remove(threadPoolCurrent._thread);
                this._workQueue.queue(new JoinThreadWorkItem(threadPoolCurrent._thread));
                return true;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        threadPoolCurrent._leader = true;
        this._promote = false;
        return false;
    }

    final class EventHandlerThread
    implements Runnable {
        private final String _name;
        private Thread _thread;
        private ThreadState _state;
        private ThreadObserver _observer;

        EventHandlerThread(String string) {
            this._name = string;
            this._state = ThreadState.ThreadStateIdle;
            this.updateObserver();
        }

        public void updateObserver() {
            CommunicatorObserver communicatorObserver = ((ThreadPool)ThreadPool.this)._instance.initializationData().observer;
            if (communicatorObserver != null) {
                this._observer = communicatorObserver.getThreadObserver(ThreadPool.this._prefix, this._name, this._state, this._observer);
                if (this._observer != null) {
                    this._observer.attach();
                }
            }
        }

        public void setState(ThreadState threadState) {
            if (this._observer != null && this._state != threadState) {
                this._observer.stateChanged(this._state, threadState);
            }
            this._state = threadState;
        }

        public void join() throws InterruptedException {
            this._thread.join();
        }

        public void start(int n) {
            this._thread = new Thread(null, this, this._name, ThreadPool.this._stackSize);
            this._thread.setPriority(n);
            this._thread.start();
        }

        @Override
        public void run() {
            String string;
            if (((ThreadPool)ThreadPool.this)._instance.initializationData().threadHook != null) {
                try {
                    ((ThreadPool)ThreadPool.this)._instance.initializationData().threadHook.start();
                }
                catch (Exception exception) {
                    string = "thread hook start() method raised an unexpected exception in `";
                    string = string + ThreadPool.this._prefix + "' thread " + this._name + ":\n" + Ex.toString(exception);
                    ((ThreadPool)ThreadPool.this)._instance.initializationData().logger.error(string);
                }
            }
            try {
                ThreadPool.this.run(this);
            }
            catch (Exception exception) {
                string = "exception in `" + ThreadPool.this._prefix + "' thread " + this._name + ":\n" + Ex.toString(exception);
                ((ThreadPool)ThreadPool.this)._instance.initializationData().logger.error(string);
            }
            if (this._observer != null) {
                this._observer.detach();
            }
            if (((ThreadPool)ThreadPool.this)._instance.initializationData().threadHook != null) {
                try {
                    ((ThreadPool)ThreadPool.this)._instance.initializationData().threadHook.stop();
                }
                catch (Exception exception) {
                    string = "thread hook stop() method raised an unexpected exception in `";
                    string = string + ThreadPool.this._prefix + "' thread " + this._name + ":\n" + Ex.toString(exception);
                    ((ThreadPool)ThreadPool.this)._instance.initializationData().logger.error(string);
                }
            }
        }
    }

    static final class DestroyedException
    extends RuntimeException {
        DestroyedException() {
        }
    }

    static final class InterruptWorkItem
    implements ThreadPoolWorkItem {
        InterruptWorkItem() {
        }

        @Override
        public void execute(ThreadPoolCurrent threadPoolCurrent) {
        }
    }

    static final class JoinThreadWorkItem
    implements ThreadPoolWorkItem {
        private final EventHandlerThread _thread;

        public JoinThreadWorkItem(EventHandlerThread eventHandlerThread) {
            this._thread = eventHandlerThread;
        }

        @Override
        public void execute(ThreadPoolCurrent threadPoolCurrent) {
            try {
                this._thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static final class FinishedWorkItem
    implements ThreadPoolWorkItem {
        private final EventHandler _handler;
        private final boolean _close;

        public FinishedWorkItem(EventHandler eventHandler, boolean bl) {
            this._handler = eventHandler;
            this._close = bl;
        }

        @Override
        public void execute(ThreadPoolCurrent threadPoolCurrent) {
            this._handler.finished(threadPoolCurrent, this._close);
        }
    }

    final class ShutdownWorkItem
    implements ThreadPoolWorkItem {
        ShutdownWorkItem() {
        }

        @Override
        public void execute(ThreadPoolCurrent threadPoolCurrent) {
            threadPoolCurrent.ioCompleted();
            try {
                ThreadPool.this._instance.objectAdapterFactory().shutdown();
            }
            catch (CommunicatorDestroyedException communicatorDestroyedException) {
                // empty catch block
            }
        }
    }
}

