/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectionInfo;
import Ice.Holder;
import Ice.IPConnectionInfo;
import Ice.LocalException;
import Ice.TCPConnectionInfo;
import Ice.WSConnectionInfo;
import IceInternal.Buffer;
import IceInternal.EndpointI;
import IceInternal.Network;
import IceInternal.ProtocolInstance;
import IceInternal.StreamSocket;
import IceInternal.Transceiver;
import IceInternal.WSTransceiverDelegate;
import java.net.Socket;
import java.nio.channels.SelectableChannel;
import java.util.Map;

final class TcpTransceiver
implements Transceiver,
WSTransceiverDelegate {
    private final ProtocolInstance _instance;
    private final StreamSocket _stream;

    @Override
    public SelectableChannel fd() {
        assert (this._stream != null);
        return this._stream.fd();
    }

    @Override
    public int initialize(Buffer buffer, Buffer buffer2, Holder<Boolean> holder) {
        return this._stream.connect(buffer, buffer2);
    }

    @Override
    public int closing(boolean bl, LocalException localException) {
        return bl ? 1 : 0;
    }

    @Override
    public void close() {
        this._stream.close();
    }

    @Override
    public EndpointI bind() {
        assert (false);
        return null;
    }

    @Override
    public int write(Buffer buffer) {
        return this._stream.write(buffer);
    }

    @Override
    public int read(Buffer buffer, Holder<Boolean> holder) {
        return this._stream.read(buffer);
    }

    @Override
    public String protocol() {
        return this._instance.protocol();
    }

    @Override
    public String toString() {
        return this._stream.toString();
    }

    @Override
    public String toDetailedString() {
        return this.toString();
    }

    @Override
    public ConnectionInfo getInfo() {
        TCPConnectionInfo tCPConnectionInfo = new TCPConnectionInfo();
        this.fillConnectionInfo(tCPConnectionInfo);
        return tCPConnectionInfo;
    }

    @Override
    public ConnectionInfo getWSInfo(Map<String, String> map) {
        WSConnectionInfo wSConnectionInfo = new WSConnectionInfo();
        this.fillConnectionInfo(wSConnectionInfo);
        wSConnectionInfo.headers = map;
        return wSConnectionInfo;
    }

    @Override
    public void checkSendSize(Buffer buffer) {
    }

    @Override
    public void setBufferSize(int n, int n2) {
        this._stream.setBufferSize(n, n2);
    }

    TcpTransceiver(ProtocolInstance protocolInstance, StreamSocket streamSocket) {
        this._instance = protocolInstance;
        this._stream = streamSocket;
    }

    private void fillConnectionInfo(IPConnectionInfo iPConnectionInfo) {
        if (this._stream.fd() != null) {
            Socket socket = this._stream.fd().socket();
            iPConnectionInfo.localAddress = socket.getLocalAddress().getHostAddress();
            iPConnectionInfo.localPort = socket.getLocalPort();
            if (socket.getInetAddress() != null) {
                iPConnectionInfo.remoteAddress = socket.getInetAddress().getHostAddress();
                iPConnectionInfo.remotePort = socket.getPort();
            }
            if (!socket.isClosed()) {
                iPConnectionInfo.rcvSize = Network.getRecvBufferSize(this._stream.fd());
                iPConnectionInfo.sndSize = Network.getSendBufferSize(this._stream.fd());
            }
        }
    }
}

