/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.EndpointInfo;
import Ice.EndpointParseException;
import Ice.IPEndpointInfo;
import Ice.TCPEndpointInfo;
import Ice.WSEndpointInfo;
import IceInternal.Acceptor;
import IceInternal.BasicStream;
import IceInternal.Connector;
import IceInternal.EndpointI;
import IceInternal.HashUtil;
import IceInternal.IPEndpointI;
import IceInternal.NetworkProxy;
import IceInternal.ProtocolInstance;
import IceInternal.TcpAcceptor;
import IceInternal.TcpConnector;
import IceInternal.Transceiver;
import IceInternal.WSEndpointDelegate;
import java.net.InetSocketAddress;

final class TcpEndpointI
extends IPEndpointI
implements WSEndpointDelegate {
    private int _timeout;
    private boolean _compress;

    public TcpEndpointI(ProtocolInstance protocolInstance, String string, int n, InetSocketAddress inetSocketAddress, int n2, String string2, boolean bl) {
        super(protocolInstance, string, n, inetSocketAddress, string2);
        this._timeout = n2;
        this._compress = bl;
    }

    public TcpEndpointI(ProtocolInstance protocolInstance) {
        super(protocolInstance);
        this._timeout = this._instance.defaultTimeout();
        this._compress = false;
    }

    public TcpEndpointI(ProtocolInstance protocolInstance, BasicStream basicStream) {
        super(protocolInstance, basicStream);
        this._timeout = basicStream.readInt();
        this._compress = basicStream.readBool();
    }

    @Override
    public EndpointInfo getInfo() {
        TCPEndpointInfo tCPEndpointInfo = new TCPEndpointInfo(){

            @Override
            public short type() {
                return TcpEndpointI.this.type();
            }

            @Override
            public boolean datagram() {
                return TcpEndpointI.this.datagram();
            }

            @Override
            public boolean secure() {
                return TcpEndpointI.this.secure();
            }
        };
        this.fillEndpointInfo(tCPEndpointInfo);
        return tCPEndpointInfo;
    }

    @Override
    public EndpointInfo getWSInfo(String string) {
        WSEndpointInfo wSEndpointInfo = new WSEndpointInfo(){

            @Override
            public short type() {
                return TcpEndpointI.this.type();
            }

            @Override
            public boolean datagram() {
                return TcpEndpointI.this.datagram();
            }

            @Override
            public boolean secure() {
                return TcpEndpointI.this.secure();
            }
        };
        this.fillEndpointInfo(wSEndpointInfo);
        wSEndpointInfo.resource = string;
        return wSEndpointInfo;
    }

    @Override
    public int timeout() {
        return this._timeout;
    }

    @Override
    public EndpointI timeout(int n) {
        if (n == this._timeout) {
            return this;
        }
        return new TcpEndpointI(this._instance, this._host, this._port, this._sourceAddr, n, this._connectionId, this._compress);
    }

    @Override
    public boolean compress() {
        return this._compress;
    }

    @Override
    public EndpointI compress(boolean bl) {
        if (bl == this._compress) {
            return this;
        }
        return new TcpEndpointI(this._instance, this._host, this._port, this._sourceAddr, this._timeout, this._connectionId, bl);
    }

    @Override
    public boolean datagram() {
        return false;
    }

    @Override
    public Transceiver transceiver() {
        return null;
    }

    @Override
    public Acceptor acceptor(String string) {
        return new TcpAcceptor(this, this._instance, this._host, this._port);
    }

    public TcpEndpointI endpoint(TcpAcceptor tcpAcceptor) {
        return new TcpEndpointI(this._instance, this._host, tcpAcceptor.effectivePort(), this._sourceAddr, this._timeout, this._connectionId, this._compress);
    }

    @Override
    public String options() {
        String string = super.options();
        string = this._timeout == -1 ? string + " -t infinite" : string + " -t " + this._timeout;
        if (this._compress) {
            string = string + " -z";
        }
        return string;
    }

    @Override
    public int compareTo(EndpointI endpointI) {
        if (!(endpointI instanceof TcpEndpointI)) {
            return this.type() < endpointI.type() ? -1 : 1;
        }
        TcpEndpointI tcpEndpointI = (TcpEndpointI)endpointI;
        if (this == tcpEndpointI) {
            return 0;
        }
        if (this._timeout < tcpEndpointI._timeout) {
            return -1;
        }
        if (tcpEndpointI._timeout < this._timeout) {
            return 1;
        }
        if (!this._compress && tcpEndpointI._compress) {
            return -1;
        }
        if (!tcpEndpointI._compress && this._compress) {
            return 1;
        }
        return super.compareTo(endpointI);
    }

    @Override
    public void streamWriteImpl(BasicStream basicStream) {
        super.streamWriteImpl(basicStream);
        basicStream.writeInt(this._timeout);
        basicStream.writeBool(this._compress);
    }

    @Override
    public int hashInit(int n) {
        n = super.hashInit(n);
        n = HashUtil.hashAdd(n, this._timeout);
        n = HashUtil.hashAdd(n, this._compress);
        return n;
    }

    @Override
    public void fillEndpointInfo(IPEndpointInfo iPEndpointInfo) {
        super.fillEndpointInfo(iPEndpointInfo);
        iPEndpointInfo.timeout = this._timeout;
        iPEndpointInfo.compress = this._compress;
    }

    @Override
    protected boolean checkOption(String string, String string2, String string3) {
        if (super.checkOption(string, string2, string3)) {
            return true;
        }
        switch (string.charAt(1)) {
            case 't': {
                if (string2 == null) {
                    throw new EndpointParseException("no argument provided for -t option in endpoint " + string3);
                }
                if (string2.equals("infinite")) {
                    this._timeout = -1;
                } else {
                    try {
                        this._timeout = Integer.parseInt(string2);
                        if (this._timeout < 1) {
                            throw new EndpointParseException("invalid timeout value `" + string2 + "' in endpoint " + string3);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new EndpointParseException("invalid timeout value `" + string2 + "' in endpoint " + string3);
                    }
                }
                return true;
            }
            case 'z': {
                if (string2 != null) {
                    throw new EndpointParseException("unexpected argument `" + string2 + "' provided for -z option in " + string3);
                }
                this._compress = true;
                return true;
            }
        }
        return false;
    }

    @Override
    protected Connector createConnector(InetSocketAddress inetSocketAddress, NetworkProxy networkProxy) {
        return new TcpConnector(this._instance, inetSocketAddress, networkProxy, this._sourceAddr, this._timeout, this._connectionId);
    }

    @Override
    protected IPEndpointI createEndpoint(String string, int n, String string2) {
        return new TcpEndpointI(this._instance, string, n, this._sourceAddr, this._timeout, string2, this._compress);
    }
}

