/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import IceInternal.Connector;
import IceInternal.HashUtil;
import IceInternal.Network;
import IceInternal.NetworkProxy;
import IceInternal.ProtocolInstance;
import IceInternal.StreamSocket;
import IceInternal.TcpTransceiver;
import IceInternal.Transceiver;
import java.net.InetSocketAddress;

final class TcpConnector
implements Connector {
    private ProtocolInstance _instance;
    private InetSocketAddress _addr;
    private NetworkProxy _proxy;
    private InetSocketAddress _sourceAddr;
    private int _timeout;
    private String _connectionId = "";
    private int _hashCode;

    @Override
    public Transceiver connect() {
        return new TcpTransceiver(this._instance, new StreamSocket(this._instance, this._proxy, this._addr, this._sourceAddr));
    }

    @Override
    public short type() {
        return this._instance.type();
    }

    @Override
    public String toString() {
        return Network.addrToString(this._proxy == null ? this._addr : this._proxy.getAddress());
    }

    public int hashCode() {
        return this._hashCode;
    }

    TcpConnector(ProtocolInstance protocolInstance, InetSocketAddress inetSocketAddress, NetworkProxy networkProxy, InetSocketAddress inetSocketAddress2, int n, String string) {
        this._instance = protocolInstance;
        this._addr = inetSocketAddress;
        this._proxy = networkProxy;
        this._sourceAddr = inetSocketAddress2;
        this._timeout = n;
        this._connectionId = string;
        this._hashCode = 5381;
        this._hashCode = HashUtil.hashAdd(this._hashCode, this._addr.getAddress().getHostAddress());
        this._hashCode = HashUtil.hashAdd(this._hashCode, this._addr.getPort());
        if (this._sourceAddr != null) {
            this._hashCode = HashUtil.hashAdd(this._hashCode, this._sourceAddr.getAddress().getHostAddress());
        }
        this._hashCode = HashUtil.hashAdd(this._hashCode, this._timeout);
        this._hashCode = HashUtil.hashAdd(this._hashCode, this._connectionId);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof TcpConnector)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        TcpConnector tcpConnector = (TcpConnector)object;
        if (this._timeout != tcpConnector._timeout) {
            return false;
        }
        if (!this._connectionId.equals(tcpConnector._connectionId)) {
            return false;
        }
        if (Network.compareAddress(this._sourceAddr, tcpConnector._sourceAddr) != 0) {
            return false;
        }
        return Network.compareAddress(this._addr, tcpConnector._addr) == 0;
    }
}

