/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Exception;
import IceInternal.Acceptor;
import IceInternal.EndpointI;
import IceInternal.Network;
import IceInternal.ProtocolInstance;
import IceInternal.StreamSocket;
import IceInternal.TcpEndpointI;
import IceInternal.TcpTransceiver;
import IceInternal.Transceiver;
import IceUtilInternal.Assert;
import IceUtilInternal.StringUtil;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;

class TcpAcceptor
implements Acceptor {
    private TcpEndpointI _endpoint;
    private ProtocolInstance _instance;
    private ServerSocketChannel _fd;
    private int _backlog;
    private InetSocketAddress _addr;

    @Override
    public ServerSocketChannel fd() {
        return this._fd;
    }

    @Override
    public void close() {
        if (this._fd != null) {
            Network.closeSocketNoThrow(this._fd);
            this._fd = null;
        }
    }

    @Override
    public EndpointI listen() {
        try {
            this._addr = Network.doBind(this._fd, this._addr, this._backlog);
        }
        catch (Exception exception) {
            this._fd = null;
            throw exception;
        }
        this._endpoint = this._endpoint.endpoint(this);
        return this._endpoint;
    }

    @Override
    public Transceiver accept() {
        return new TcpTransceiver(this._instance, new StreamSocket(this._instance, Network.doAccept(this._fd)));
    }

    @Override
    public String protocol() {
        return this._instance.protocol();
    }

    @Override
    public String toString() {
        return Network.addrToString(this._addr);
    }

    @Override
    public String toDetailedString() {
        StringBuffer stringBuffer = new StringBuffer("local address = ");
        stringBuffer.append(this.toString());
        ArrayList<String> arrayList = Network.getHostsForEndpointExpand(this._addr.getAddress().getHostAddress(), this._instance.protocolSupport(), true);
        if (!arrayList.isEmpty()) {
            stringBuffer.append("\nlocal interfaces = ");
            stringBuffer.append(StringUtil.joinString(arrayList, ", "));
        }
        return stringBuffer.toString();
    }

    int effectivePort() {
        return this._addr.getPort();
    }

    TcpAcceptor(TcpEndpointI tcpEndpointI, ProtocolInstance protocolInstance, String string, int n) {
        this._endpoint = tcpEndpointI;
        this._instance = protocolInstance;
        this._backlog = protocolInstance.properties().getPropertyAsIntWithDefault("Ice.TCP.Backlog", 511);
        try {
            this._fd = Network.createTcpServerSocket();
            Network.setBlock(this._fd, false);
            Network.setTcpBufSize(this._fd, protocolInstance);
            if (!System.getProperty("os.name").startsWith("Windows")) {
                Network.setReuseAddress(this._fd, true);
            }
            this._addr = Network.getAddressForServer(string, n, protocolInstance.protocolSupport(), protocolInstance.preferIPv6());
        }
        catch (RuntimeException runtimeException) {
            this._fd = null;
            throw runtimeException;
        }
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._fd == null);
        }
        catch (java.lang.Exception exception) {
        }
        finally {
            super.finalize();
        }
    }
}

