/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectionLostException;
import Ice.LocalException;
import Ice.SocketException;
import IceInternal.Buffer;
import IceInternal.Network;
import IceInternal.NetworkProxy;
import IceInternal.ProtocolInstance;
import IceUtilInternal.Assert;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class StreamSocket {
    private final ProtocolInstance _instance;
    private final NetworkProxy _proxy;
    private final InetSocketAddress _addr;
    private SocketChannel _fd;
    private int _maxSendPacketSize;
    private int _state;
    private String _desc;
    private static final int StateNeedConnect = 0;
    private static final int StateConnectPending = 1;
    private static final int StateProxyRead = 2;
    private static final int StateProxyWrite = 3;
    private static final int StateProxyConnected = 4;
    private static final int StateConnected = 5;

    public StreamSocket(ProtocolInstance protocolInstance, NetworkProxy networkProxy, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
        this._instance = protocolInstance;
        this._proxy = networkProxy;
        this._addr = inetSocketAddress;
        this._fd = Network.createTcpSocket();
        this._state = 0;
        try {
            this.init();
            if (Network.doConnect(this._fd, this._proxy != null ? this._proxy.getAddress() : this._addr, inetSocketAddress2)) {
                this._state = this._proxy != null ? 3 : 5;
            }
        }
        catch (LocalException localException) {
            assert (!this._fd.isOpen());
            this._fd = null;
            throw localException;
        }
        this._desc = Network.fdToString(this._fd, this._proxy, this._addr);
    }

    public StreamSocket(ProtocolInstance protocolInstance, SocketChannel socketChannel) {
        this._instance = protocolInstance;
        this._proxy = null;
        this._addr = null;
        this._fd = socketChannel;
        this._state = 5;
        try {
            this.init();
        }
        catch (LocalException localException) {
            assert (!this._fd.isOpen());
            this._fd = null;
            throw localException;
        }
        this._desc = Network.fdToString(this._fd);
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._fd == null);
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    public void setBufferSize(int n, int n2) {
        Network.setTcpBufSize(this._fd, n, n2, this._instance);
    }

    public int connect(Buffer buffer, Buffer buffer2) {
        if (this._state == 0) {
            this._state = 1;
            return 8;
        }
        if (this._state <= 1) {
            Network.doFinishConnect(this._fd);
            this._desc = Network.fdToString(this._fd, this._proxy, this._addr);
            int n = this._state = this._proxy != null ? 3 : 5;
        }
        if (this._state == 3) {
            this._proxy.beginWrite(this._addr, buffer2);
            return 4;
        }
        if (this._state == 2) {
            this._proxy.beginRead(buffer);
            return 1;
        }
        if (this._state == 4) {
            this._proxy.finish(buffer, buffer2);
            buffer.clear();
            buffer2.clear();
            this._state = 5;
        }
        assert (this._state == 5);
        return 0;
    }

    public boolean isConnected() {
        return this._state == 5;
    }

    public SocketChannel fd() {
        return this._fd;
    }

    public int read(Buffer buffer) {
        if (this._state == 2) {
            do {
                int n;
                if ((n = this.read(buffer.b)) == 0) {
                    return 1;
                }
                this._state = this.toState(this._proxy.endRead(buffer));
            } while (this._state == 2);
            return 0;
        }
        this.read(buffer.b);
        return buffer.b.hasRemaining() ? 1 : 0;
    }

    public int write(Buffer buffer) {
        if (this._state == 3) {
            do {
                int n;
                if ((n = this.write(buffer.b)) == 0) {
                    return 4;
                }
                this._state = this.toState(this._proxy.endWrite(buffer));
            } while (this._state == 3);
            return 0;
        }
        this.write(buffer.b);
        return buffer.b.hasRemaining() ? 4 : 0;
    }

    public int read(ByteBuffer byteBuffer) {
        assert (this._fd != null);
        int n = 0;
        while (byteBuffer.hasRemaining()) {
            try {
                int n2 = this._fd.read(byteBuffer);
                if (n2 == -1) {
                    throw new ConnectionLostException();
                }
                if (n2 == 0) {
                    return n;
                }
                n += n2;
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (IOException iOException) {
                throw new ConnectionLostException(iOException);
            }
        }
        return n;
    }

    public int write(ByteBuffer byteBuffer) {
        assert (this._fd != null);
        int n = 0;
        while (byteBuffer.hasRemaining()) {
            try {
                int n2;
                if (this._maxSendPacketSize > 0 && byteBuffer.remaining() > this._maxSendPacketSize) {
                    int n3 = byteBuffer.limit();
                    byteBuffer.limit(byteBuffer.position() + this._maxSendPacketSize);
                    n2 = this._fd.write(byteBuffer);
                    byteBuffer.limit(n3);
                } else {
                    n2 = this._fd.write(byteBuffer);
                }
                if (n2 == -1) {
                    throw new ConnectionLostException();
                }
                if (n2 == 0) {
                    return n;
                }
                n += n2;
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (IOException iOException) {
                throw new SocketException(iOException);
            }
        }
        return n;
    }

    public void close() {
        assert (this._fd != null);
        try {
            this._fd.close();
        }
        catch (IOException iOException) {
            throw new SocketException(iOException);
        }
        finally {
            this._fd = null;
        }
    }

    public String toString() {
        return this._desc;
    }

    private void init() {
        Network.setBlock(this._fd, false);
        Network.setTcpBufSize(this._fd, this._instance);
        this._maxSendPacketSize = System.getProperty("os.name").startsWith("Windows") ? Math.max(512, Network.getSendBufferSize(this._fd) / 2) : 0;
    }

    private int toState(int n) {
        switch (n) {
            case 1: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        return 4;
    }
}

