/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AlreadyRegisteredException;
import Ice.Identity;
import Ice.Logger;
import Ice.NotRegisteredException;
import Ice.Object;
import Ice.ServantLocator;
import IceInternal.Ex;
import IceInternal.Instance;
import IceUtilInternal.StringUtil;
import java.util.HashMap;
import java.util.Map;

public final class ServantManager {
    private Instance _instance;
    private final String _adapterName;
    private Map<Identity, Map<String, Object>> _servantMapMap = new HashMap<Identity, Map<String, Object>>();
    private Map<String, Object> _defaultServantMap = new HashMap<String, Object>();
    private Map<String, ServantLocator> _locatorMap = new HashMap<String, ServantLocator>();

    public synchronized void addServant(Object object, Identity identity, String string) {
        Map<String, Object> map;
        assert (this._instance != null);
        if (string == null) {
            string = "";
        }
        if ((map = this._servantMapMap.get(identity)) == null) {
            map = new HashMap<String, Object>();
            this._servantMapMap.put(identity, map);
        } else if (map.containsKey(string)) {
            AlreadyRegisteredException alreadyRegisteredException = new AlreadyRegisteredException();
            alreadyRegisteredException.id = this._instance.identityToString(identity);
            alreadyRegisteredException.kindOfObject = "servant";
            if (string.length() > 0) {
                alreadyRegisteredException.id = alreadyRegisteredException.id + " -f " + StringUtil.escapeString(string, "");
            }
            throw alreadyRegisteredException;
        }
        map.put(string, object);
    }

    public synchronized void addDefaultServant(Object object, String string) {
        assert (this._instance != null);
        Object object2 = this._defaultServantMap.get(string);
        if (object2 != null) {
            AlreadyRegisteredException alreadyRegisteredException = new AlreadyRegisteredException();
            alreadyRegisteredException.kindOfObject = "default servant";
            alreadyRegisteredException.id = string;
            throw alreadyRegisteredException;
        }
        this._defaultServantMap.put(string, object);
    }

    public synchronized Object removeServant(Identity identity, String string) {
        assert (this._instance != null);
        if (string == null) {
            string = "";
        }
        Map<String, Object> map = this._servantMapMap.get(identity);
        Object object = null;
        if (map == null || (object = map.remove(string)) == null) {
            NotRegisteredException notRegisteredException = new NotRegisteredException();
            notRegisteredException.id = this._instance.identityToString(identity);
            notRegisteredException.kindOfObject = "servant";
            if (string.length() > 0) {
                notRegisteredException.id = notRegisteredException.id + " -f " + StringUtil.escapeString(string, "");
            }
            throw notRegisteredException;
        }
        if (map.isEmpty()) {
            this._servantMapMap.remove(identity);
        }
        return object;
    }

    public synchronized Object removeDefaultServant(String string) {
        assert (this._instance != null);
        Object object = this._defaultServantMap.get(string);
        if (object == null) {
            NotRegisteredException notRegisteredException = new NotRegisteredException();
            notRegisteredException.kindOfObject = "default servant";
            notRegisteredException.id = string;
            throw notRegisteredException;
        }
        this._defaultServantMap.remove(string);
        return object;
    }

    public synchronized Map<String, Object> removeAllFacets(Identity identity) {
        assert (this._instance != null);
        Map<String, Object> map = this._servantMapMap.get(identity);
        if (map == null) {
            NotRegisteredException notRegisteredException = new NotRegisteredException();
            notRegisteredException.id = this._instance.identityToString(identity);
            notRegisteredException.kindOfObject = "servant";
            throw notRegisteredException;
        }
        this._servantMapMap.remove(identity);
        return map;
    }

    public synchronized Object findServant(Identity identity, String string) {
        if (string == null) {
            string = "";
        }
        Map<String, Object> map = this._servantMapMap.get(identity);
        Object object = null;
        if (map == null) {
            object = this._defaultServantMap.get(identity.category);
            if (object == null) {
                object = this._defaultServantMap.get("");
            }
        } else {
            object = map.get(string);
        }
        return object;
    }

    public synchronized Object findDefaultServant(String string) {
        assert (this._instance != null);
        return this._defaultServantMap.get(string);
    }

    public synchronized Map<String, Object> findAllFacets(Identity identity) {
        assert (this._instance != null);
        Map<String, Object> map = this._servantMapMap.get(identity);
        if (map != null) {
            return new HashMap<String, Object>(map);
        }
        return new HashMap<String, Object>();
    }

    public synchronized boolean hasServant(Identity identity) {
        Map<String, Object> map = this._servantMapMap.get(identity);
        if (map == null) {
            return false;
        }
        assert (!map.isEmpty());
        return true;
    }

    public synchronized void addServantLocator(ServantLocator servantLocator, String string) {
        assert (this._instance != null);
        ServantLocator servantLocator2 = this._locatorMap.get(string);
        if (servantLocator2 != null) {
            AlreadyRegisteredException alreadyRegisteredException = new AlreadyRegisteredException();
            alreadyRegisteredException.id = StringUtil.escapeString(string, "");
            alreadyRegisteredException.kindOfObject = "servant locator";
            throw alreadyRegisteredException;
        }
        this._locatorMap.put(string, servantLocator);
    }

    public synchronized ServantLocator removeServantLocator(String string) {
        ServantLocator servantLocator = null;
        assert (this._instance != null);
        servantLocator = this._locatorMap.remove(string);
        if (servantLocator == null) {
            NotRegisteredException notRegisteredException = new NotRegisteredException();
            notRegisteredException.id = StringUtil.escapeString(string, "");
            notRegisteredException.kindOfObject = "servant locator";
            throw notRegisteredException;
        }
        return servantLocator;
    }

    public synchronized ServantLocator findServantLocator(String string) {
        return this._locatorMap.get(string);
    }

    public ServantManager(Instance instance, String string) {
        this._instance = instance;
        this._adapterName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        HashMap<String, ServantLocator> hashMap = new HashMap<String, ServantLocator>();
        Logger logger = null;
        ServantManager servantManager = this;
        synchronized (servantManager) {
            if (this._instance == null) {
                return;
            }
            logger = this._instance.initializationData().logger;
            this._servantMapMap.clear();
            this._defaultServantMap.clear();
            hashMap.putAll(this._locatorMap);
            this._locatorMap.clear();
            this._instance = null;
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            ServantLocator servantLocator = (ServantLocator)entry.getValue();
            try {
                servantLocator.deactivate((String)entry.getKey());
            }
            catch (Exception exception) {
                String string = "exception during locator deactivation:\nobject adapter: `" + this._adapterName + "'\nlocator category: `" + (String)entry.getKey() + "'\n" + Ex.toString(exception);
                logger.error(string);
            }
        }
    }
}

