/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.SyscallException;
import IceInternal.EventHandler;
import IceInternal.EventHandlerOpPair;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.Time;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class Selector {
    private final Instance _instance;
    private java.nio.channels.Selector _selector;
    private Set<SelectionKey> _keys;
    private HashSet<EventHandler> _changes = new HashSet();
    private boolean _selecting;
    private boolean _interrupted;
    private int _spuriousWakeUp;

    Selector(Instance instance) {
        this._instance = instance;
        this._selecting = false;
        this._interrupted = false;
        try {
            this._selector = java.nio.channels.Selector.open();
        }
        catch (IOException iOException) {
            throw new SyscallException(iOException);
        }
        this._keys = this._selector.selectedKeys();
    }

    void destroy() {
        try {
            this._selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._selector = null;
    }

    void initialize(EventHandler eventHandler) {
        this.updateImpl(eventHandler);
    }

    void update(EventHandler eventHandler, int n, int n2) {
        int n3 = eventHandler._registered;
        eventHandler._registered &= ~n;
        eventHandler._registered |= n2;
        if (n3 == eventHandler._registered) {
            return;
        }
        this.updateImpl(eventHandler);
    }

    void enable(EventHandler eventHandler, int n) {
        if ((eventHandler._disabled & n) == 0) {
            return;
        }
        eventHandler._disabled &= ~n;
        if (eventHandler._key != null && (eventHandler._registered & n) != 0) {
            this.updateImpl(eventHandler);
        }
    }

    void disable(EventHandler eventHandler, int n) {
        if ((eventHandler._disabled & n) != 0) {
            return;
        }
        eventHandler._disabled |= n;
        if (eventHandler._key != null && (eventHandler._registered & n) != 0) {
            this.updateImpl(eventHandler);
        }
    }

    boolean finish(EventHandler eventHandler, boolean bl) {
        eventHandler._registered = 0;
        if (eventHandler._key != null) {
            eventHandler._key.cancel();
            eventHandler._key = null;
        }
        this._changes.remove(eventHandler);
        return bl;
    }

    void startSelect() {
        if (!this._changes.isEmpty()) {
            this.updateSelector();
        }
        this._selecting = true;
    }

    void finishSelect(List<EventHandlerOpPair> list) {
        assert (list.isEmpty());
        if (this._keys.isEmpty() && !this._interrupted) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (++this._spuriousWakeUp > 100) {
                this._spuriousWakeUp = 0;
                this._instance.initializationData().logger.warning("spurious selector wake up");
            }
            return;
        }
        this._interrupted = false;
        this._spuriousWakeUp = 0;
        for (SelectionKey selectionKey : this._keys) {
            EventHandler eventHandler = (EventHandler)selectionKey.attachment();
            try {
                int n = this.fromJavaOps(selectionKey.readyOps() & selectionKey.interestOps());
                list.add(new EventHandlerOpPair(eventHandler, n));
            }
            catch (CancelledKeyException cancelledKeyException) {
                assert (eventHandler._registered == 0);
            }
        }
        this._keys.clear();
        this._selecting = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void select(long var1_1) throws TimeoutException {
        while (true) {
            try {
                if (var1_1 > 0L) {
                    var3_3 = Time.currentMonotonicTimeMillis();
                    if (this._selector.select(var1_1 * 1000L + 10L) != 0 || Time.currentMonotonicTimeMillis() - var3_3 < var1_1 * 1000L) break;
                    throw new TimeoutException();
                }
                this._selector.select();
            }
            catch (CancelledKeyException var3_4) {
                continue;
            }
            catch (IOException var3_5) {
                if (!Network.interrupted(var3_5)) ** break;
                continue;
                try {
                    var4_6 = "fatal error: selector failed:\n" + var3_5.getCause().getMessage();
                    this._instance.initializationData().logger.error(var4_6);
                }
                finally {
                    Runtime.getRuntime().halt(1);
                }
            }
            break;
        }
    }

    void wakeup() {
        this._selector.wakeup();
        this._interrupted = true;
    }

    private void updateImpl(EventHandler eventHandler) {
        this._changes.add(eventHandler);
        if (this._selecting) {
            this.wakeup();
        } else {
            this.updateSelector();
        }
    }

    private void updateSelector() {
        for (EventHandler eventHandler : this._changes) {
            int n = eventHandler._registered & ~eventHandler._disabled;
            int n2 = this.toJavaOps(eventHandler, n);
            if (eventHandler._key == null) {
                if (eventHandler._registered == 0) continue;
                try {
                    eventHandler._key = eventHandler.fd().register(this._selector, n2, eventHandler);
                    continue;
                }
                catch (ClosedChannelException closedChannelException) {
                    assert (false);
                    continue;
                }
            }
            eventHandler._key.interestOps(n2);
        }
        this._changes.clear();
    }

    private int toJavaOps(EventHandler eventHandler, int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 = (eventHandler.fd().validOps() & 1) != 0 ? (n2 |= 1) : (n2 |= 0x10);
        }
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        if ((n & 8) != 0) {
            n2 |= 8;
        }
        return n2;
    }

    private int fromJavaOps(int n) {
        int n2 = 0;
        if ((n & 0x11) != 0) {
            n2 |= 1;
        }
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        if ((n & 8) != 0) {
            n2 |= 8;
        }
        return n2;
    }

    static final class TimeoutException
    extends Exception {
        TimeoutException() {
        }
    }
}

