/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectFailedException;
import Ice.EndpointSelectionType;
import Ice.FeatureNotSupportedException;
import IceInternal.Buffer;
import IceInternal.Network;
import IceInternal.NetworkProxy;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteOrder;

public final class SOCKSNetworkProxy
implements NetworkProxy {
    private String _host;
    private int _port;
    private InetSocketAddress _address;

    public SOCKSNetworkProxy(String string, int n) {
        this._host = string;
        this._port = n;
    }

    private SOCKSNetworkProxy(InetSocketAddress inetSocketAddress) {
        this._address = inetSocketAddress;
    }

    @Override
    public void beginWrite(InetSocketAddress inetSocketAddress, Buffer buffer) {
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress == null) {
            throw new FeatureNotSupportedException("SOCKS4 does not support domain names");
        }
        if (!(inetAddress instanceof Inet4Address)) {
            throw new FeatureNotSupportedException("SOCKS4 only supports IPv4 addresses");
        }
        buffer.resize(9, false);
        ByteOrder byteOrder = buffer.b.order();
        buffer.b.order(ByteOrder.BIG_ENDIAN);
        buffer.b.position(0);
        buffer.b.put((byte)4);
        buffer.b.put((byte)1);
        buffer.b.putShort((short)inetSocketAddress.getPort());
        buffer.b.put(inetAddress.getAddress());
        buffer.b.put((byte)0);
        buffer.b.position(0);
        buffer.b.limit(buffer.size());
        buffer.b.order(byteOrder);
    }

    @Override
    public int endWrite(Buffer buffer) {
        return buffer.b.hasRemaining() ? 4 : 1;
    }

    @Override
    public void beginRead(Buffer buffer) {
        if (!buffer.b.hasRemaining()) {
            buffer.resize(8, true);
            buffer.b.position(0);
        }
    }

    @Override
    public int endRead(Buffer buffer) {
        return buffer.b.hasRemaining() ? 1 : 0;
    }

    @Override
    public void finish(Buffer buffer, Buffer buffer2) {
        buffer.b.position(0);
        byte by = buffer.b.get();
        byte by2 = buffer.b.get();
        if (by != 0 || by2 != 90) {
            throw new ConnectFailedException();
        }
    }

    @Override
    public NetworkProxy resolveHost(int n) {
        assert (this._host != null);
        return new SOCKSNetworkProxy(Network.getAddresses(this._host, this._port, n, EndpointSelectionType.Random, false, true).get(0));
    }

    @Override
    public InetSocketAddress getAddress() {
        assert (this._address != null);
        return this._address;
    }

    @Override
    public String getName() {
        return "SOCKS";
    }

    @Override
    public int getProtocolSupport() {
        return 0;
    }
}

