/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Callback_Router_addProxies;
import Ice.Callback_Router_getClientProxy;
import Ice.Identity;
import Ice.LocalException;
import Ice.NoEndpointException;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.RouterPrx;
import IceInternal.EndpointI;
import IceInternal.Reference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class RouterInfo {
    private final RouterPrx _router;
    private EndpointI[] _clientEndpoints;
    private EndpointI[] _serverEndpoints;
    private ObjectAdapter _adapter;
    private Set<Identity> _identities = new HashSet<Identity>();
    private List<Identity> _evictedIdentities = new ArrayList<Identity>();

    RouterInfo(RouterPrx routerPrx) {
        this._router = routerPrx;
        assert (this._router != null);
    }

    public synchronized void destroy() {
        this._clientEndpoints = new EndpointI[0];
        this._serverEndpoints = new EndpointI[0];
        this._adapter = null;
        this._identities.clear();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof RouterInfo) {
            return this._router.equals(((RouterInfo)object)._router);
        }
        return false;
    }

    public int hashCode() {
        return this._router.hashCode();
    }

    public RouterPrx getRouter() {
        return this._router;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointI[] getClientEndpoints() {
        RouterInfo routerInfo = this;
        synchronized (routerInfo) {
            if (this._clientEndpoints != null) {
                return this._clientEndpoints;
            }
        }
        return this.setClientEndpoints(this._router.getClientProxy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getClientEndpoints(final GetClientEndpointsCallback getClientEndpointsCallback) {
        EndpointI[] endpointIArray = null;
        RouterInfo routerInfo = this;
        synchronized (routerInfo) {
            endpointIArray = this._clientEndpoints;
        }
        if (endpointIArray != null) {
            getClientEndpointsCallback.setEndpoints(endpointIArray);
            return;
        }
        this._router.begin_getClientProxy(new Callback_Router_getClientProxy(){

            @Override
            public void response(ObjectPrx objectPrx) {
                getClientEndpointsCallback.setEndpoints(RouterInfo.this.setClientEndpoints(objectPrx));
            }

            @Override
            public void exception(LocalException localException) {
                getClientEndpointsCallback.setException(localException);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointI[] getServerEndpoints() {
        RouterInfo routerInfo = this;
        synchronized (routerInfo) {
            if (this._serverEndpoints != null) {
                return this._serverEndpoints;
            }
        }
        return this.setServerEndpoints(this._router.getServerProxy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addProxy(final ObjectPrx objectPrx, final AddProxyCallback addProxyCallback) {
        assert (objectPrx != null);
        RouterInfo routerInfo = this;
        synchronized (routerInfo) {
            if (this._identities.contains(objectPrx.ice_getIdentity())) {
                return true;
            }
        }
        this._router.begin_addProxies(new ObjectPrx[]{objectPrx}, new Callback_Router_addProxies(){

            @Override
            public void response(ObjectPrx[] objectPrxArray) {
                RouterInfo.this.addAndEvictProxies(objectPrx, objectPrxArray);
                addProxyCallback.addedProxy();
            }

            @Override
            public void exception(LocalException localException) {
                addProxyCallback.setException(localException);
            }
        });
        return false;
    }

    public synchronized void setAdapter(ObjectAdapter objectAdapter) {
        this._adapter = objectAdapter;
    }

    public synchronized ObjectAdapter getAdapter() {
        return this._adapter;
    }

    public synchronized void clearCache(Reference reference) {
        this._identities.remove(reference.getIdentity());
    }

    private synchronized EndpointI[] setClientEndpoints(ObjectPrx objectPrx) {
        if (this._clientEndpoints == null) {
            if (objectPrx == null) {
                this._clientEndpoints = ((ObjectPrxHelperBase)((Object)this._router)).__reference().getEndpoints();
            } else {
                objectPrx = objectPrx.ice_router(null);
                if (this._router.ice_getConnection() != null) {
                    objectPrx = objectPrx.ice_timeout(this._router.ice_getConnection().timeout());
                }
                this._clientEndpoints = ((ObjectPrxHelperBase)objectPrx).__reference().getEndpoints();
            }
        }
        return this._clientEndpoints;
    }

    private synchronized EndpointI[] setServerEndpoints(ObjectPrx objectPrx) {
        if (objectPrx == null) {
            throw new NoEndpointException();
        }
        objectPrx = objectPrx.ice_router(null);
        this._serverEndpoints = ((ObjectPrxHelperBase)objectPrx).__reference().getEndpoints();
        return this._serverEndpoints;
    }

    private synchronized void addAndEvictProxies(ObjectPrx objectPrx, ObjectPrx[] objectPrxArray) {
        int n = this._evictedIdentities.indexOf(objectPrx.ice_getIdentity());
        if (n >= 0) {
            this._evictedIdentities.remove(n);
        } else {
            this._identities.add(objectPrx.ice_getIdentity());
        }
        for (ObjectPrx objectPrx2 : objectPrxArray) {
            if (this._identities.remove(objectPrx2.ice_getIdentity())) continue;
            this._evictedIdentities.add(objectPrx2.ice_getIdentity());
        }
    }

    static interface AddProxyCallback {
        public void addedProxy();

        public void setException(LocalException var1);
    }

    static interface GetClientEndpointsCallback {
        public void setEndpoints(EndpointI[] var1);

        public void setException(LocalException var1);
    }
}

