/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Communicator;
import Ice.ConnectionI;
import Ice.EncodingVersion;
import Ice.EndpointSelectionType;
import Ice.Identity;
import Ice.LocalException;
import Ice.LocatorPrx;
import Ice.MarshalException;
import Ice.NoEndpointException;
import Ice.ObjectPrxHelperBase;
import Ice.ProtocolVersion;
import Ice.RouterPrx;
import IceInternal.BasicStream;
import IceInternal.BatchRequestQueue;
import IceInternal.DefaultsAndOverrides;
import IceInternal.EndpointI;
import IceInternal.HashUtil;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.OpaqueEndpointI;
import IceInternal.OutgoingConnectionFactory;
import IceInternal.Reference;
import IceInternal.RequestHandler;
import IceInternal.RouterInfo;
import IceInternal.TraceLevels;
import IceUtilInternal.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RoutableReference
extends Reference {
    private static EndpointComparator _preferNonSecureEndpointComparator = new EndpointComparator(false);
    private static EndpointComparator _preferSecureEndpointComparator = new EndpointComparator(true);
    private static EndpointI[] _emptyEndpoints = new EndpointI[0];
    private EndpointI[] _endpoints;
    private String _adapterId;
    private LocatorInfo _locatorInfo;
    private RouterInfo _routerInfo;
    private boolean _collocationOptimized;
    private boolean _cacheConnection;
    private boolean _preferSecure;
    private EndpointSelectionType _endpointSelection;
    private int _locatorCacheTimeout;
    private boolean _overrideTimeout;
    private int _timeout;
    private String _connectionId = "";

    @Override
    public final EndpointI[] getEndpoints() {
        return this._endpoints;
    }

    @Override
    public final String getAdapterId() {
        return this._adapterId;
    }

    @Override
    public final LocatorInfo getLocatorInfo() {
        return this._locatorInfo;
    }

    @Override
    public final RouterInfo getRouterInfo() {
        return this._routerInfo;
    }

    @Override
    public final boolean getCollocationOptimized() {
        return this._collocationOptimized;
    }

    @Override
    public final boolean getCacheConnection() {
        return this._cacheConnection;
    }

    @Override
    public final boolean getPreferSecure() {
        return this._preferSecure;
    }

    @Override
    public final EndpointSelectionType getEndpointSelection() {
        return this._endpointSelection;
    }

    @Override
    public final int getLocatorCacheTimeout() {
        return this._locatorCacheTimeout;
    }

    @Override
    public final String getConnectionId() {
        return this._connectionId;
    }

    @Override
    public Reference changeEncoding(EncodingVersion encodingVersion) {
        LocatorInfo locatorInfo;
        RoutableReference routableReference = (RoutableReference)super.changeEncoding(encodingVersion);
        if (routableReference != this && (locatorInfo = routableReference._locatorInfo) != null && !locatorInfo.getLocator().ice_getEncodingVersion().equals(encodingVersion)) {
            routableReference._locatorInfo = this.getInstance().locatorManager().get((LocatorPrx)locatorInfo.getLocator().ice_encodingVersion(encodingVersion));
        }
        return routableReference;
    }

    @Override
    public Reference changeCompress(boolean bl) {
        RoutableReference routableReference = (RoutableReference)super.changeCompress(bl);
        if (routableReference != this && this._endpoints.length > 0) {
            EndpointI[] endpointIArray = new EndpointI[this._endpoints.length];
            for (int i = 0; i < this._endpoints.length; ++i) {
                endpointIArray[i] = this._endpoints[i].compress(bl);
            }
            routableReference._endpoints = endpointIArray;
        }
        return routableReference;
    }

    @Override
    public Reference changeEndpoints(EndpointI[] endpointIArray) {
        if (Arrays.equals(endpointIArray, this._endpoints)) {
            return this;
        }
        RoutableReference routableReference = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        routableReference._endpoints = endpointIArray;
        routableReference._adapterId = "";
        routableReference.applyOverrides(routableReference._endpoints);
        return routableReference;
    }

    @Override
    public Reference changeAdapterId(String string) {
        if (this._adapterId.equals(string)) {
            return this;
        }
        RoutableReference routableReference = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        routableReference._adapterId = string;
        routableReference._endpoints = _emptyEndpoints;
        return routableReference;
    }

    @Override
    public Reference changeLocator(LocatorPrx locatorPrx) {
        LocatorInfo locatorInfo = this.getInstance().locatorManager().get(locatorPrx);
        if (locatorInfo != null && this._locatorInfo != null && locatorInfo.equals(this._locatorInfo)) {
            return this;
        }
        RoutableReference routableReference = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        routableReference._locatorInfo = locatorInfo;
        return routableReference;
    }

    @Override
    public Reference changeRouter(RouterPrx routerPrx) {
        RouterInfo routerInfo = this.getInstance().routerManager().get(routerPrx);
        if (routerInfo != null && this._routerInfo != null && routerInfo.equals(this._routerInfo)) {
            return this;
        }
        RoutableReference routableReference = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        routableReference._routerInfo = routerInfo;
        return routableReference;
    }

    @Override
    public Reference changeCollocationOptimized(boolean bl) {
        if (bl == this._collocationOptimized) {
            return this;
        }
        RoutableReference routableReference = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        routableReference._collocationOptimized = bl;
        return routableReference;
    }

    @Override
    public final Reference changeCacheConnection(boolean bl) {
        if (bl == this._cacheConnection) {
            return this;
        }
        RoutableReference routableReference = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        routableReference._cacheConnection = bl;
        return routableReference;
    }

    @Override
    public Reference changePreferSecure(boolean bl) {
        if (bl == this._preferSecure) {
            return this;
        }
        RoutableReference routableReference = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        routableReference._preferSecure = bl;
        return routableReference;
    }

    @Override
    public final Reference changeEndpointSelection(EndpointSelectionType endpointSelectionType) {
        if (endpointSelectionType == this._endpointSelection) {
            return this;
        }
        RoutableReference routableReference = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        routableReference._endpointSelection = endpointSelectionType;
        return routableReference;
    }

    @Override
    public Reference changeLocatorCacheTimeout(int n) {
        if (this._locatorCacheTimeout == n) {
            return this;
        }
        RoutableReference routableReference = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        routableReference._locatorCacheTimeout = n;
        return routableReference;
    }

    @Override
    public Reference changeTimeout(int n) {
        if (this._overrideTimeout && this._timeout == n) {
            return this;
        }
        RoutableReference routableReference = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        routableReference._timeout = n;
        routableReference._overrideTimeout = true;
        if (this._endpoints.length > 0) {
            EndpointI[] endpointIArray = new EndpointI[this._endpoints.length];
            for (int i = 0; i < this._endpoints.length; ++i) {
                endpointIArray[i] = this._endpoints[i].timeout(n);
            }
            routableReference._endpoints = endpointIArray;
        }
        return routableReference;
    }

    @Override
    public Reference changeConnectionId(String string) {
        if (this._connectionId.equals(string)) {
            return this;
        }
        RoutableReference routableReference = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        routableReference._connectionId = string;
        if (this._endpoints.length > 0) {
            EndpointI[] endpointIArray = new EndpointI[this._endpoints.length];
            for (int i = 0; i < this._endpoints.length; ++i) {
                endpointIArray[i] = this._endpoints[i].connectionId(string);
            }
            routableReference._endpoints = endpointIArray;
        }
        return routableReference;
    }

    @Override
    public boolean isIndirect() {
        return this._endpoints.length == 0;
    }

    @Override
    public boolean isWellKnown() {
        return this._endpoints.length == 0 && this._adapterId.length() == 0;
    }

    @Override
    public void streamWrite(BasicStream basicStream) throws MarshalException {
        super.streamWrite(basicStream);
        basicStream.writeSize(this._endpoints.length);
        if (this._endpoints.length > 0) {
            assert (this._adapterId.length() == 0);
            for (EndpointI endpointI : this._endpoints) {
                basicStream.writeShort(endpointI.type());
                endpointI.streamWrite(basicStream);
            }
        } else {
            basicStream.writeString(this._adapterId);
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(super.toString());
        if (this._endpoints.length > 0) {
            for (EndpointI endpointI : this._endpoints) {
                String string = endpointI.toString();
                if (string == null || string.length() <= 0) continue;
                stringBuilder.append(':');
                stringBuilder.append(string);
            }
        } else if (this._adapterId.length() > 0) {
            stringBuilder.append(" @ ");
            String string = StringUtil.escapeString(this._adapterId, null);
            if (StringUtil.findFirstOf(string, " :@") != -1) {
                stringBuilder.append('\"');
                stringBuilder.append(string);
                stringBuilder.append('\"');
            } else {
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public Map<String, String> toProperty(String string) {
        Map<String, String> map;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(string, this.toString());
        hashMap.put(string + ".CollocationOptimized", this._collocationOptimized ? "1" : "0");
        hashMap.put(string + ".ConnectionCached", this._cacheConnection ? "1" : "0");
        hashMap.put(string + ".PreferSecure", this._preferSecure ? "1" : "0");
        hashMap.put(string + ".EndpointSelection", this._endpointSelection == EndpointSelectionType.Random ? "Random" : "Ordered");
        Serializable serializable = new StringBuffer();
        ((StringBuffer)serializable).append(this.getInvocationTimeout());
        hashMap.put(string + ".InvocationTimeout", ((StringBuffer)serializable).toString());
        serializable = new StringBuffer();
        ((StringBuffer)serializable).append(this._locatorCacheTimeout);
        hashMap.put(string + ".LocatorCacheTimeout", ((StringBuffer)serializable).toString());
        if (this._routerInfo != null) {
            serializable = (ObjectPrxHelperBase)((Object)this._routerInfo.getRouter());
            map = ((ObjectPrxHelperBase)serializable).__reference().toProperty(string + ".Router");
            for (Map.Entry<String, String> entry : map.entrySet()) {
                hashMap.put(entry.getKey(), entry.getValue());
            }
        }
        if (this._locatorInfo != null) {
            serializable = (ObjectPrxHelperBase)((Object)this._locatorInfo.getLocator());
            map = ((ObjectPrxHelperBase)serializable).__reference().toProperty(string + ".Locator");
            for (Map.Entry<String, String> entry : map.entrySet()) {
                hashMap.put(entry.getKey(), entry.getValue());
            }
        }
        return hashMap;
    }

    @Override
    public synchronized int hashCode() {
        if (!this._hashInitialized) {
            super.hashCode();
            this._hashValue = HashUtil.hashAdd(this._hashValue, this._adapterId);
        }
        return this._hashValue;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RoutableReference)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        RoutableReference routableReference = (RoutableReference)object;
        if (this._locatorInfo == null ? routableReference._locatorInfo != null : !this._locatorInfo.equals(routableReference._locatorInfo)) {
            return false;
        }
        if (this._routerInfo == null ? routableReference._routerInfo != null : !this._routerInfo.equals(routableReference._routerInfo)) {
            return false;
        }
        if (this._collocationOptimized != routableReference._collocationOptimized) {
            return false;
        }
        if (this._cacheConnection != routableReference._cacheConnection) {
            return false;
        }
        if (this._preferSecure != routableReference._preferSecure) {
            return false;
        }
        if (this._endpointSelection != routableReference._endpointSelection) {
            return false;
        }
        if (this._locatorCacheTimeout != routableReference._locatorCacheTimeout) {
            return false;
        }
        if (!this._connectionId.equals(routableReference._connectionId)) {
            return false;
        }
        if (this._overrideTimeout != routableReference._overrideTimeout) {
            return false;
        }
        if (this._overrideTimeout && this._timeout != routableReference._timeout) {
            return false;
        }
        if (!Arrays.equals(this._endpoints, routableReference._endpoints)) {
            return false;
        }
        return this._adapterId.equals(routableReference._adapterId);
    }

    @Override
    public RequestHandler getRequestHandler(ObjectPrxHelperBase objectPrxHelperBase) {
        return this.getInstance().requestHandlerFactory().getRequestHandler(this, objectPrxHelperBase);
    }

    @Override
    public BatchRequestQueue getBatchRequestQueue() {
        return new BatchRequestQueue(this.getInstance(), this.getMode() == 4);
    }

    public void getConnection(final Reference.GetConnectionCallback getConnectionCallback) {
        if (this._routerInfo != null) {
            this._routerInfo.getClientEndpoints(new RouterInfo.GetClientEndpointsCallback(){

                @Override
                public void setEndpoints(EndpointI[] endpointIArray) {
                    if (endpointIArray.length > 0) {
                        RoutableReference.this.applyOverrides(endpointIArray);
                        RoutableReference.this.createConnection(endpointIArray, getConnectionCallback);
                    } else {
                        RoutableReference.this.getConnectionNoRouterInfo(getConnectionCallback);
                    }
                }

                @Override
                public void setException(LocalException localException) {
                    getConnectionCallback.setException(localException);
                }
            });
        } else {
            this.getConnectionNoRouterInfo(getConnectionCallback);
        }
    }

    public void getConnectionNoRouterInfo(final Reference.GetConnectionCallback getConnectionCallback) {
        if (this._endpoints.length > 0) {
            this.createConnection(this._endpoints, getConnectionCallback);
            return;
        }
        final RoutableReference routableReference = this;
        if (this._locatorInfo != null) {
            this._locatorInfo.getEndpoints(this, this._locatorCacheTimeout, new LocatorInfo.GetEndpointsCallback(){

                @Override
                public void setEndpoints(EndpointI[] endpointIArray, final boolean bl) {
                    if (endpointIArray.length == 0) {
                        getConnectionCallback.setException(new NoEndpointException(routableReference.toString()));
                        return;
                    }
                    RoutableReference.this.applyOverrides(endpointIArray);
                    RoutableReference.this.createConnection(endpointIArray, new Reference.GetConnectionCallback(){

                        @Override
                        public void setConnection(ConnectionI connectionI, boolean bl2) {
                            getConnectionCallback.setConnection(connectionI, bl2);
                        }

                        @Override
                        public void setException(LocalException localException) {
                            try {
                                throw localException;
                            }
                            catch (NoEndpointException noEndpointException) {
                                getConnectionCallback.setException(noEndpointException);
                            }
                            catch (LocalException localException2) {
                                assert (RoutableReference.this._locatorInfo != null);
                                RoutableReference.this._locatorInfo.clearCache(routableReference);
                                if (bl) {
                                    TraceLevels traceLevels = RoutableReference.this.getInstance().traceLevels();
                                    if (traceLevels.retry >= 2) {
                                        String string = "connection to cached endpoints failed\nremoving endpoints from cache and trying one more time\n" + localException2;
                                        RoutableReference.this.getInstance().initializationData().logger.trace(traceLevels.retryCat, string);
                                    }
                                    RoutableReference.this.getConnectionNoRouterInfo(getConnectionCallback);
                                    return;
                                }
                                getConnectionCallback.setException(localException2);
                            }
                        }
                    });
                }

                @Override
                public void setException(LocalException localException) {
                    getConnectionCallback.setException(localException);
                }
            });
        } else {
            getConnectionCallback.setException(new NoEndpointException(this.toString()));
        }
    }

    protected RoutableReference(Instance instance, Communicator communicator, Identity identity, String string, int n, boolean bl, ProtocolVersion protocolVersion, EncodingVersion encodingVersion, EndpointI[] endpointIArray, String string2, LocatorInfo locatorInfo, RouterInfo routerInfo, boolean bl2, boolean bl3, boolean bl4, EndpointSelectionType endpointSelectionType, int n2, int n3, Map<String, String> map) {
        super(instance, communicator, identity, string, n, bl, protocolVersion, encodingVersion, n3, map);
        this._endpoints = endpointIArray;
        this._adapterId = string2;
        this._locatorInfo = locatorInfo;
        this._routerInfo = routerInfo;
        this._collocationOptimized = bl2;
        this._cacheConnection = bl3;
        this._preferSecure = bl4;
        this._endpointSelection = endpointSelectionType;
        this._locatorCacheTimeout = n2;
        this._overrideTimeout = false;
        this._timeout = -1;
        if (this._endpoints == null) {
            this._endpoints = _emptyEndpoints;
        }
        if (this._adapterId == null) {
            this._adapterId = "";
        }
        assert (this._adapterId.length() == 0 || this._endpoints.length == 0);
    }

    protected void applyOverrides(EndpointI[] endpointIArray) {
        for (int i = 0; i < endpointIArray.length; ++i) {
            endpointIArray[i] = endpointIArray[i].connectionId(this._connectionId);
            if (this._overrideCompress) {
                endpointIArray[i] = endpointIArray[i].compress(this._compress);
            }
            if (!this._overrideTimeout) continue;
            endpointIArray[i] = endpointIArray[i].timeout(this._timeout);
        }
    }

    private EndpointI[] filterEndpoints(EndpointI[] endpointIArray) {
        Object object;
        ArrayList<EndpointI> arrayList = new ArrayList<EndpointI>();
        for (EndpointI endpointI : endpointIArray) {
            if (endpointI instanceof OpaqueEndpointI) continue;
            arrayList.add(endpointI);
        }
        switch (this.getMode()) {
            case 0: 
            case 1: 
            case 2: {
                object = arrayList.iterator();
                while (object.hasNext()) {
                    EndpointI endpointI = (EndpointI)object.next();
                    if (!endpointI.datagram()) continue;
                    object.remove();
                }
                break;
            }
            case 3: 
            case 4: {
                object = arrayList.iterator();
                while (object.hasNext()) {
                    EndpointI endpointI = (EndpointI)object.next();
                    if (endpointI.datagram()) continue;
                    object.remove();
                }
                break;
            }
        }
        switch (this.getEndpointSelection()) {
            case Random: {
                Collections.shuffle(arrayList);
                break;
            }
            case Ordered: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        object = this.getInstance().defaultsAndOverrides();
        if (((DefaultsAndOverrides)object).overrideSecure ? ((DefaultsAndOverrides)object).overrideSecureValue : this.getSecure()) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                EndpointI endpointI = (EndpointI)iterator.next();
                if (endpointI.secure()) continue;
                iterator.remove();
            }
        } else if (this.getPreferSecure()) {
            Collections.sort(arrayList, _preferSecureEndpointComparator);
        } else {
            Collections.sort(arrayList, _preferNonSecureEndpointComparator);
        }
        return arrayList.toArray(new EndpointI[arrayList.size()]);
    }

    protected void createConnection(EndpointI[] endpointIArray, final Reference.GetConnectionCallback getConnectionCallback) {
        final EndpointI[] endpointIArray2 = this.filterEndpoints(endpointIArray);
        if (endpointIArray2.length == 0) {
            getConnectionCallback.setException(new NoEndpointException(this.toString()));
            return;
        }
        final OutgoingConnectionFactory outgoingConnectionFactory = this.getInstance().outgoingConnectionFactory();
        if (this.getCacheConnection() || endpointIArray2.length == 1) {
            outgoingConnectionFactory.create(endpointIArray2, false, this.getEndpointSelection(), new OutgoingConnectionFactory.CreateConnectionCallback(){

                @Override
                public void setConnection(ConnectionI connectionI, boolean bl) {
                    if (RoutableReference.this._routerInfo != null && RoutableReference.this._routerInfo.getAdapter() != null) {
                        connectionI.setAdapter(RoutableReference.this._routerInfo.getAdapter());
                    }
                    getConnectionCallback.setConnection(connectionI, bl);
                }

                @Override
                public void setException(LocalException localException) {
                    getConnectionCallback.setException(localException);
                }
            });
        } else {
            outgoingConnectionFactory.create(new EndpointI[]{endpointIArray2[0]}, true, this.getEndpointSelection(), new OutgoingConnectionFactory.CreateConnectionCallback(){
                private int _i = 0;
                private LocalException _exception = null;

                @Override
                public void setConnection(ConnectionI connectionI, boolean bl) {
                    if (RoutableReference.this._routerInfo != null && RoutableReference.this._routerInfo.getAdapter() != null) {
                        connectionI.setAdapter(RoutableReference.this._routerInfo.getAdapter());
                    }
                    getConnectionCallback.setConnection(connectionI, bl);
                }

                @Override
                public void setException(LocalException localException) {
                    if (this._exception == null) {
                        this._exception = localException;
                    }
                    if (++this._i == endpointIArray2.length) {
                        getConnectionCallback.setException(this._exception);
                        return;
                    }
                    boolean bl = this._i != endpointIArray2.length - 1;
                    EndpointI[] endpointIArray = new EndpointI[]{endpointIArray2[this._i]};
                    outgoingConnectionFactory.create(endpointIArray, bl, RoutableReference.this.getEndpointSelection(), this);
                }
            });
        }
    }

    static class EndpointComparator
    implements Comparator<EndpointI> {
        private boolean _preferSecure;

        EndpointComparator(boolean bl) {
            this._preferSecure = bl;
        }

        @Override
        public int compare(EndpointI endpointI, EndpointI endpointI2) {
            boolean bl = endpointI.secure();
            boolean bl2 = endpointI2.secure();
            if (bl && bl2 || !bl && !bl2) {
                return 0;
            }
            if (!bl && bl2) {
                if (this._preferSecure) {
                    return 1;
                }
                return -1;
            }
            if (this._preferSecure) {
                return -1;
            }
            return 1;
        }
    }
}

