/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CommunicatorDestroyedException;
import Ice.LocalException;
import IceInternal.CancellationHandler;
import IceInternal.Ex;
import IceInternal.Instance;
import IceInternal.OutgoingAsyncBase;
import IceInternal.ProxyOutgoingAsyncBase;
import IceInternal.RetryQueue;
import java.util.concurrent.Future;

class RetryTask
implements Runnable,
CancellationHandler {
    private final Instance _instance;
    private final RetryQueue _queue;
    private final ProxyOutgoingAsyncBase _outAsync;
    private Future<?> _future;

    RetryTask(Instance instance, RetryQueue retryQueue, ProxyOutgoingAsyncBase proxyOutgoingAsyncBase) {
        this._instance = instance;
        this._queue = retryQueue;
        this._outAsync = proxyOutgoingAsyncBase;
    }

    @Override
    public void run() {
        this._outAsync.retry();
        this._queue.remove(this);
    }

    @Override
    public void asyncRequestCanceled(OutgoingAsyncBase outgoingAsyncBase, LocalException localException) {
        if (this._queue.remove(this) && this._future.cancel(false)) {
            if (this._instance.traceLevels().retry >= 1) {
                StringBuilder stringBuilder = new StringBuilder(128);
                stringBuilder.append("operation retry canceled\n");
                stringBuilder.append(Ex.toString(localException));
                this._instance.initializationData().logger.trace(this._instance.traceLevels().retryCat, stringBuilder.toString());
            }
            if (this._outAsync.completed(localException)) {
                this._outAsync.invokeCompletedAsync();
            }
        }
    }

    public boolean destroy() {
        if (this._future.cancel(false)) {
            try {
                this._outAsync.abort(new CommunicatorDestroyedException());
            }
            catch (CommunicatorDestroyedException communicatorDestroyedException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public void setFuture(Future<?> future) {
        this._future = future;
    }
}

