/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CommunicatorDestroyedException;
import IceInternal.Instance;
import IceInternal.ProxyOutgoingAsyncBase;
import IceInternal.RetryTask;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;

public class RetryQueue {
    private Instance _instance;
    private HashSet<RetryTask> _requests = new HashSet();

    RetryQueue(Instance instance) {
        this._instance = instance;
    }

    public synchronized void add(ProxyOutgoingAsyncBase proxyOutgoingAsyncBase, int n) {
        if (this._instance == null) {
            throw new CommunicatorDestroyedException();
        }
        RetryTask retryTask = new RetryTask(this._instance, this, proxyOutgoingAsyncBase);
        proxyOutgoingAsyncBase.cancelable(retryTask);
        retryTask.setFuture(this._instance.timer().schedule(retryTask, (long)n, TimeUnit.MILLISECONDS));
        this._requests.add(retryTask);
    }

    public synchronized void destroy() {
        if (this._instance == null) {
            return;
        }
        HashSet<RetryTask> hashSet = new HashSet<RetryTask>();
        for (RetryTask retryTask : this._requests) {
            if (retryTask.destroy()) continue;
            hashSet.add(retryTask);
        }
        this._requests = hashSet;
        this._instance = null;
        boolean bl = false;
        while (!this._requests.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
    }

    synchronized boolean remove(RetryTask retryTask) {
        boolean bl = this._requests.remove(retryTask);
        if (this._instance == null && this._requests.isEmpty()) {
            this.notify();
        }
        return bl;
    }
}

