/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Communicator;
import Ice.ConnectionI;
import Ice.EncodingVersion;
import Ice.EndpointParseException;
import Ice.EndpointSelectionType;
import Ice.EndpointSelectionTypeParseException;
import Ice.Identity;
import Ice.IllegalIdentityException;
import Ice.LocatorPrx;
import Ice.LocatorPrxHelper;
import Ice.ObjectPrxHelperBase;
import Ice.Properties;
import Ice.ProtocolVersion;
import Ice.ProxyParseException;
import Ice.ProxyUnmarshalException;
import Ice.RouterPrx;
import Ice.RouterPrxHelper;
import Ice.Util;
import Ice.VersionParseException;
import IceInternal.BasicStream;
import IceInternal.DefaultsAndOverrides;
import IceInternal.EndpointI;
import IceInternal.FixedReference;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.PropertyNames;
import IceInternal.Reference;
import IceInternal.RoutableReference;
import IceInternal.RouterInfo;
import IceUtilInternal.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;

public final class ReferenceFactory {
    private static String[] _suffixes = new String[]{"EndpointSelection", "ConnectionCached", "PreferSecure", "LocatorCacheTimeout", "InvocationTimeout", "Locator", "Router", "CollocationOptimized", "Context\\..*"};
    private final Instance _instance;
    private final Communicator _communicator;
    private RouterPrx _defaultRouter;
    private LocatorPrx _defaultLocator;

    public Reference create(Identity identity, String string, Reference reference, EndpointI[] endpointIArray) {
        if (identity.name.length() == 0 && identity.category.length() == 0) {
            return null;
        }
        return this.create(identity, string, reference.getMode(), reference.getSecure(), reference.getProtocol(), reference.getEncoding(), endpointIArray, null, null);
    }

    public Reference create(Identity identity, String string, Reference reference, String string2) {
        if (identity.name.length() == 0 && identity.category.length() == 0) {
            return null;
        }
        return this.create(identity, string, reference.getMode(), reference.getSecure(), reference.getProtocol(), reference.getEncoding(), null, string2, null);
    }

    public Reference create(Identity identity, ConnectionI connectionI) {
        if (identity.name.length() == 0 && identity.category.length() == 0) {
            return null;
        }
        return new FixedReference(this._instance, this._communicator, identity, "", connectionI.endpoint().datagram() ? 3 : 0, connectionI.endpoint().secure(), this._instance.defaultsAndOverrides().defaultEncoding, connectionI);
    }

    public Reference copy(Reference reference) {
        Identity identity = reference.getIdentity();
        if (identity.name.length() == 0 && identity.category.length() == 0) {
            return null;
        }
        return reference.clone();
    }

    public Reference create(String string, String string2) {
        Object object;
        Object object2;
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = 0;
        int n2 = StringUtil.findFirstNotOf(string, " \t\n\r", n);
        if (n2 == -1) {
            ProxyParseException proxyParseException = new ProxyParseException();
            proxyParseException.str = "no non-whitespace characters found in `" + string + "'";
            throw proxyParseException;
        }
        String string3 = null;
        n = StringUtil.checkQuote(string, n2);
        if (n == -1) {
            ProxyParseException proxyParseException = new ProxyParseException();
            proxyParseException.str = "mismatched quotes around identity in `" + string + "'";
            throw proxyParseException;
        }
        if (n == 0) {
            n = StringUtil.findFirstOf(string, " \t\n\r:@", n2);
            if (n == -1) {
                n = string.length();
            }
            string3 = string.substring(n2, n);
        } else {
            string3 = string.substring(++n2, n);
            ++n;
        }
        if (n2 == n) {
            ProxyParseException proxyParseException = new ProxyParseException();
            proxyParseException.str = "no identity in `" + string + "'";
            throw proxyParseException;
        }
        Identity identity = this._instance.stringToIdentity(string3);
        if (identity.name.length() == 0) {
            if (identity.category.length() > 0) {
                IllegalIdentityException illegalIdentityException = new IllegalIdentityException();
                illegalIdentityException.id = identity;
                throw illegalIdentityException;
            }
            if (StringUtil.findFirstNotOf(string, " \t\n\r", n) != -1) {
                ProxyParseException proxyParseException = new ProxyParseException();
                proxyParseException.str = "invalid characters after identity in `" + string + "'";
                throw proxyParseException;
            }
            return null;
        }
        String string4 = "";
        int n3 = 0;
        boolean bl = false;
        EncodingVersion encodingVersion = this._instance.defaultsAndOverrides().defaultEncoding;
        ProtocolVersion protocolVersion = Util.Protocol_1_0;
        String string5 = "";
        block19: while ((n2 = StringUtil.findFirstNotOf(string, " \t\n\r", n)) != -1 && string.charAt(n2) != ':' && string.charAt(n2) != '@') {
            char c;
            n = StringUtil.findFirstOf(string, " \t\n\r:@", n2);
            if (n == -1) {
                n = string.length();
            }
            if (n2 == n) break;
            object2 = string.substring(n2, n);
            if (((String)object2).length() != 2 || ((String)object2).charAt(0) != '-') {
                object = new ProxyParseException();
                ((ProxyParseException)object).str = "expected a proxy option but found `" + (String)object2 + "' in `" + string + "'";
                throw object;
            }
            object = null;
            int n4 = StringUtil.findFirstNotOf(string, " \t\n\r", n);
            if (n4 != -1 && (c = string.charAt(n4)) != '@' && c != ':' && c != '-') {
                n2 = n4;
                n = StringUtil.checkQuote(string, n2);
                if (n == -1) {
                    ProxyParseException proxyParseException = new ProxyParseException();
                    proxyParseException.str = "mismatched quotes around value for " + (String)object2 + " option in `" + string + "'";
                    throw proxyParseException;
                }
                if (n == 0) {
                    n = StringUtil.findFirstOf(string, " \t\n\r:@", n2);
                    if (n == -1) {
                        n = string.length();
                    }
                    object = string.substring(n2, n);
                } else {
                    object = string.substring(++n2, n);
                    ++n;
                }
            }
            switch (((String)object2).charAt(1)) {
                case 'f': {
                    if (object == null) {
                        ProxyParseException proxyParseException = new ProxyParseException();
                        proxyParseException.str = "no argument provided for -f option in `" + string + "'";
                        throw proxyParseException;
                    }
                    try {
                        string4 = StringUtil.unescapeString((String)object, 0, ((String)object).length());
                        continue block19;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        ProxyParseException proxyParseException = new ProxyParseException();
                        proxyParseException.str = "invalid facet in `" + string + "': " + illegalArgumentException.getMessage();
                        throw proxyParseException;
                    }
                }
                case 't': {
                    if (object != null) {
                        ProxyParseException proxyParseException = new ProxyParseException();
                        proxyParseException.str = "unexpected argument `" + (String)object + "' provided for -t option in `" + string + "'";
                        throw proxyParseException;
                    }
                    n3 = 0;
                    continue block19;
                }
                case 'o': {
                    if (object != null) {
                        ProxyParseException proxyParseException = new ProxyParseException();
                        proxyParseException.str = "unexpected argument `" + (String)object + "' provided for -o option in `" + string + "'";
                        throw proxyParseException;
                    }
                    n3 = 1;
                    continue block19;
                }
                case 'O': {
                    if (object != null) {
                        ProxyParseException proxyParseException = new ProxyParseException();
                        proxyParseException.str = "unexpected argument `" + (String)object + "' provided for -O option in `" + string + "'";
                        throw proxyParseException;
                    }
                    n3 = 2;
                    continue block19;
                }
                case 'd': {
                    if (object != null) {
                        ProxyParseException proxyParseException = new ProxyParseException();
                        proxyParseException.str = "unexpected argument `" + (String)object + "' provided for -d option in `" + string + "'";
                        throw proxyParseException;
                    }
                    n3 = 3;
                    continue block19;
                }
                case 'D': {
                    if (object != null) {
                        ProxyParseException proxyParseException = new ProxyParseException();
                        proxyParseException.str = "unexpected argument `" + (String)object + "' provided for -D option in `" + string + "'";
                        throw proxyParseException;
                    }
                    n3 = 4;
                    continue block19;
                }
                case 's': {
                    if (object != null) {
                        ProxyParseException proxyParseException = new ProxyParseException();
                        proxyParseException.str = "unexpected argument `" + (String)object + "' provided for -s option in `" + string + "'";
                        throw proxyParseException;
                    }
                    bl = true;
                    continue block19;
                }
                case 'e': {
                    if (object == null) {
                        throw new ProxyParseException("no argument provided for -e option in `" + string + "'");
                    }
                    try {
                        encodingVersion = Util.stringToEncodingVersion((String)object);
                        continue block19;
                    }
                    catch (VersionParseException versionParseException) {
                        throw new ProxyParseException("invalid encoding version `" + (String)object + "' in `" + string + "':\n" + versionParseException.str);
                    }
                }
                case 'p': {
                    if (object == null) {
                        throw new ProxyParseException("no argument provided for -p option in `" + string + "'");
                    }
                    try {
                        protocolVersion = Util.stringToProtocolVersion((String)object);
                        continue block19;
                    }
                    catch (VersionParseException versionParseException) {
                        throw new ProxyParseException("invalid protocol version `" + (String)object + "' in `" + string + "':\n" + versionParseException.str);
                    }
                }
            }
            ProxyParseException proxyParseException = new ProxyParseException();
            proxyParseException.str = "unknown option `" + (String)object2 + "' in `" + string + "'";
            throw proxyParseException;
        }
        if (n2 == -1) {
            return this.create(identity, string4, n3, bl, protocolVersion, encodingVersion, null, null, string2);
        }
        object2 = new ArrayList();
        if (string.charAt(n2) == ':') {
            object = new ArrayList();
            n = n2;
            while (n < string.length() && string.charAt(n) == ':') {
                n = n2 = n + 1;
                while (true) {
                    if ((n = string.indexOf(58, n)) == -1) {
                        n = string.length();
                        break;
                    }
                    boolean bl2 = false;
                    int n5 = n2;
                    while ((n5 = string.indexOf(34, n5)) != -1 && n >= n5) {
                        ++n5;
                        if ((n5 = string.indexOf(34, n5)) == -1) break;
                        if (n < n5) {
                            bl2 = true;
                            break;
                        }
                        ++n5;
                    }
                    if (!bl2) break;
                    ++n;
                }
                String string6 = string.substring(n2, n);
                EndpointI endpointI = this._instance.endpointFactoryManager().create(string6, false);
                if (endpointI != null) {
                    ((ArrayList)object2).add(endpointI);
                    continue;
                }
                ((ArrayList)object).add(string6);
            }
            if (((ArrayList)object2).size() == 0) {
                assert (!((ArrayList)object).isEmpty());
                EndpointParseException endpointParseException = new EndpointParseException();
                endpointParseException.str = "invalid endpoint `" + (String)((ArrayList)object).get(0) + "' in `" + string + "'";
                throw endpointParseException;
            }
            if (((ArrayList)object).size() != 0 && this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Endpoints", 1) > 0) {
                StringBuffer stringBuffer = new StringBuffer("Proxy contains unknown endpoints:");
                Iterator iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    String string7 = (String)iterator.next();
                    stringBuffer.append(" `");
                    stringBuffer.append(string7);
                    stringBuffer.append("'");
                }
                this._instance.initializationData().logger.warning(stringBuffer.toString());
            }
            EndpointI[] endpointIArray = new EndpointI[((ArrayList)object2).size()];
            ((ArrayList)object2).toArray(endpointIArray);
            return this.create(identity, string4, n3, bl, protocolVersion, encodingVersion, endpointIArray, null, string2);
        }
        if (string.charAt(n2) == '@') {
            if ((n2 = StringUtil.findFirstNotOf(string, " \t\n\r", n2 + 1)) == -1) {
                object = new ProxyParseException();
                ((ProxyParseException)object).str = "missing adapter id in `" + string + "'";
                throw object;
            }
            object = null;
            n = StringUtil.checkQuote(string, n2);
            if (n == -1) {
                ProxyParseException proxyParseException = new ProxyParseException();
                proxyParseException.str = "mismatched quotes around adapter id in `" + string + "'";
                throw proxyParseException;
            }
            if (n == 0) {
                n = StringUtil.findFirstOf(string, " \t\n\r", n2);
                if (n == -1) {
                    n = string.length();
                }
                object = string.substring(n2, n);
            } else {
                object = string.substring(++n2, n);
                ++n;
            }
            if (n != string.length() && StringUtil.findFirstNotOf(string, " \t\n\r", n) != -1) {
                ProxyParseException proxyParseException = new ProxyParseException();
                proxyParseException.str = "invalid trailing characters after `" + string.substring(0, n + 1) + "' in `" + string + "'";
                throw proxyParseException;
            }
            try {
                string5 = StringUtil.unescapeString((String)object, 0, ((String)object).length());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ProxyParseException proxyParseException = new ProxyParseException();
                proxyParseException.str = "invalid adapter id in `" + string + "': " + illegalArgumentException.getMessage();
                throw proxyParseException;
            }
            if (string5.length() == 0) {
                ProxyParseException proxyParseException = new ProxyParseException();
                proxyParseException.str = "empty adapter id in `" + string + "'";
                throw proxyParseException;
            }
            return this.create(identity, string4, n3, bl, protocolVersion, encodingVersion, null, string5, string2);
        }
        object = new ProxyParseException();
        ((ProxyParseException)object).str = "malformed proxy `" + string + "'";
        throw object;
    }

    public Reference create(Identity identity, BasicStream basicStream) {
        EncodingVersion encodingVersion;
        ProtocolVersion protocolVersion;
        String string;
        if (identity.name.length() == 0 && identity.category.length() == 0) {
            return null;
        }
        String[] stringArray = basicStream.readStringSeq();
        if (stringArray.length > 0) {
            if (stringArray.length > 1) {
                throw new ProxyUnmarshalException();
            }
            string = stringArray[0];
        } else {
            string = "";
        }
        byte by = basicStream.readByte();
        if (by < 0 || by > 4) {
            throw new ProxyUnmarshalException();
        }
        boolean bl = basicStream.readBool();
        if (!basicStream.getReadEncoding().equals(Util.Encoding_1_0)) {
            protocolVersion = new ProtocolVersion();
            protocolVersion.__read(basicStream);
            encodingVersion = new EncodingVersion();
            encodingVersion.__read(basicStream);
        } else {
            protocolVersion = Util.Protocol_1_0;
            encodingVersion = Util.Encoding_1_0;
        }
        EndpointI[] endpointIArray = null;
        String string2 = null;
        int n = basicStream.readSize();
        if (n > 0) {
            endpointIArray = new EndpointI[n];
            for (int i = 0; i < n; ++i) {
                endpointIArray[i] = this._instance.endpointFactoryManager().read(basicStream);
            }
        } else {
            string2 = basicStream.readString();
        }
        return this.create(identity, string, by, bl, protocolVersion, encodingVersion, endpointIArray, string2, null);
    }

    public ReferenceFactory setDefaultRouter(RouterPrx routerPrx) {
        if (this._defaultRouter == null ? routerPrx == null : this._defaultRouter.equals(routerPrx)) {
            return this;
        }
        ReferenceFactory referenceFactory = new ReferenceFactory(this._instance, this._communicator);
        referenceFactory._defaultLocator = this._defaultLocator;
        referenceFactory._defaultRouter = routerPrx;
        return referenceFactory;
    }

    public RouterPrx getDefaultRouter() {
        return this._defaultRouter;
    }

    public ReferenceFactory setDefaultLocator(LocatorPrx locatorPrx) {
        if (this._defaultLocator == null ? locatorPrx == null : this._defaultLocator.equals(locatorPrx)) {
            return this;
        }
        ReferenceFactory referenceFactory = new ReferenceFactory(this._instance, this._communicator);
        referenceFactory._defaultRouter = this._defaultRouter;
        referenceFactory._defaultLocator = locatorPrx;
        return referenceFactory;
    }

    public LocatorPrx getDefaultLocator() {
        return this._defaultLocator;
    }

    ReferenceFactory(Instance instance, Communicator communicator) {
        this._instance = instance;
        this._communicator = communicator;
    }

    private void checkForUnknownProperties(String string) {
        int n = 0;
        while (PropertyNames.clPropNames[n] != null) {
            if (string.startsWith(PropertyNames.clPropNames[n] + ".")) {
                return;
            }
            ++n;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Map<String, String> map = this._instance.initializationData().properties.getPropertiesForPrefix(string + ".");
        for (Map.Entry<String, String> object : map.entrySet()) {
            String string2 = object.getKey();
            boolean bl = false;
            for (String string3 : _suffixes) {
                String string4 = Pattern.quote(string + ".") + string3;
                if (!Pattern.compile(string4).matcher(string2).matches()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(string2);
        }
        if (arrayList.size() != 0) {
            StringBuffer stringBuffer = new StringBuffer("found unknown properties for proxy '");
            stringBuffer.append(string);
            stringBuffer.append("':");
            for (String string2 : arrayList) {
                stringBuffer.append("\n    ");
                stringBuffer.append(string2);
            }
            this._instance.initializationData().logger.warning(stringBuffer.toString());
        }
    }

    private Reference create(Identity identity, String string, int n, boolean bl, ProtocolVersion protocolVersion, EncodingVersion encodingVersion, EndpointI[] endpointIArray, String string2, String string3) {
        DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
        LocatorInfo locatorInfo = null;
        if (this._defaultLocator != null) {
            locatorInfo = !((ObjectPrxHelperBase)((Object)this._defaultLocator)).__reference().getEncoding().equals(encodingVersion) ? this._instance.locatorManager().get((LocatorPrx)this._defaultLocator.ice_encodingVersion(encodingVersion)) : this._instance.locatorManager().get(this._defaultLocator);
        }
        RouterInfo routerInfo = this._instance.routerManager().get(this._defaultRouter);
        boolean bl2 = defaultsAndOverrides.defaultCollocationOptimization;
        boolean bl3 = true;
        boolean bl4 = defaultsAndOverrides.defaultPreferSecure;
        EndpointSelectionType endpointSelectionType = defaultsAndOverrides.defaultEndpointSelection;
        int n2 = defaultsAndOverrides.defaultLocatorCacheTimeout;
        int n3 = defaultsAndOverrides.defaultInvocationTimeout;
        HashMap hashMap = null;
        if (string3 != null && string3.length() > 0) {
            Object object;
            String string4;
            RouterPrx routerPrx;
            String string5;
            LocatorPrx locatorPrx;
            Properties properties = this._instance.initializationData().properties;
            if (properties.getPropertyAsIntWithDefault("Ice.Warn.UnknownProperties", 1) > 0) {
                this.checkForUnknownProperties(string3);
            }
            if ((locatorPrx = LocatorPrxHelper.uncheckedCast(this._communicator.propertyToProxy(string5 = string3 + ".Locator"))) != null) {
                locatorInfo = !((ObjectPrxHelperBase)((Object)locatorPrx)).__reference().getEncoding().equals(encodingVersion) ? this._instance.locatorManager().get((LocatorPrx)locatorPrx.ice_encodingVersion(encodingVersion)) : this._instance.locatorManager().get(locatorPrx);
            }
            if ((routerPrx = RouterPrxHelper.uncheckedCast(this._communicator.propertyToProxy(string5 = string3 + ".Router"))) != null) {
                if (string3.endsWith(".Router")) {
                    string4 = "`" + string5 + "=" + properties.getProperty(string5) + "': cannot set a router on a router; setting ignored";
                    this._instance.initializationData().logger.warning(string4);
                } else {
                    routerInfo = this._instance.routerManager().get(routerPrx);
                }
            }
            string5 = string3 + ".CollocationOptimized";
            bl2 = properties.getPropertyAsIntWithDefault(string5, bl2 ? 1 : 0) > 0;
            string5 = string3 + ".ConnectionCached";
            bl3 = properties.getPropertyAsIntWithDefault(string5, bl3 ? 1 : 0) > 0;
            string5 = string3 + ".PreferSecure";
            bl4 = properties.getPropertyAsIntWithDefault(string5, bl4 ? 1 : 0) > 0;
            string5 = string3 + ".EndpointSelection";
            if (properties.getProperty(string5).length() > 0) {
                string4 = properties.getProperty(string5);
                if (string4.equals("Random")) {
                    endpointSelectionType = EndpointSelectionType.Random;
                } else if (string4.equals("Ordered")) {
                    endpointSelectionType = EndpointSelectionType.Ordered;
                } else {
                    throw new EndpointSelectionTypeParseException("illegal value `" + string4 + "'; expected `Random' or `Ordered'");
                }
            }
            if (!(string4 = properties.getProperty(string5 = string3 + ".LocatorCacheTimeout")).isEmpty() && (n2 = properties.getPropertyAsIntWithDefault(string5, n2)) < -1) {
                n2 = -1;
                object = new StringBuffer("invalid value for ");
                ((StringBuffer)object).append(string5);
                ((StringBuffer)object).append(" '");
                ((StringBuffer)object).append(properties.getProperty(string5));
                ((StringBuffer)object).append("': defaulting to -1");
                this._instance.initializationData().logger.warning(((StringBuffer)object).toString());
            }
            if (!(string4 = properties.getProperty(string5 = string3 + ".InvocationTimeout")).isEmpty() && (n3 = properties.getPropertyAsIntWithDefault(string5, n2)) < 1 && n3 != -1) {
                n3 = -1;
                object = new StringBuffer("invalid value for ");
                ((StringBuffer)object).append(string5);
                ((StringBuffer)object).append(" '");
                ((StringBuffer)object).append(properties.getProperty(string5));
                ((StringBuffer)object).append("': defaulting to -1");
                this._instance.initializationData().logger.warning(((StringBuffer)object).toString());
            }
            if (!(object = properties.getPropertiesForPrefix(string5 = string3 + ".Context.")).isEmpty()) {
                hashMap = new HashMap();
                for (Map.Entry entry : object.entrySet()) {
                    hashMap.put(((String)entry.getKey()).substring(string5.length()), entry.getValue());
                }
            }
        }
        return new RoutableReference(this._instance, this._communicator, identity, string, n, bl, protocolVersion, encodingVersion, endpointIArray, string2, locatorInfo, routerInfo, bl2, bl3, bl4, endpointSelectionType, n2, n3, hashMap);
    }
}

