/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Communicator;
import Ice.ConnectionI;
import Ice.EncodingVersion;
import Ice.EndpointSelectionType;
import Ice.Identity;
import Ice.LocalException;
import Ice.LocatorPrx;
import Ice.ObjectPrxHelperBase;
import Ice.ProtocolVersion;
import Ice.RouterPrx;
import Ice.Util;
import IceInternal.BasicStream;
import IceInternal.BatchRequestQueue;
import IceInternal.EndpointI;
import IceInternal.HashUtil;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.RequestHandler;
import IceInternal.RouterInfo;
import IceUtilInternal.StringUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class Reference
implements Cloneable {
    public static final int ModeTwoway = 0;
    public static final int ModeOneway = 1;
    public static final int ModeBatchOneway = 2;
    public static final int ModeDatagram = 3;
    public static final int ModeBatchDatagram = 4;
    public static final int ModeLast = 4;
    protected int _hashValue;
    protected boolean _hashInitialized;
    private static Map<String, String> _emptyContext = new HashMap<String, String>();
    private final Instance _instance;
    private final Communicator _communicator;
    private int _mode;
    private boolean _secure;
    private Identity _identity;
    private Map<String, String> _context;
    private String _facet;
    private ProtocolVersion _protocol;
    private EncodingVersion _encoding;
    private int _invocationTimeout;
    protected boolean _overrideCompress;
    protected boolean _compress;

    public final int getMode() {
        return this._mode;
    }

    public final boolean getSecure() {
        return this._secure;
    }

    public final ProtocolVersion getProtocol() {
        return this._protocol;
    }

    public final EncodingVersion getEncoding() {
        return this._encoding;
    }

    public final Identity getIdentity() {
        return this._identity;
    }

    public final String getFacet() {
        return this._facet;
    }

    public final Instance getInstance() {
        return this._instance;
    }

    public final Map<String, String> getContext() {
        return this._context;
    }

    public int getInvocationTimeout() {
        return this._invocationTimeout;
    }

    public final Communicator getCommunicator() {
        return this._communicator;
    }

    public abstract EndpointI[] getEndpoints();

    public abstract String getAdapterId();

    public abstract RouterInfo getRouterInfo();

    public abstract LocatorInfo getLocatorInfo();

    public abstract boolean getCollocationOptimized();

    public abstract boolean getCacheConnection();

    public abstract boolean getPreferSecure();

    public abstract EndpointSelectionType getEndpointSelection();

    public abstract int getLocatorCacheTimeout();

    public abstract String getConnectionId();

    public final Reference changeContext(Map<String, String> map) {
        if (map == null) {
            map = _emptyContext;
        }
        Reference reference = this._instance.referenceFactory().copy(this);
        reference._context = map.isEmpty() ? _emptyContext : new HashMap<String, String>(map);
        return reference;
    }

    public final Reference changeMode(int n) {
        if (n == this._mode) {
            return this;
        }
        Reference reference = this._instance.referenceFactory().copy(this);
        reference._mode = n;
        return reference;
    }

    public Reference changeSecure(boolean bl) {
        if (bl == this._secure) {
            return this;
        }
        Reference reference = this._instance.referenceFactory().copy(this);
        reference._secure = bl;
        return reference;
    }

    public final Reference changeIdentity(Identity identity) {
        if (identity.equals(this._identity)) {
            return this;
        }
        Reference reference = this._instance.referenceFactory().copy(this);
        reference._identity = identity.clone();
        return reference;
    }

    public final Reference changeFacet(String string) {
        if (string.equals(this._facet)) {
            return this;
        }
        Reference reference = this._instance.referenceFactory().copy(this);
        reference._facet = string;
        return reference;
    }

    public final Reference changeInvocationTimeout(int n) {
        if (n == this._invocationTimeout) {
            return this;
        }
        Reference reference = this._instance.referenceFactory().copy(this);
        reference._invocationTimeout = n;
        return reference;
    }

    public Reference changeEncoding(EncodingVersion encodingVersion) {
        if (encodingVersion.equals(this._encoding)) {
            return this;
        }
        Reference reference = this._instance.referenceFactory().copy(this);
        reference._encoding = encodingVersion;
        return reference;
    }

    public Reference changeCompress(boolean bl) {
        if (this._overrideCompress && this._compress == bl) {
            return this;
        }
        Reference reference = this._instance.referenceFactory().copy(this);
        reference._compress = bl;
        reference._overrideCompress = true;
        return reference;
    }

    public abstract Reference changeAdapterId(String var1);

    public abstract Reference changeEndpoints(EndpointI[] var1);

    public abstract Reference changeLocator(LocatorPrx var1);

    public abstract Reference changeRouter(RouterPrx var1);

    public abstract Reference changeCollocationOptimized(boolean var1);

    public abstract Reference changeCacheConnection(boolean var1);

    public abstract Reference changePreferSecure(boolean var1);

    public abstract Reference changeEndpointSelection(EndpointSelectionType var1);

    public abstract Reference changeLocatorCacheTimeout(int var1);

    public abstract Reference changeTimeout(int var1);

    public abstract Reference changeConnectionId(String var1);

    public synchronized int hashCode() {
        if (this._hashInitialized) {
            return this._hashValue;
        }
        int n = 5381;
        n = HashUtil.hashAdd(n, this._mode);
        n = HashUtil.hashAdd(n, this._secure);
        n = HashUtil.hashAdd(n, this._identity);
        n = HashUtil.hashAdd(n, this._context);
        n = HashUtil.hashAdd(n, this._facet);
        n = HashUtil.hashAdd(n, this._overrideCompress);
        if (this._overrideCompress) {
            n = HashUtil.hashAdd(n, this._compress);
        }
        n = HashUtil.hashAdd(n, this._protocol);
        n = HashUtil.hashAdd(n, this._encoding);
        this._hashValue = n = HashUtil.hashAdd(n, this._invocationTimeout);
        this._hashInitialized = true;
        return this._hashValue;
    }

    public abstract boolean isIndirect();

    public abstract boolean isWellKnown();

    public void streamWrite(BasicStream basicStream) {
        if (this._facet.length() == 0) {
            basicStream.writeStringSeq(null);
        } else {
            String[] stringArray = new String[]{this._facet};
            basicStream.writeStringSeq(stringArray);
        }
        basicStream.writeByte((byte)this._mode);
        basicStream.writeBool(this._secure);
        if (!basicStream.getWriteEncoding().equals(Util.Encoding_1_0)) {
            this._protocol.__write(basicStream);
            this._encoding.__write(basicStream);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        String string = this._instance.identityToString(this._identity);
        if (StringUtil.findFirstOf(string, " :@") != -1) {
            stringBuilder.append('\"');
            stringBuilder.append(string);
            stringBuilder.append('\"');
        } else {
            stringBuilder.append(string);
        }
        if (this._facet.length() > 0) {
            stringBuilder.append(" -f ");
            String string2 = StringUtil.escapeString(this._facet, "");
            if (StringUtil.findFirstOf(string2, " :@") != -1) {
                stringBuilder.append('\"');
                stringBuilder.append(string2);
                stringBuilder.append('\"');
            } else {
                stringBuilder.append(string2);
            }
        }
        switch (this._mode) {
            case 0: {
                stringBuilder.append(" -t");
                break;
            }
            case 1: {
                stringBuilder.append(" -o");
                break;
            }
            case 2: {
                stringBuilder.append(" -O");
                break;
            }
            case 3: {
                stringBuilder.append(" -d");
                break;
            }
            case 4: {
                stringBuilder.append(" -D");
            }
        }
        if (this._secure) {
            stringBuilder.append(" -s");
        }
        if (!this._protocol.equals(Util.Protocol_1_0)) {
            stringBuilder.append(" -p ");
            stringBuilder.append(Util.protocolVersionToString(this._protocol));
        }
        stringBuilder.append(" -e ");
        stringBuilder.append(Util.encodingVersionToString(this._encoding));
        return stringBuilder.toString();
    }

    public abstract Map<String, String> toProperty(String var1);

    public abstract RequestHandler getRequestHandler(ObjectPrxHelperBase var1);

    public abstract BatchRequestQueue getBatchRequestQueue();

    public boolean equals(Object object) {
        Reference reference = (Reference)object;
        if (this._mode != reference._mode) {
            return false;
        }
        if (this._secure != reference._secure) {
            return false;
        }
        if (!this._identity.equals(reference._identity)) {
            return false;
        }
        if (!this._context.equals(reference._context)) {
            return false;
        }
        if (!this._facet.equals(reference._facet)) {
            return false;
        }
        if (this._overrideCompress != reference._overrideCompress) {
            return false;
        }
        if (this._overrideCompress && this._compress != reference._compress) {
            return false;
        }
        if (!this._protocol.equals(reference._protocol)) {
            return false;
        }
        if (!this._encoding.equals(reference._encoding)) {
            return false;
        }
        return this._invocationTimeout == reference._invocationTimeout;
    }

    public Reference clone() {
        Reference reference;
        block2: {
            reference = null;
            try {
                reference = (Reference)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return reference;
    }

    protected Reference(Instance instance, Communicator communicator, Identity identity, String string, int n, boolean bl, ProtocolVersion protocolVersion, EncodingVersion encodingVersion, int n2, Map<String, String> map) {
        assert (identity.name != null);
        assert (identity.category != null);
        assert (string != null);
        this._instance = instance;
        this._communicator = communicator;
        this._mode = n;
        this._secure = bl;
        this._identity = identity;
        this._context = map != null ? new HashMap<String, String>(map) : _emptyContext;
        this._facet = string;
        this._protocol = protocolVersion;
        this._encoding = encodingVersion;
        this._invocationTimeout = n2;
        this._hashInitialized = false;
        this._overrideCompress = false;
        this._compress = false;
    }

    public static interface GetConnectionCallback {
        public void setConnection(ConnectionI var1, boolean var2);

        public void setException(LocalException var1);
    }
}

