/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectionI;
import Ice.Exception;
import Ice.LocalException;
import IceInternal.Instance;
import IceInternal.OutgoingAsyncBase;
import IceInternal.ProxyOutgoingAsyncBase;
import IceInternal.QueueExecutorService;
import IceInternal.Reference;
import IceInternal.RequestHandler;
import IceInternal.RetryException;
import java.util.concurrent.Callable;

public class QueueRequestHandler
implements RequestHandler {
    private final RequestHandler _delegate;
    private final QueueExecutorService _executor;

    public QueueRequestHandler(Instance instance, RequestHandler requestHandler) {
        this._executor = instance.getQueueExecutor();
        assert (requestHandler != null);
        this._delegate = requestHandler;
    }

    @Override
    public RequestHandler update(RequestHandler requestHandler, RequestHandler requestHandler2) {
        try {
            if (requestHandler == this || requestHandler == this._delegate) {
                return requestHandler2;
            }
            if (requestHandler.getConnection() == this._delegate.getConnection()) {
                return requestHandler2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    @Override
    public int sendAsyncRequest(final ProxyOutgoingAsyncBase proxyOutgoingAsyncBase) throws RetryException {
        return this._executor.execute(new Callable<Integer>(){

            @Override
            public Integer call() throws RetryException {
                return QueueRequestHandler.this._delegate.sendAsyncRequest(proxyOutgoingAsyncBase);
            }
        });
    }

    @Override
    public void asyncRequestCanceled(final OutgoingAsyncBase outgoingAsyncBase, final LocalException localException) {
        this._executor.executeNoThrow(new Callable<Void>(){

            @Override
            public Void call() {
                QueueRequestHandler.this._delegate.asyncRequestCanceled(outgoingAsyncBase, localException);
                return null;
            }
        });
    }

    @Override
    public Reference getReference() {
        return this._delegate.getReference();
    }

    @Override
    public ConnectionI getConnection() {
        return this._delegate.getConnection();
    }
}

