/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CommunicatorDestroyedException;
import IceInternal.RetryException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;

public final class QueueExecutorService {
    final ExecutorService _executor;
    final Thread _thread;

    QueueExecutorService(ExecutorService executorService) {
        this._executor = executorService;
        this._thread = this.executeNoThrow(new Callable<Thread>(){

            @Override
            public Thread call() {
                return Thread.currentThread();
            }
        });
    }

    public <T> T executeNoThrow(Callable<T> callable) {
        try {
            return this.execute(callable);
        }
        catch (RetryException retryException) {
            assert (false);
            return null;
        }
    }

    public <T> T execute(Callable<T> callable) throws RetryException {
        if (this._thread == Thread.currentThread()) {
            try {
                return callable.call();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                assert (exception instanceof RetryException);
                throw (RetryException)exception;
            }
        }
        boolean bl = false;
        try {
            Future<T> future = this._executor.submit(callable);
            while (true) {
                T t;
                try {
                    T t2;
                    t = t2 = future.get();
                }
                catch (InterruptedException interruptedException) {
                    try {
                        bl = true;
                        continue;
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        throw new CommunicatorDestroyedException();
                    }
                    catch (ExecutionException executionException) {
                        try {
                            throw executionException.getCause();
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Throwable throwable) {
                            assert (throwable instanceof RetryException);
                            throw (RetryException)throwable;
                        }
                    }
                }
                return t;
            }
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

