/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CloseConnectionException;
import Ice.CommunicatorDestroyedException;
import Ice.Holder;
import Ice.Identity;
import Ice.InvocationCanceledException;
import Ice.InvocationTimeoutException;
import Ice.LocalException;
import Ice.Logger;
import Ice.MarshalException;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectNotExistException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.OperationInterruptedException;
import Ice.RequestFailedException;
import IceInternal.BasicStream;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.Reference;
import IceInternal.TraceLevels;
import java.util.HashMap;
import java.util.Map;

public final class ProxyFactory {
    private Instance _instance;
    private int[] _retryIntervals;

    public ObjectPrx stringToProxy(String string) {
        Reference reference = this._instance.referenceFactory().create(string, null);
        return this.referenceToProxy(reference);
    }

    public String proxyToString(ObjectPrx objectPrx) {
        if (objectPrx != null) {
            ObjectPrxHelperBase objectPrxHelperBase = (ObjectPrxHelperBase)objectPrx;
            return objectPrxHelperBase.__reference().toString();
        }
        return "";
    }

    public ObjectPrx propertyToProxy(String string) {
        String string2 = this._instance.initializationData().properties.getProperty(string);
        Reference reference = this._instance.referenceFactory().create(string2, string);
        return this.referenceToProxy(reference);
    }

    public Map<String, String> proxyToProperty(ObjectPrx objectPrx, String string) {
        if (objectPrx != null) {
            ObjectPrxHelperBase objectPrxHelperBase = (ObjectPrxHelperBase)objectPrx;
            return objectPrxHelperBase.__reference().toProperty(string);
        }
        return new HashMap<String, String>();
    }

    public ObjectPrx streamToProxy(BasicStream basicStream) {
        Identity identity = new Identity();
        identity.__read(basicStream);
        Reference reference = this._instance.referenceFactory().create(identity, basicStream);
        return this.referenceToProxy(reference);
    }

    public ObjectPrx referenceToProxy(Reference reference) {
        if (reference != null) {
            ObjectPrxHelperBase objectPrxHelperBase = new ObjectPrxHelperBase();
            objectPrxHelperBase.__setup(reference);
            return objectPrxHelperBase;
        }
        return null;
    }

    public void proxyToStream(ObjectPrx objectPrx, BasicStream basicStream) {
        if (objectPrx != null) {
            ObjectPrxHelperBase objectPrxHelperBase = (ObjectPrxHelperBase)objectPrx;
            Reference reference = objectPrxHelperBase.__reference();
            reference.getIdentity().__write(basicStream);
            reference.streamWrite(basicStream);
        } else {
            Identity identity = new Identity();
            identity.name = "";
            identity.category = "";
            identity.__write(basicStream);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int checkRetryAfterException(LocalException localException, Reference reference, Holder<Integer> holder, int n) {
        int n2;
        Object object;
        TraceLevels traceLevels = this._instance.traceLevels();
        Logger logger = this._instance.initializationData().logger;
        if (reference.getMode() == 2 || reference.getMode() == 4) {
            throw localException;
        }
        if (localException instanceof ObjectNotExistException) {
            ObjectNotExistException objectNotExistException = (ObjectNotExistException)localException;
            if (reference.getRouterInfo() != null && objectNotExistException.operation.equals("ice_add_proxy")) {
                reference.getRouterInfo().clearCache(reference);
                if (traceLevels.retry >= 1) {
                    String string = "retrying operation call to add proxy to router\n" + localException.toString();
                    logger.trace(traceLevels.retryCat, string);
                }
                if (holder == null) return n;
                holder.value = 0;
                return n;
            }
            if (!reference.isIndirect()) throw localException;
            if (reference.isWellKnown() && (object = reference.getLocatorInfo()) != null) {
                ((LocatorInfo)object).clearCache(reference);
            }
        } else if (localException instanceof RequestFailedException) {
            throw localException;
        }
        if (localException instanceof MarshalException) {
            throw localException;
        }
        if (localException instanceof CommunicatorDestroyedException || localException instanceof ObjectAdapterDeactivatedException) {
            throw localException;
        }
        if (localException instanceof InvocationTimeoutException || localException instanceof InvocationCanceledException) {
            throw localException;
        }
        if (localException instanceof OperationInterruptedException) {
            throw localException;
        }
        assert (++n > 0);
        if (n == this._retryIntervals.length + 1 && localException instanceof CloseConnectionException) {
            n2 = 0;
        } else {
            if (n > this._retryIntervals.length) {
                if (traceLevels.retry < 1) throw localException;
                object = "cannot retry operation call because retry limit has been exceeded\n" + localException.toString();
                logger.trace(traceLevels.retryCat, (String)object);
                throw localException;
            }
            n2 = this._retryIntervals[n - 1];
        }
        if (traceLevels.retry >= 1) {
            object = "retrying operation call";
            if (n2 > 0) {
                object = (String)object + " in " + n2 + "ms";
            }
            object = (String)object + " because of exception\n" + localException;
            logger.trace(traceLevels.retryCat, (String)object);
        }
        holder.value = n2;
        return n;
    }

    ProxyFactory(Instance instance) {
        this._instance = instance;
        String[] stringArray = this._instance.initializationData().properties.getPropertyAsList("Ice.RetryIntervals");
        if (stringArray.length > 0) {
            this._retryIntervals = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                try {
                    n = Integer.parseInt(stringArray[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
                if (i == 0 && n == -1) {
                    this._retryIntervals = new int[0];
                    break;
                }
                this._retryIntervals[i] = n > 0 ? n : 0;
            }
        } else {
            this._retryIntervals = new int[1];
            this._retryIntervals[0] = 0;
        }
    }
}

