/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.EncodingVersion;
import Ice.ProtocolVersion;
import Ice.UnsupportedEncodingException;
import Ice.UnsupportedProtocolException;

public final class Protocol {
    public static final int headerSize = 14;
    public static final byte[] magic = new byte[]{73, 99, 101, 80};
    public static final byte protocolMajor = 1;
    public static final byte protocolMinor = 0;
    public static final byte protocolEncodingMajor = 1;
    public static final byte protocolEncodingMinor = 0;
    public static final byte encodingMajor = 1;
    public static final byte encodingMinor = 1;
    public static final byte requestMsg = 0;
    public static final byte requestBatchMsg = 1;
    public static final byte replyMsg = 2;
    public static final byte validateConnectionMsg = 3;
    public static final byte closeConnectionMsg = 4;
    public static final byte[] requestHdr = new byte[]{magic[0], magic[1], magic[2], magic[3], 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final byte[] requestBatchHdr = new byte[]{magic[0], magic[1], magic[2], magic[3], 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final byte[] replyHdr = new byte[]{magic[0], magic[1], magic[2], magic[3], 1, 0, 1, 0, 2, 0, 0, 0, 0, 0};
    public static final ProtocolVersion currentProtocol = new ProtocolVersion(1, 0);
    public static final EncodingVersion currentProtocolEncoding = new EncodingVersion(1, 0);
    public static final EncodingVersion currentEncoding = new EncodingVersion(1, 1);

    public static void checkSupportedProtocol(ProtocolVersion protocolVersion) {
        if (protocolVersion.major != Protocol.currentProtocol.major || protocolVersion.minor > Protocol.currentProtocol.minor) {
            throw new UnsupportedProtocolException("", protocolVersion, currentProtocol);
        }
    }

    public static void checkSupportedProtocolEncoding(EncodingVersion encodingVersion) {
        if (encodingVersion.major != Protocol.currentProtocolEncoding.major || encodingVersion.minor > Protocol.currentProtocolEncoding.minor) {
            throw new UnsupportedEncodingException("", encodingVersion, currentProtocolEncoding);
        }
    }

    public static void checkSupportedEncoding(EncodingVersion encodingVersion) {
        if (encodingVersion.major != Protocol.currentEncoding.major || encodingVersion.minor > Protocol.currentEncoding.minor) {
            throw new UnsupportedEncodingException("", encodingVersion, currentEncoding);
        }
    }

    public static ProtocolVersion getCompatibleProtocol(ProtocolVersion protocolVersion) {
        if (protocolVersion.major != Protocol.currentProtocol.major) {
            return protocolVersion;
        }
        if (protocolVersion.minor < Protocol.currentProtocol.minor) {
            return protocolVersion;
        }
        return currentProtocol;
    }

    public static EncodingVersion getCompatibleEncoding(EncodingVersion encodingVersion) {
        if (encodingVersion.major != Protocol.currentEncoding.major) {
            return encodingVersion;
        }
        if (encodingVersion.minor < Protocol.currentEncoding.minor) {
            return encodingVersion;
        }
        return currentEncoding;
    }

    public static boolean isSupported(EncodingVersion encodingVersion, EncodingVersion encodingVersion2) {
        return encodingVersion.major == encodingVersion2.major && encodingVersion.minor <= encodingVersion2.minor;
    }
}

