/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import IceInternal.BasicStream;
import java.io.IOException;
import java.io.OutputStream;

public class OutputStreamWrapper
extends OutputStream {
    private BasicStream _s;
    private int _spos;
    private byte[] _bytes;
    private int _pos;

    public OutputStreamWrapper(BasicStream basicStream) {
        this._s = basicStream;
        this._spos = basicStream.pos();
        this._bytes = new byte[254];
        this._pos = 0;
    }

    @Override
    public void write(int n) throws IOException {
        try {
            if (this._bytes != null) {
                if (this._pos < this._bytes.length) {
                    this._bytes[this._pos++] = (byte)n;
                    return;
                }
                this._s.writeSize(255);
                if (this._pos > 0) {
                    this._s.expand(this._pos);
                    this._s.getBuffer().b.put(this._bytes, 0, this._pos);
                }
                this._bytes = null;
            }
            this._s.expand(1);
            this._s.getBuffer().b.put((byte)n);
            ++this._pos;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            if (this._bytes != null) {
                if (n2 <= this._bytes.length - this._pos) {
                    System.arraycopy(byArray, n, this._bytes, this._pos, n2);
                    this._pos += n2;
                    return;
                }
                this._s.writeSize(255);
                if (this._pos > 0) {
                    this._s.expand(this._pos);
                    this._s.getBuffer().b.put(this._bytes, 0, this._pos);
                }
                this._bytes = null;
            }
            this._s.expand(n2);
            this._s.getBuffer().b.put(byArray, n, n2);
            this._pos += n2;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        try {
            if (this._bytes != null) {
                assert (this._pos <= this._bytes.length);
                this._s.pos(this._spos);
                this._s.writeSize(this._pos);
                this._s.expand(this._pos);
                this._s.getBuffer().b.put(this._bytes, 0, this._pos);
                this._bytes = null;
            } else {
                int n = this._s.pos();
                this._s.pos(this._spos);
                this._s.writeSize(this._pos);
                this._s.pos(n);
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }
}

