/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Communicator;
import Ice.CommunicatorDestroyedException;
import Ice.ConnectionI;
import Ice.EndpointSelectionType;
import Ice.Holder;
import Ice.Instrumentation.CommunicatorObserver;
import Ice.Instrumentation.Observer;
import Ice.LocalException;
import Ice.ObjectAdapter;
import Ice.OperationInterruptedException;
import IceInternal.CommunicatorFlushBatch;
import IceInternal.Connector;
import IceInternal.DefaultsAndOverrides;
import IceInternal.EndpointI;
import IceInternal.EndpointI_connectors;
import IceInternal.FactoryACMMonitor;
import IceInternal.Instance;
import IceInternal.RouterInfo;
import IceInternal.TraceLevels;
import IceInternal.Transceiver;
import IceUtilInternal.Assert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class OutgoingConnectionFactory {
    private Communicator _communicator;
    private final Instance _instance;
    private final FactoryACMMonitor _monitor;
    private boolean _destroyed;
    private MultiHashMap<Connector, ConnectionI> _connections = new MultiHashMap();
    private MultiHashMap<EndpointI, ConnectionI> _connectionsByEndpoint = new MultiHashMap();
    private Map<Connector, HashSet<ConnectCallback>> _pending = new HashMap<Connector, HashSet<ConnectCallback>>();
    private int _pendingConnectCount = 0;

    public synchronized void destroy() {
        if (this._destroyed) {
            return;
        }
        for (List list : this._connections.values()) {
            for (ConnectionI connectionI : list) {
                connectionI.destroy(1);
            }
        }
        this._destroyed = true;
        this._communicator = null;
        this.notifyAll();
    }

    public synchronized void updateConnectionObservers() {
        for (List list : this._connections.values()) {
            for (ConnectionI connectionI : list) {
                connectionI.updateObserver();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() {
        HashMap<Connector, ConnectionI> hashMap = null;
        Object object = this;
        synchronized (object) {
            while (!this._destroyed || !this._pending.isEmpty() || this._pendingConnectCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new OperationInterruptedException();
                }
            }
            hashMap = new HashMap<Connector, ConnectionI>(this._connections);
        }
        for (List<ConnectionI> list : hashMap.values()) {
            for (ConnectionI object2 : list) {
                try {
                    object2.waitUntilFinished();
                }
                catch (InterruptedException list3) {
                    for (List list2 : hashMap.values()) {
                        for (ConnectionI connectionI : list2) {
                            connectionI.close(true);
                        }
                    }
                    throw new OperationInterruptedException();
                }
            }
        }
        object = this;
        synchronized (object) {
            List<ConnectionI> list;
            list = this._monitor.swapReapedConnections();
            if (list != null) {
                int n = 0;
                for (List list3 : this._connections.values()) {
                    n += list3.size();
                }
                assert (list.size() == n);
                this._connections.clear();
                this._connectionsByEndpoint.clear();
            } else {
                assert (this._connections.isEmpty());
                assert (this._connectionsByEndpoint.isEmpty());
            }
            this._monitor.destroy();
        }
    }

    public void create(EndpointI[] endpointIArray, boolean bl, EndpointSelectionType endpointSelectionType, CreateConnectionCallback createConnectionCallback) {
        Object object;
        assert (endpointIArray.length > 0);
        List<EndpointI> list = this.applyOverrides(endpointIArray);
        try {
            object = new Holder<Boolean>();
            ConnectionI connectionI = this.findConnectionByEndpoint(list, (Holder<Boolean>)object);
            if (connectionI != null) {
                createConnectionCallback.setConnection(connectionI, (Boolean)((Holder)object).value);
                return;
            }
        }
        catch (LocalException localException) {
            createConnectionCallback.setException(localException);
            return;
        }
        object = new ConnectCallback(this, list, bl, createConnectionCallback, endpointSelectionType);
        ((ConnectCallback)object).getConnectors();
    }

    public synchronized void setRouterInfo(RouterInfo routerInfo) {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        assert (routerInfo != null);
        ObjectAdapter objectAdapter = routerInfo.getAdapter();
        DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
        for (EndpointI endpointI : routerInfo.getClientEndpoints()) {
            if (defaultsAndOverrides.overrideTimeout) {
                endpointI = endpointI.timeout(defaultsAndOverrides.overrideTimeoutValue);
            }
            endpointI = endpointI.compress(false);
            for (List list : this._connections.values()) {
                for (ConnectionI connectionI : list) {
                    if (connectionI.endpoint() != endpointI) continue;
                    connectionI.setAdapter(objectAdapter);
                }
            }
        }
    }

    public synchronized void removeAdapter(ObjectAdapter objectAdapter) {
        if (this._destroyed) {
            return;
        }
        for (List list : this._connections.values()) {
            for (ConnectionI connectionI : list) {
                if (connectionI.getAdapter() != objectAdapter) continue;
                connectionI.setAdapter(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAsyncBatchRequests(CommunicatorFlushBatch communicatorFlushBatch) {
        LinkedList<ConnectionI> linkedList = new LinkedList<ConnectionI>();
        OutgoingConnectionFactory outgoingConnectionFactory = this;
        synchronized (outgoingConnectionFactory) {
            if (!this._destroyed) {
                for (List list : this._connections.values()) {
                    for (ConnectionI connectionI : list) {
                        if (!connectionI.isActiveOrHolding()) continue;
                        linkedList.add(connectionI);
                    }
                }
            }
        }
        for (ConnectionI connectionI : linkedList) {
            try {
                communicatorFlushBatch.flushConnection(connectionI);
            }
            catch (LocalException localException) {}
        }
    }

    OutgoingConnectionFactory(Communicator communicator, Instance instance) {
        this._communicator = communicator;
        this._instance = instance;
        this._monitor = new FactoryACMMonitor(instance, instance.clientACM());
        this._destroyed = false;
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._destroyed);
            Assert.FinalizerAssert(this._connections.isEmpty());
            Assert.FinalizerAssert(this._connectionsByEndpoint.isEmpty());
            Assert.FinalizerAssert(this._pendingConnectCount == 0);
            Assert.FinalizerAssert(this._pending.isEmpty());
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    private List<EndpointI> applyOverrides(EndpointI[] endpointIArray) {
        DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
        ArrayList<EndpointI> arrayList = new ArrayList<EndpointI>();
        for (EndpointI endpointI : endpointIArray) {
            if (defaultsAndOverrides.overrideTimeout) {
                arrayList.add(endpointI.timeout(defaultsAndOverrides.overrideTimeoutValue));
                continue;
            }
            arrayList.add(endpointI);
        }
        return arrayList;
    }

    private synchronized ConnectionI findConnectionByEndpoint(List<EndpointI> list, Holder<Boolean> holder) {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
        assert (!list.isEmpty());
        for (EndpointI endpointI : list) {
            List list2 = (List)this._connectionsByEndpoint.get(endpointI);
            if (list2 == null) continue;
            for (ConnectionI connectionI : list2) {
                if (!connectionI.isActiveOrHolding()) continue;
                holder.value = defaultsAndOverrides.overrideCompress ? Boolean.valueOf(defaultsAndOverrides.overrideCompressValue) : Boolean.valueOf(endpointI.compress());
                return connectionI;
            }
        }
        return null;
    }

    private ConnectionI findConnection(List<ConnectorInfo> list, Holder<Boolean> holder) {
        DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
        for (ConnectorInfo connectorInfo : list) {
            List list2;
            if (this._pending.containsKey(connectorInfo.connector) || (list2 = (List)this._connections.get(connectorInfo.connector)) == null) continue;
            for (ConnectionI connectionI : list2) {
                if (!connectionI.isActiveOrHolding()) continue;
                holder.value = defaultsAndOverrides.overrideCompress ? Boolean.valueOf(defaultsAndOverrides.overrideCompressValue) : Boolean.valueOf(connectorInfo.endpoint.compress());
                return connectionI;
            }
        }
        return null;
    }

    private synchronized void incPendingConnectCount() {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        ++this._pendingConnectCount;
    }

    private synchronized void decPendingConnectCount() {
        --this._pendingConnectCount;
        assert (this._pendingConnectCount >= 0);
        if (this._destroyed && this._pendingConnectCount == 0) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionI getConnection(List<ConnectorInfo> list, ConnectCallback connectCallback, Holder<Boolean> holder) {
        assert (connectCallback != null);
        OutgoingConnectionFactory outgoingConnectionFactory = this;
        synchronized (outgoingConnectionFactory) {
            if (this._destroyed) {
                throw new CommunicatorDestroyedException();
            }
            List<ConnectionI> list2 = this._monitor.swapReapedConnections();
            if (list2 != null) {
                for (ConnectionI connectionI : list2) {
                    this._connections.removeElementWithValue(connectionI.connector(), connectionI);
                    this._connectionsByEndpoint.removeElementWithValue(connectionI.endpoint(), connectionI);
                    this._connectionsByEndpoint.removeElementWithValue(connectionI.endpoint().compress(true), connectionI);
                }
            }
            if (this._destroyed) {
                throw new CommunicatorDestroyedException();
            }
            ConnectionI connectionI = this.findConnection(list, holder);
            if (connectionI != null) {
                return connectionI;
            }
            if (this.addToPending(connectCallback, list)) {
                return null;
            }
        }
        if (connectCallback != null) {
            connectCallback.nextConnector();
        }
        return null;
    }

    private synchronized ConnectionI createConnection(Transceiver transceiver, ConnectorInfo connectorInfo) {
        assert (this._pending.containsKey(connectorInfo.connector) && transceiver != null);
        ConnectionI connectionI = null;
        try {
            if (this._destroyed) {
                throw new CommunicatorDestroyedException();
            }
            connectionI = new ConnectionI(this._communicator, this._instance, this._monitor, transceiver, connectorInfo.connector, connectorInfo.endpoint.compress(false), null);
        }
        catch (LocalException localException) {
            try {
                transceiver.close();
            }
            catch (LocalException localException2) {
                // empty catch block
            }
            throw localException;
        }
        this._connections.putOne(connectorInfo.connector, connectionI);
        this._connectionsByEndpoint.putOne(connectionI.endpoint(), connectionI);
        this._connectionsByEndpoint.putOne(connectionI.endpoint().compress(true), connectionI);
        return connectionI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishGetConnection(List<ConnectorInfo> list, ConnectorInfo connectorInfo, ConnectionI connectionI, ConnectCallback connectCallback) {
        HashSet<ConnectCallback> hashSet = new HashSet<ConnectCallback>();
        if (connectCallback != null) {
            hashSet.add(connectCallback);
        }
        HashSet<ConnectCallback> hashSet2 = new HashSet<ConnectCallback>();
        OutgoingConnectionFactory outgoingConnectionFactory = this;
        synchronized (outgoingConnectionFactory) {
            for (ConnectorInfo iterator : list) {
                Set set = this._pending.remove(iterator.connector);
                if (set == null) continue;
                for (ConnectCallback connectCallback2 : set) {
                    if (connectCallback2.hasConnector(connectorInfo)) {
                        hashSet.add(connectCallback2);
                        continue;
                    }
                    hashSet2.add(connectCallback2);
                }
            }
            for (ConnectCallback connectCallback3 : hashSet) {
                connectCallback3.removeFromPending();
                hashSet2.remove(connectCallback3);
            }
            for (ConnectCallback connectCallback4 : hashSet2) {
                connectCallback4.removeFromPending();
            }
            this.notifyAll();
        }
        DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
        boolean bl = defaultsAndOverrides.overrideCompress ? defaultsAndOverrides.overrideCompressValue : connectorInfo.endpoint.compress();
        for (ConnectCallback connectCallback5 : hashSet2) {
            connectCallback5.getConnection();
        }
        for (ConnectCallback connectCallback6 : hashSet) {
            connectCallback6.setConnection(connectionI, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishGetConnection(List<ConnectorInfo> list, LocalException localException, ConnectCallback connectCallback) {
        HashSet<ConnectCallback> hashSet = new HashSet<ConnectCallback>();
        if (connectCallback != null) {
            hashSet.add(connectCallback);
        }
        HashSet<ConnectCallback> hashSet2 = new HashSet<ConnectCallback>();
        Iterator iterator = this;
        synchronized (iterator) {
            for (ConnectorInfo connectorInfo : list) {
                Set set = this._pending.remove(connectorInfo.connector);
                if (set == null) continue;
                for (ConnectCallback connectCallback2 : set) {
                    if (connectCallback2.removeConnectors(list)) {
                        hashSet.add(connectCallback2);
                        continue;
                    }
                    hashSet2.add(connectCallback2);
                }
            }
            for (ConnectCallback connectCallback3 : hashSet2) {
                assert (!hashSet.contains(connectCallback3));
                connectCallback3.removeFromPending();
            }
            this.notifyAll();
        }
        for (ConnectCallback connectCallback4 : hashSet2) {
            connectCallback4.getConnection();
        }
        for (ConnectCallback connectCallback5 : hashSet) {
            connectCallback5.setException(localException);
        }
    }

    private boolean addToPending(ConnectCallback connectCallback, List<ConnectorInfo> list) {
        boolean bl = false;
        for (ConnectorInfo connectorInfo : list) {
            Set set = this._pending.get(connectorInfo.connector);
            if (set == null) continue;
            bl = true;
            if (connectCallback == null) continue;
            set.add(connectCallback);
        }
        if (bl) {
            return true;
        }
        for (ConnectorInfo connectorInfo : list) {
            if (this._pending.containsKey(connectorInfo.connector)) continue;
            this._pending.put(connectorInfo.connector, new HashSet());
        }
        return false;
    }

    private void removeFromPending(ConnectCallback connectCallback, List<ConnectorInfo> list) {
        for (ConnectorInfo connectorInfo : list) {
            Set set = this._pending.get(connectorInfo.connector);
            if (set == null) continue;
            set.remove(connectCallback);
        }
    }

    private void handleConnectionException(LocalException localException, boolean bl) {
        TraceLevels traceLevels = this._instance.traceLevels();
        if (traceLevels.retry >= 2) {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("connection to endpoint failed");
            if (localException instanceof CommunicatorDestroyedException) {
                stringBuilder.append("\n");
            } else if (bl) {
                stringBuilder.append(", trying next endpoint\n");
            } else {
                stringBuilder.append(" and no more endpoints to try\n");
            }
            stringBuilder.append(localException.toString());
            this._instance.initializationData().logger.trace(traceLevels.retryCat, stringBuilder.toString());
        }
    }

    private void handleException(LocalException localException, boolean bl) {
        TraceLevels traceLevels = this._instance.traceLevels();
        if (traceLevels.retry >= 2) {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("couldn't resolve endpoint host");
            if (localException instanceof CommunicatorDestroyedException) {
                stringBuilder.append("\n");
            } else if (bl) {
                stringBuilder.append(", trying next endpoint\n");
            } else {
                stringBuilder.append(" and no more endpoints to try\n");
            }
            stringBuilder.append(localException.toString());
            this._instance.initializationData().logger.trace(traceLevels.retryCat, stringBuilder.toString());
        }
    }

    private static class ConnectCallback
    implements ConnectionI.StartCallback,
    EndpointI_connectors {
        private final OutgoingConnectionFactory _factory;
        private final boolean _hasMore;
        private final CreateConnectionCallback _callback;
        private final List<EndpointI> _endpoints;
        private final EndpointSelectionType _selType;
        private Iterator<EndpointI> _endpointsIter;
        private EndpointI _currentEndpoint;
        private List<ConnectorInfo> _connectors = new ArrayList<ConnectorInfo>();
        private Iterator<ConnectorInfo> _iter;
        private ConnectorInfo _current;
        private Observer _observer;

        ConnectCallback(OutgoingConnectionFactory outgoingConnectionFactory, List<EndpointI> list, boolean bl, CreateConnectionCallback createConnectionCallback, EndpointSelectionType endpointSelectionType) {
            this._factory = outgoingConnectionFactory;
            this._endpoints = list;
            this._hasMore = bl;
            this._callback = createConnectionCallback;
            this._selType = endpointSelectionType;
            this._endpointsIter = this._endpoints.iterator();
        }

        @Override
        public void connectionStartCompleted(ConnectionI connectionI) {
            if (this._observer != null) {
                this._observer.detach();
            }
            connectionI.activate();
            this._factory.finishGetConnection(this._connectors, this._current, connectionI, this);
        }

        @Override
        public void connectionStartFailed(ConnectionI connectionI, LocalException localException) {
            assert (this._current != null);
            if (this.connectionStartFailedImpl(localException)) {
                this.nextConnector();
            }
        }

        @Override
        public void connectors(List<Connector> list) {
            for (Connector connector : list) {
                this._connectors.add(new ConnectorInfo(connector, this._currentEndpoint));
            }
            if (this._endpointsIter.hasNext()) {
                this.nextEndpoint();
            } else {
                assert (!this._connectors.isEmpty());
                this._iter = this._connectors.iterator();
                this.getConnection();
            }
        }

        @Override
        public void exception(LocalException localException) {
            this._factory.handleException(localException, this._hasMore || this._endpointsIter.hasNext());
            if (this._endpointsIter.hasNext()) {
                this.nextEndpoint();
            } else if (!this._connectors.isEmpty()) {
                this._iter = this._connectors.iterator();
                this.getConnection();
            } else {
                this._callback.setException(localException);
                this._factory.decPendingConnectCount();
            }
        }

        void setConnection(ConnectionI connectionI, boolean bl) {
            this._callback.setConnection(connectionI, bl);
            this._factory.decPendingConnectCount();
        }

        void setException(LocalException localException) {
            this._callback.setException(localException);
            this._factory.decPendingConnectCount();
        }

        boolean hasConnector(ConnectorInfo connectorInfo) {
            return this._connectors.contains(connectorInfo);
        }

        boolean removeConnectors(List<ConnectorInfo> list) {
            this._connectors.removeAll(list);
            this._iter = this._connectors.iterator();
            return this._connectors.isEmpty();
        }

        void removeFromPending() {
            this._factory.removeFromPending(this, this._connectors);
        }

        private void getConnectors() {
            try {
                this._factory.incPendingConnectCount();
            }
            catch (LocalException localException) {
                this._callback.setException(localException);
                return;
            }
            this.nextEndpoint();
        }

        private void nextEndpoint() {
            try {
                assert (this._endpointsIter.hasNext());
                this._currentEndpoint = this._endpointsIter.next();
                this._currentEndpoint.connectors_async(this._selType, this);
            }
            catch (LocalException localException) {
                this.exception(localException);
            }
        }

        private void getConnection() {
            try {
                Holder holder = new Holder();
                ConnectionI connectionI = this._factory.getConnection(this._connectors, this, holder);
                if (connectionI == null) {
                    return;
                }
                this._callback.setConnection(connectionI, (Boolean)holder.value);
                this._factory.decPendingConnectCount();
            }
            catch (LocalException localException) {
                this._callback.setException(localException);
                this._factory.decPendingConnectCount();
            }
        }

        private void nextConnector() {
            while (true) {
                Object object;
                try {
                    assert (this._iter.hasNext());
                    this._current = this._iter.next();
                    CommunicatorObserver communicatorObserver = ((OutgoingConnectionFactory)this._factory)._instance.initializationData().observer;
                    if (communicatorObserver != null) {
                        this._observer = communicatorObserver.getConnectionEstablishmentObserver(this._current.endpoint, this._current.connector.toString());
                        if (this._observer != null) {
                            this._observer.attach();
                        }
                    }
                    if (((OutgoingConnectionFactory)this._factory)._instance.traceLevels().network >= 2) {
                        object = new StringBuffer("trying to establish ");
                        ((StringBuffer)object).append(this._current.endpoint.protocol());
                        ((StringBuffer)object).append(" connection to ");
                        ((StringBuffer)object).append(this._current.connector.toString());
                        ((OutgoingConnectionFactory)this._factory)._instance.initializationData().logger.trace(((OutgoingConnectionFactory)this._factory)._instance.traceLevels().networkCat, ((StringBuffer)object).toString());
                    }
                    object = this._factory.createConnection(this._current.connector.connect(), this._current);
                    ((ConnectionI)object).start(this);
                }
                catch (LocalException localException) {
                    if (((OutgoingConnectionFactory)this._factory)._instance.traceLevels().network < 2) continue;
                    object = new StringBuffer("failed to establish ");
                    ((StringBuffer)object).append(this._current.endpoint.protocol());
                    ((StringBuffer)object).append(" connection to ");
                    ((StringBuffer)object).append(this._current.connector.toString());
                    ((StringBuffer)object).append("\n");
                    ((StringBuffer)object).append(localException);
                    ((OutgoingConnectionFactory)this._factory)._instance.initializationData().logger.trace(((OutgoingConnectionFactory)this._factory)._instance.traceLevels().networkCat, ((StringBuffer)object).toString());
                    if (this.connectionStartFailedImpl(localException)) continue;
                }
                break;
            }
        }

        private boolean connectionStartFailedImpl(LocalException localException) {
            if (this._observer != null) {
                this._observer.failed(localException.ice_name());
                this._observer.detach();
            }
            this._factory.handleConnectionException(localException, this._hasMore || this._iter.hasNext());
            if (localException instanceof CommunicatorDestroyedException) {
                this._factory.finishGetConnection(this._connectors, localException, this);
            } else {
                if (this._iter.hasNext()) {
                    return true;
                }
                this._factory.finishGetConnection(this._connectors, localException, this);
            }
            return false;
        }
    }

    private static class ConnectorInfo {
        public Connector connector;
        public EndpointI endpoint;

        public ConnectorInfo(Connector connector, EndpointI endpointI) {
            this.connector = connector;
            this.endpoint = endpointI;
        }

        public boolean equals(Object object) {
            ConnectorInfo connectorInfo = (ConnectorInfo)object;
            return this.connector.equals(connectorInfo.connector);
        }

        public int hashCode() {
            return this.connector.hashCode();
        }
    }

    static interface CreateConnectionCallback {
        public void setConnection(ConnectionI var1, boolean var2);

        public void setException(LocalException var1);
    }

    private static class MultiHashMap<K, V>
    extends HashMap<K, List<V>> {
        private MultiHashMap() {
        }

        public void putOne(K k, V v) {
            LinkedList<V> linkedList = (LinkedList<V>)this.get(k);
            if (linkedList == null) {
                linkedList = new LinkedList<V>();
                this.put(k, linkedList);
            }
            linkedList.add(v);
        }

        public boolean removeElementWithValue(K k, V v) {
            List list = (List)this.get(k);
            assert (list != null);
            boolean bl = list.remove(v);
            if (list.isEmpty()) {
                this.remove(k);
            }
            return bl;
        }
    }
}

