/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Communicator;
import Ice.ConnectionInfo;
import Ice.Endpoint;
import Ice.Exception;
import Ice.Instrumentation.ChildInvocationObserver;
import Ice.ObjectAdapter;
import IceInternal.AsyncResultI;
import IceInternal.BasicStream;
import IceInternal.CallbackBase;
import IceInternal.Instance;
import IceInternal.Protocol;

public abstract class OutgoingAsyncBase
extends AsyncResultI {
    protected BasicStream _os;
    protected ChildInvocationObserver _childObserver;

    public boolean sent() {
        return this.sent(true);
    }

    public boolean completed(BasicStream basicStream) {
        assert (false);
        return false;
    }

    public boolean completed(Exception exception) {
        return this.finished(exception);
    }

    public final void attachRemoteObserver(ConnectionInfo connectionInfo, Endpoint endpoint, int n) {
        if (this._observer != null) {
            int n2 = this._os.size() - 14 - 4;
            this._childObserver = this.getObserver().getRemoteObserver(connectionInfo, endpoint, n, n2);
            if (this._childObserver != null) {
                this._childObserver.attach();
            }
        }
    }

    public final void attachCollocatedObserver(ObjectAdapter objectAdapter, int n) {
        if (this._observer != null) {
            int n2 = this._os.size() - 14 - 4;
            this._childObserver = this.getObserver().getCollocatedObserver(objectAdapter, n, n2);
            if (this._childObserver != null) {
                this._childObserver.attach();
            }
        }
    }

    public final BasicStream getOs() {
        return this._os;
    }

    protected OutgoingAsyncBase(Communicator communicator, Instance instance, String string, CallbackBase callbackBase) {
        super(communicator, instance, string, callbackBase);
        this._os = new BasicStream(instance, Protocol.currentProtocolEncoding);
    }

    protected OutgoingAsyncBase(Communicator communicator, Instance instance, String string, CallbackBase callbackBase, BasicStream basicStream) {
        super(communicator, instance, string, callbackBase);
        this._os = basicStream;
    }

    @Override
    protected boolean sent(boolean bl) {
        if (bl && this._childObserver != null) {
            this._childObserver.detach();
            this._childObserver = null;
        }
        return super.sent(bl);
    }

    @Override
    protected boolean finished(Exception exception) {
        if (this._childObserver != null) {
            this._childObserver.failed(exception.ice_name());
            this._childObserver.detach();
            this._childObserver = null;
        }
        return super.finished(exception);
    }
}

