/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AsyncResult;
import Ice.ConnectionI;
import Ice.ContextHelper;
import Ice.EncodingVersion;
import Ice.Exception;
import Ice.FacetNotExistException;
import Ice.FormatType;
import Ice.Identity;
import Ice.ImplicitContextI;
import Ice.MarshalException;
import Ice.ObjectNotExistException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.OperationMode;
import Ice.OperationNotExistException;
import Ice.RequestFailedException;
import Ice.UnknownException;
import Ice.UnknownLocalException;
import Ice.UnknownReplyStatusException;
import Ice.UnknownUserException;
import Ice.UserException;
import IceInternal.BasicStream;
import IceInternal.CallbackBase;
import IceInternal.CollocatedRequestHandler;
import IceInternal.ObserverHelper;
import IceInternal.Protocol;
import IceInternal.ProxyOutgoingAsyncBase;
import IceInternal.Reference;
import IceInternal.RetryException;
import java.util.HashMap;
import java.util.Map;

public class OutgoingAsync
extends ProxyOutgoingAsyncBase {
    private final EncodingVersion _encoding;
    private BasicStream _is;
    private boolean _synchronous;
    private static final Map<String, String> _emptyContext = new HashMap<String, String>();

    public static OutgoingAsync check(AsyncResult asyncResult, ObjectPrx objectPrx, String string) {
        ProxyOutgoingAsyncBase.checkImpl(asyncResult, objectPrx, string);
        try {
            return (OutgoingAsync)asyncResult;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Incorrect AsyncResult object for end_" + string + " method");
        }
    }

    public OutgoingAsync(ObjectPrx objectPrx, String string, CallbackBase callbackBase) {
        super((ObjectPrxHelperBase)objectPrx, string, callbackBase);
        this._encoding = Protocol.getCompatibleEncoding(this._proxy.__reference().getEncoding());
        this._is = null;
    }

    public OutgoingAsync(ObjectPrx objectPrx, String string, CallbackBase callbackBase, BasicStream basicStream, BasicStream basicStream2) {
        super((ObjectPrxHelperBase)objectPrx, string, callbackBase, basicStream2);
        this._encoding = Protocol.getCompatibleEncoding(this._proxy.__reference().getEncoding());
        this._is = basicStream;
    }

    public void prepare(String string, OperationMode operationMode, Map<String, String> map, boolean bl, boolean bl2) {
        Object object;
        Protocol.checkSupportedProtocol(Protocol.getCompatibleProtocol(this._proxy.__reference().getProtocol()));
        this._mode = operationMode;
        this._synchronous = bl2;
        if (bl && map == null) {
            map = _emptyContext;
        }
        this._observer = ObserverHelper.get(this._proxy, string, map);
        switch (this._proxy.__reference().getMode()) {
            case 0: 
            case 1: 
            case 3: {
                this._os.writeBlob(Protocol.requestHdr);
                break;
            }
            case 2: 
            case 4: {
                this._proxy.__getBatchRequestQueue().prepareBatchRequest(this._os);
            }
        }
        Reference reference = this._proxy.__reference();
        reference.getIdentity().__write(this._os);
        String string2 = reference.getFacet();
        if (string2 == null || string2.length() == 0) {
            this._os.writeStringSeq(null);
        } else {
            object = new String[]{string2};
            this._os.writeStringSeq((String[])object);
        }
        this._os.writeString(string);
        this._os.writeByte((byte)operationMode.value());
        if (map != null) {
            ContextHelper.write(this._os, map);
        } else {
            object = reference.getInstance().getImplicitContext();
            Map<String, String> map2 = reference.getContext();
            if (object == null) {
                ContextHelper.write(this._os, map2);
            } else {
                ((ImplicitContextI)object).write(map2, this._os);
            }
        }
    }

    @Override
    public boolean sent() {
        return this.sent(!this._proxy.ice_isTwoway());
    }

    @Override
    public int invokeRemote(ConnectionI connectionI, boolean bl, boolean bl2) throws RetryException {
        this._cachedConnection = connectionI;
        return connectionI.sendAsyncRequest(this, bl, bl2, 0);
    }

    @Override
    public int invokeCollocated(CollocatedRequestHandler collocatedRequestHandler) {
        if (!this._proxy.ice_isTwoway() || this._proxy.__reference().getInvocationTimeout() > 0) {
            this._state = (byte)(this._state | 0x10);
        }
        return collocatedRequestHandler.invokeAsyncRequest(this, 0, this._synchronous);
    }

    @Override
    public void abort(Exception exception) {
        int n = this._proxy.__reference().getMode();
        if (n == 2 || n == 4) {
            this._proxy.__getBatchRequestQueue().abortBatchRequest(this._os);
        }
        super.abort(exception);
    }

    public void invoke() {
        int n = this._proxy.__reference().getMode();
        if (n == 2 || n == 4) {
            this._sentSynchronously = true;
            this._proxy.__getBatchRequestQueue().finishBatchRequest(this._os, this._proxy, this.getOperation());
            this.finished(true);
        } else {
            this.invokeImpl(true);
        }
    }

    @Override
    public final boolean completed(BasicStream basicStream) {
        assert (this._proxy.ice_isTwoway());
        if (this._childObserver != null) {
            this._childObserver.reply(basicStream.size() - 14 - 4);
            this._childObserver.detach();
            this._childObserver = null;
        }
        try {
            if (this._is == null) {
                this._is = new BasicStream(this._instance, Protocol.currentProtocolEncoding);
            }
            this._is.swap(basicStream);
            byte by = this._is.readByte();
            switch (by) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this._observer == null) break;
                    this._observer.userException();
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    String string;
                    Identity identity = new Identity();
                    identity.__read(this._is);
                    String[] stringArray = this._is.readStringSeq();
                    if (stringArray.length > 0) {
                        if (stringArray.length > 1) {
                            throw new MarshalException();
                        }
                        string = stringArray[0];
                    } else {
                        string = "";
                    }
                    String string2 = this._is.readString();
                    RequestFailedException requestFailedException = null;
                    switch (by) {
                        case 2: {
                            requestFailedException = new ObjectNotExistException();
                            break;
                        }
                        case 3: {
                            requestFailedException = new FacetNotExistException();
                            break;
                        }
                        case 4: {
                            requestFailedException = new OperationNotExistException();
                            break;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                    requestFailedException.id = identity;
                    requestFailedException.facet = string;
                    requestFailedException.operation = string2;
                    throw requestFailedException;
                }
                case 5: 
                case 6: 
                case 7: {
                    String string = this._is.readString();
                    UnknownException unknownException = null;
                    switch (by) {
                        case 7: {
                            unknownException = new UnknownException();
                            break;
                        }
                        case 5: {
                            unknownException = new UnknownLocalException();
                            break;
                        }
                        case 6: {
                            unknownException = new UnknownUserException();
                            break;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                    unknownException.unknown = string;
                    throw unknownException;
                }
                default: {
                    throw new UnknownReplyStatusException();
                }
            }
            return this.finished(by == 0);
        }
        catch (Exception exception) {
            return this.completed(exception);
        }
    }

    public BasicStream startWriteParams(FormatType formatType) {
        this._os.startWriteEncaps(this._encoding, formatType);
        return this._os;
    }

    public void endWriteParams() {
        this._os.endWriteEncaps();
    }

    public void writeEmptyParams() {
        this._os.writeEmptyEncaps(this._encoding);
    }

    public void writeParamEncaps(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            this._os.writeEmptyEncaps(this._encoding);
        } else {
            this._os.writeEncaps(byArray);
        }
    }

    public BasicStream startReadParams() {
        this._is.startReadEncaps();
        return this._is;
    }

    public void endReadParams() {
        this._is.endReadEncaps();
    }

    public void readEmptyParams() {
        this._is.skipEmptyEncaps();
    }

    public byte[] readParamEncaps() {
        return this._is.readEncaps(null);
    }

    public final void throwUserException() throws UserException {
        try {
            this._is.startReadEncaps();
            this._is.throwException(null);
        }
        catch (UserException userException) {
            this._is.endReadEncaps();
            throw userException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheMessageBuffers() {
        if (this._proxy.__reference().getInstance().cacheMessageBuffers() > 0) {
            OutgoingAsync outgoingAsync = this;
            synchronized (outgoingAsync) {
                if ((this._state & 0x10) > 0) {
                    return;
                }
                this._state = (byte)(this._state | 0x10);
            }
            if (this._is != null) {
                this._is.reset();
            }
            this._os.reset();
            this._proxy.cacheMessageBuffers(this._is, this._os);
            this._is = null;
            this._os = null;
        }
    }
}

