/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.EncodingVersion;
import Ice.EndpointInfo;
import Ice.EndpointParseException;
import Ice.EndpointSelectionType;
import Ice.FormatType;
import Ice.OpaqueEndpointInfo;
import Ice.Util;
import Ice.VersionParseException;
import IceInternal.Acceptor;
import IceInternal.BasicStream;
import IceInternal.Connector;
import IceInternal.EndpointI;
import IceInternal.EndpointI_connectors;
import IceInternal.HashUtil;
import IceInternal.Transceiver;
import IceUtilInternal.Base64;
import java.util.ArrayList;
import java.util.List;

final class OpaqueEndpointI
extends EndpointI {
    private short _type;
    private EncodingVersion _rawEncoding;
    private byte[] _rawBytes;
    private int _hashCode;

    public OpaqueEndpointI(ArrayList<String> arrayList) {
        this._type = (short)-1;
        this._rawEncoding = Util.Encoding_1_0;
        this._rawBytes = new byte[0];
        this.initWithOptions(arrayList);
        if (this._type < 0) {
            throw new EndpointParseException("no -t option in endpoint " + this.toString());
        }
        if (this._rawBytes.length == 0) {
            throw new EndpointParseException("no -v option in endpoint " + this.toString());
        }
        this.calcHashValue();
    }

    public OpaqueEndpointI(short s, BasicStream basicStream) {
        this._type = s;
        this._rawEncoding = basicStream.getReadEncoding();
        int n = basicStream.getReadEncapsSize();
        this._rawBytes = basicStream.readBlob(n);
        this.calcHashValue();
    }

    @Override
    public void streamWrite(BasicStream basicStream) {
        basicStream.startWriteEncaps(this._rawEncoding, FormatType.DefaultFormat);
        basicStream.writeBlob(this._rawBytes);
        basicStream.endWriteEncaps();
    }

    @Override
    public EndpointInfo getInfo() {
        return new OpaqueEndpointInfo(-1, false, this._rawEncoding, this._rawBytes){

            @Override
            public short type() {
                return OpaqueEndpointI.this._type;
            }

            @Override
            public boolean datagram() {
                return false;
            }

            @Override
            public boolean secure() {
                return false;
            }
        };
    }

    @Override
    public short type() {
        return this._type;
    }

    @Override
    public String protocol() {
        return "opaque";
    }

    @Override
    public int timeout() {
        return -1;
    }

    @Override
    public EndpointI timeout(int n) {
        return this;
    }

    @Override
    public String connectionId() {
        return "";
    }

    @Override
    public EndpointI connectionId(String string) {
        return this;
    }

    @Override
    public boolean compress() {
        return false;
    }

    @Override
    public EndpointI compress(boolean bl) {
        return this;
    }

    @Override
    public boolean datagram() {
        return false;
    }

    @Override
    public boolean secure() {
        return false;
    }

    @Override
    public Transceiver transceiver() {
        return null;
    }

    @Override
    public void connectors_async(EndpointSelectionType endpointSelectionType, EndpointI_connectors endpointI_connectors) {
        endpointI_connectors.connectors(new ArrayList<Connector>());
    }

    @Override
    public Acceptor acceptor(String string) {
        return null;
    }

    @Override
    public List<EndpointI> expand() {
        ArrayList<EndpointI> arrayList = new ArrayList<EndpointI>();
        arrayList.add(this);
        return arrayList;
    }

    @Override
    public boolean equivalent(EndpointI endpointI) {
        return false;
    }

    public int hashCode() {
        return this._hashCode;
    }

    @Override
    public String options() {
        String string = "";
        if (this._type > -1) {
            string = string + " -t " + this._type;
        }
        string = string + " -e " + Util.encodingVersionToString(this._rawEncoding);
        if (this._rawBytes.length > 0) {
            string = string + " -v " + Base64.encode(this._rawBytes);
        }
        return string;
    }

    @Override
    public int compareTo(EndpointI endpointI) {
        if (!(endpointI instanceof OpaqueEndpointI)) {
            return this.type() < endpointI.type() ? -1 : 1;
        }
        OpaqueEndpointI opaqueEndpointI = (OpaqueEndpointI)endpointI;
        if (this == opaqueEndpointI) {
            return 0;
        }
        if (this._type < opaqueEndpointI._type) {
            return -1;
        }
        if (opaqueEndpointI._type < this._type) {
            return 1;
        }
        if (this._rawEncoding.major < opaqueEndpointI._rawEncoding.major) {
            return -1;
        }
        if (opaqueEndpointI._rawEncoding.major < this._rawEncoding.major) {
            return 1;
        }
        if (this._rawEncoding.minor < opaqueEndpointI._rawEncoding.minor) {
            return -1;
        }
        if (opaqueEndpointI._rawEncoding.minor < this._rawEncoding.minor) {
            return 1;
        }
        if (this._rawBytes.length < opaqueEndpointI._rawBytes.length) {
            return -1;
        }
        if (opaqueEndpointI._rawBytes.length < this._rawBytes.length) {
            return 1;
        }
        for (int i = 0; i < this._rawBytes.length; ++i) {
            if (this._rawBytes[i] < opaqueEndpointI._rawBytes[i]) {
                return -1;
            }
            if (opaqueEndpointI._rawBytes[i] >= this._rawBytes[i]) continue;
            return 1;
        }
        return 0;
    }

    @Override
    protected boolean checkOption(String string, String string2, String string3) {
        switch (string.charAt(1)) {
            case 't': {
                int n;
                if (this._type > -1) {
                    throw new EndpointParseException("multiple -t options in endpoint " + string3);
                }
                if (string2 == null) {
                    throw new EndpointParseException("no argument provided for -t option in endpoint " + string3);
                }
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new EndpointParseException("invalid type value `" + string2 + "' in endpoint " + string3);
                }
                if (n < 0 || n > 65535) {
                    throw new EndpointParseException("type value `" + string2 + "' out of range in endpoint " + string3);
                }
                this._type = (short)n;
                return true;
            }
            case 'v': {
                if (this._rawBytes.length > 0) {
                    throw new EndpointParseException("multiple -v options in endpoint " + string3);
                }
                if (string2 == null) {
                    throw new EndpointParseException("no argument provided for -v option in endpoint " + string3);
                }
                for (int i = 0; i < string2.length(); ++i) {
                    if (Base64.isBase64(string2.charAt(i))) continue;
                    throw new EndpointParseException("invalid base64 character `" + string2.charAt(i) + "' (ordinal " + string2.charAt(i) + ") in endpoint " + string3);
                }
                this._rawBytes = Base64.decode(string2);
                return true;
            }
            case 'e': {
                if (string2 == null) {
                    throw new EndpointParseException("no argument provided for -e option in endpoint " + string3);
                }
                try {
                    this._rawEncoding = Util.stringToEncodingVersion(string2);
                }
                catch (VersionParseException versionParseException) {
                    throw new EndpointParseException("invalid encoding version `" + string2 + "' in endpoint " + string3 + ":\n" + versionParseException.str);
                }
                return true;
            }
        }
        return false;
    }

    private void calcHashValue() {
        int n = 5381;
        n = HashUtil.hashAdd(n, this._type);
        n = HashUtil.hashAdd(n, this._rawEncoding);
        this._hashCode = n = HashUtil.hashAdd(n, this._rawBytes);
    }
}

