/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AlreadyRegisteredException;
import Ice.NotRegisteredException;
import Ice.ObjectFactory;
import java.util.HashMap;
import java.util.Map;

public final class ObjectFactoryManager {
    private Map<String, ObjectFactory> _factoryMap = new HashMap<String, ObjectFactory>();

    public synchronized void add(ObjectFactory objectFactory, String string) {
        ObjectFactory objectFactory2 = this._factoryMap.get(string);
        if (objectFactory2 != null) {
            AlreadyRegisteredException alreadyRegisteredException = new AlreadyRegisteredException();
            alreadyRegisteredException.id = string;
            alreadyRegisteredException.kindOfObject = "object factory";
            throw alreadyRegisteredException;
        }
        this._factoryMap.put(string, objectFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String string) {
        ObjectFactory objectFactory = null;
        ObjectFactoryManager objectFactoryManager = this;
        synchronized (objectFactoryManager) {
            objectFactory = this._factoryMap.get(string);
            if (objectFactory == null) {
                NotRegisteredException notRegisteredException = new NotRegisteredException();
                notRegisteredException.id = string;
                notRegisteredException.kindOfObject = "object factory";
                throw notRegisteredException;
            }
            this._factoryMap.remove(string);
        }
        objectFactory.destroy();
    }

    public synchronized ObjectFactory find(String string) {
        return this._factoryMap.get(string);
    }

    ObjectFactoryManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        Map<String, ObjectFactory> map = null;
        ObjectFactoryManager objectFactoryManager = this;
        synchronized (objectFactoryManager) {
            map = this._factoryMap;
            this._factoryMap = new HashMap<String, ObjectFactory>();
        }
        for (ObjectFactory objectFactory : map.values()) {
            objectFactory.destroy();
        }
    }
}

