/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AlreadyRegisteredException;
import Ice.Communicator;
import Ice.CommunicatorDestroyedException;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectAdapterI;
import Ice.ObjectPrx;
import Ice.OperationInterruptedException;
import Ice.RouterPrx;
import IceInternal.CommunicatorFlushBatch;
import IceInternal.Instance;
import IceUtilInternal.Assert;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public final class ObjectAdapterFactory {
    private Instance _instance;
    private Communicator _communicator;
    private Set<String> _adapterNamesInUse = new HashSet<String>();
    private List<ObjectAdapterI> _adapters = new LinkedList<ObjectAdapterI>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        LinkedList<ObjectAdapterI> linkedList;
        Object object = this;
        synchronized (object) {
            if (this._instance == null) {
                return;
            }
            linkedList = new LinkedList<ObjectAdapterI>(this._adapters);
        }
        for (ObjectAdapterI objectAdapterI : linkedList) {
            objectAdapterI.deactivate();
        }
        object = this;
        synchronized (object) {
            this._instance = null;
            this._communicator = null;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForShutdown() {
        LinkedList<ObjectAdapterI> linkedList;
        ObjectAdapterFactory objectAdapterFactory = this;
        synchronized (objectAdapterFactory) {
            while (this._instance != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new OperationInterruptedException();
                }
            }
            linkedList = new LinkedList<ObjectAdapterI>(this._adapters);
        }
        for (ObjectAdapterI objectAdapterI : linkedList) {
            objectAdapterI.waitForDeactivate();
        }
    }

    public synchronized boolean isShutdown() {
        return this._instance == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        LinkedList<ObjectAdapterI> linkedList;
        this.waitForShutdown();
        Object object = this;
        synchronized (object) {
            linkedList = new LinkedList<ObjectAdapterI>(this._adapters);
        }
        for (ObjectAdapterI objectAdapterI : linkedList) {
            objectAdapterI.destroy();
        }
        object = this;
        synchronized (object) {
            this._adapters.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnectionObservers() {
        LinkedList<ObjectAdapterI> linkedList;
        ObjectAdapterFactory objectAdapterFactory = this;
        synchronized (objectAdapterFactory) {
            linkedList = new LinkedList<ObjectAdapterI>(this._adapters);
        }
        for (ObjectAdapterI objectAdapterI : linkedList) {
            objectAdapterI.updateConnectionObservers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateThreadObservers() {
        LinkedList<ObjectAdapterI> linkedList;
        ObjectAdapterFactory objectAdapterFactory = this;
        synchronized (objectAdapterFactory) {
            linkedList = new LinkedList<ObjectAdapterI>(this._adapters);
        }
        for (ObjectAdapterI objectAdapterI : linkedList) {
            objectAdapterI.updateThreadObservers();
        }
    }

    public synchronized ObjectAdapter createObjectAdapter(String string, RouterPrx routerPrx) {
        if (Thread.interrupted()) {
            throw new OperationInterruptedException();
        }
        if (this._instance == null) {
            throw new CommunicatorDestroyedException();
        }
        ObjectAdapterI objectAdapterI = null;
        if (string.length() == 0) {
            String string2 = UUID.randomUUID().toString();
            objectAdapterI = new ObjectAdapterI(this._instance, this._communicator, this, string2, null, true);
        } else {
            if (this._adapterNamesInUse.contains(string)) {
                throw new AlreadyRegisteredException("object adapter", string);
            }
            objectAdapterI = new ObjectAdapterI(this._instance, this._communicator, this, string, routerPrx, false);
            this._adapterNamesInUse.add(string);
        }
        this._adapters.add(objectAdapterI);
        return objectAdapterI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectAdapter findObjectAdapter(ObjectPrx objectPrx) {
        LinkedList<ObjectAdapterI> linkedList;
        ObjectAdapterFactory objectAdapterFactory = this;
        synchronized (objectAdapterFactory) {
            if (this._instance == null) {
                return null;
            }
            linkedList = new LinkedList<ObjectAdapterI>(this._adapters);
        }
        for (ObjectAdapterI objectAdapterI : linkedList) {
            try {
                if (!objectAdapterI.isLocal(objectPrx)) continue;
                return objectAdapterI;
            }
            catch (ObjectAdapterDeactivatedException objectAdapterDeactivatedException) {
            }
        }
        return null;
    }

    public synchronized void removeObjectAdapter(ObjectAdapter objectAdapter) {
        if (this._instance == null) {
            return;
        }
        this._adapters.remove(objectAdapter);
        this._adapterNamesInUse.remove(objectAdapter.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAsyncBatchRequests(CommunicatorFlushBatch communicatorFlushBatch) {
        LinkedList<ObjectAdapterI> linkedList;
        ObjectAdapterFactory objectAdapterFactory = this;
        synchronized (objectAdapterFactory) {
            linkedList = new LinkedList<ObjectAdapterI>(this._adapters);
        }
        for (ObjectAdapterI objectAdapterI : linkedList) {
            objectAdapterI.flushAsyncBatchRequests(communicatorFlushBatch);
        }
    }

    ObjectAdapterFactory(Instance instance, Communicator communicator) {
        this._instance = instance;
        this._communicator = communicator;
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._instance == null);
            Assert.FinalizerAssert(this._communicator == null);
            Assert.FinalizerAssert(this._adapters.isEmpty());
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }
}

