/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectFailedException;
import Ice.ConnectionRefusedException;
import Ice.DNSException;
import Ice.EndpointSelectionType;
import Ice.SocketException;
import IceInternal.BufSizeWarnInfo;
import IceInternal.NetworkProxy;
import IceInternal.ProtocolInstance;
import IceInternal.Util;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class Network {
    public static final int EnableIPv4 = 0;
    public static final int EnableIPv6 = 1;
    public static final int EnableBoth = 2;
    private static Pattern IPV4_PATTERN;
    private static Pattern IPV6_PATTERN;
    private static final String ipv4Pattern = "(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])";
    private static final String ipv6Pattern = "(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))";
    private static IPAddressComparator _preferIPv4Comparator;
    private static IPAddressComparator _preferIPv6Comparator;

    public static boolean isNumericAddress(String string) {
        Matcher matcher = IPV4_PATTERN.matcher(string);
        if (matcher.matches()) {
            return true;
        }
        Matcher matcher2 = IPV6_PATTERN.matcher(string);
        return matcher2.matches();
    }

    public static boolean connectionRefused(ConnectException connectException) {
        String string = connectException.getMessage();
        if (string != null) {
            String[] stringArray;
            string = string.toLowerCase();
            for (String string2 : stringArray = new String[]{"connection refused", "remote host refused an attempted connect operation"}) {
                if (string.indexOf(string2) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean noMoreFds(Throwable throwable) {
        String string = throwable.getMessage();
        if (string != null) {
            String[] stringArray;
            string = string.toLowerCase();
            for (String string2 : stringArray = new String[]{"too many open files", "file table overflow", "too many open files in system"}) {
                if (string.indexOf(string2) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isIPv6Supported() {
        try {
            Socket socket = new Socket();
            socket.bind(new InetSocketAddress(InetAddress.getByName("::1"), 0));
            socket.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static SocketChannel createTcpSocket() {
        try {
            SocketChannel socketChannel = SocketChannel.open();
            Socket socket = socketChannel.socket();
            socket.setTcpNoDelay(true);
            socket.setKeepAlive(true);
            return socketChannel;
        }
        catch (IOException iOException) {
            throw new SocketException(iOException);
        }
    }

    public static ServerSocketChannel createTcpServerSocket() {
        try {
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            return serverSocketChannel;
        }
        catch (IOException iOException) {
            throw new SocketException(iOException);
        }
    }

    public static DatagramChannel createUdpSocket(InetSocketAddress inetSocketAddress) {
        try {
            Class<?> clazz = Util.findClass("java.net.StandardProtocolFamily", null);
            if (inetSocketAddress.getAddress().isMulticastAddress() && clazz != null) {
                String string = "INET";
                if (inetSocketAddress.getAddress() instanceof Inet6Address) {
                    string = "INET6";
                }
                Method method = clazz.getDeclaredMethod("valueOf", String.class);
                Object[] objectArray = new Object[]{method.invoke(null, string)};
                Method method2 = DatagramChannel.class.getDeclaredMethod("open", Util.findClass("java.net.ProtocolFamily", null));
                return (DatagramChannel)method2.invoke(null, objectArray);
            }
            return DatagramChannel.open();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SocketException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SocketException(invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new SocketException(noSuchMethodException);
        }
        catch (IOException iOException) {
            throw new SocketException(iOException);
        }
    }

    public static void closeSocketNoThrow(SelectableChannel selectableChannel) {
        try {
            selectableChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeSocket(SelectableChannel selectableChannel) {
        try {
            selectableChannel.close();
        }
        catch (IOException iOException) {
            throw new SocketException(iOException);
        }
    }

    public static void setBlock(SelectableChannel selectableChannel, boolean bl) {
        try {
            selectableChannel.configureBlocking(bl);
        }
        catch (IOException iOException) {
            Network.closeSocketNoThrow(selectableChannel);
            throw new SocketException(iOException);
        }
    }

    public static void setReuseAddress(DatagramChannel datagramChannel, boolean bl) {
        try {
            datagramChannel.socket().setReuseAddress(bl);
        }
        catch (IOException iOException) {
            Network.closeSocketNoThrow(datagramChannel);
            throw new SocketException(iOException);
        }
    }

    public static void setReuseAddress(ServerSocketChannel serverSocketChannel, boolean bl) {
        try {
            serverSocketChannel.socket().setReuseAddress(bl);
        }
        catch (IOException iOException) {
            Network.closeSocketNoThrow(serverSocketChannel);
            throw new SocketException(iOException);
        }
    }

    public static InetSocketAddress doBind(ServerSocketChannel serverSocketChannel, InetSocketAddress inetSocketAddress, int n) {
        try {
            ServerSocket serverSocket = serverSocketChannel.socket();
            serverSocket.bind(inetSocketAddress, n);
            return (InetSocketAddress)serverSocket.getLocalSocketAddress();
        }
        catch (IOException iOException) {
            Network.closeSocketNoThrow(serverSocketChannel);
            throw new SocketException(iOException);
        }
    }

    public static InetSocketAddress doBind(DatagramChannel datagramChannel, InetSocketAddress inetSocketAddress) {
        try {
            DatagramSocket datagramSocket = datagramChannel.socket();
            datagramSocket.bind(inetSocketAddress);
            return (InetSocketAddress)datagramSocket.getLocalSocketAddress();
        }
        catch (IOException iOException) {
            Network.closeSocketNoThrow(datagramChannel);
            throw new SocketException(iOException);
        }
    }

    public static SocketChannel doAccept(ServerSocketChannel serverSocketChannel) {
        SocketChannel socketChannel = null;
        while (true) {
            try {
                socketChannel = serverSocketChannel.accept();
            }
            catch (IOException iOException) {
                if (Network.interrupted(iOException)) continue;
                throw new SocketException(iOException);
            }
            break;
        }
        try {
            Socket socket = socketChannel.socket();
            socket.setTcpNoDelay(true);
            socket.setKeepAlive(true);
        }
        catch (IOException iOException) {
            throw new SocketException(iOException);
        }
        return socketChannel;
    }

    public static boolean doConnect(SocketChannel socketChannel, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
        try {
            if (!socketChannel.connect(inetSocketAddress)) {
                return false;
            }
        }
        catch (ConnectException connectException) {
            Network.closeSocketNoThrow(socketChannel);
            if (Network.connectionRefused(connectException)) {
                throw new ConnectionRefusedException(connectException);
            }
            throw new ConnectFailedException(connectException);
        }
        catch (IOException iOException) {
            Network.closeSocketNoThrow(socketChannel);
            throw new SocketException(iOException);
        }
        catch (SecurityException securityException) {
            Network.closeSocketNoThrow(socketChannel);
            throw new SocketException(securityException);
        }
        if (System.getProperty("os.name").equals("Linux") && inetSocketAddress.equals(socketChannel.socket().getLocalSocketAddress())) {
            Network.closeSocketNoThrow(socketChannel);
            throw new ConnectionRefusedException();
        }
        return true;
    }

    public static void doFinishConnect(SocketChannel socketChannel) {
        try {
            SocketAddress socketAddress;
            if (!socketChannel.finishConnect()) {
                throw new ConnectFailedException();
            }
            if (System.getProperty("os.name").equals("Linux") && (socketAddress = socketChannel.socket().getRemoteSocketAddress()) != null && socketAddress.equals(socketChannel.socket().getLocalSocketAddress())) {
                throw new ConnectionRefusedException();
            }
        }
        catch (ConnectException connectException) {
            if (Network.connectionRefused(connectException)) {
                throw new ConnectionRefusedException(connectException);
            }
            throw new ConnectFailedException(connectException);
        }
        catch (IOException iOException) {
            throw new SocketException(iOException);
        }
    }

    public static void doConnect(DatagramChannel datagramChannel, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
        if (inetSocketAddress2 != null) {
            Network.doBind(datagramChannel, inetSocketAddress2);
        }
        try {
            datagramChannel.connect(inetSocketAddress);
        }
        catch (ConnectException connectException) {
            Network.closeSocketNoThrow(datagramChannel);
            if (Network.connectionRefused(connectException)) {
                throw new ConnectionRefusedException(connectException);
            }
            throw new ConnectFailedException(connectException);
        }
        catch (IOException iOException) {
            Network.closeSocketNoThrow(datagramChannel);
            throw new SocketException(iOException);
        }
    }

    public static void setSendBufferSize(SocketChannel socketChannel, int n) {
        try {
            Socket socket = socketChannel.socket();
            socket.setSendBufferSize(n);
        }
        catch (IOException iOException) {
            Network.closeSocketNoThrow(socketChannel);
            throw new SocketException(iOException);
        }
    }

    public static int getSendBufferSize(SocketChannel socketChannel) {
        int n;
        try {
            Socket socket = socketChannel.socket();
            n = socket.getSendBufferSize();
        }
        catch (IOException iOException) {
            Network.closeSocketNoThrow(socketChannel);
            throw new SocketException(iOException);
        }
        return n;
    }

    public static void setRecvBufferSize(SocketChannel socketChannel, int n) {
        try {
            Socket socket = socketChannel.socket();
            socket.setReceiveBufferSize(n);
        }
        catch (IOException iOException) {
            Network.closeSocketNoThrow(socketChannel);
            throw new SocketException(iOException);
        }
    }

    public static int getRecvBufferSize(SocketChannel socketChannel) {
        int n;
        try {
            Socket socket = socketChannel.socket();
            n = socket.getReceiveBufferSize();
        }
        catch (IOException iOException) {
            Network.closeSocketNoThrow(socketChannel);
            throw new SocketException(iOException);
        }
        return n;
    }

    public static void setRecvBufferSize(ServerSocketChannel serverSocketChannel, int n) {
        try {
            ServerSocket serverSocket = serverSocketChannel.socket();
            serverSocket.setReceiveBufferSize(n);
        }
        catch (IOException iOException) {
            Network.closeSocketNoThrow(serverSocketChannel);
            throw new SocketException(iOException);
        }
    }

    public static int getRecvBufferSize(ServerSocketChannel serverSocketChannel) {
        int n;
        try {
            ServerSocket serverSocket = serverSocketChannel.socket();
            n = serverSocket.getReceiveBufferSize();
        }
        catch (IOException iOException) {
            Network.closeSocketNoThrow(serverSocketChannel);
            throw new SocketException(iOException);
        }
        return n;
    }

    public static void setSendBufferSize(DatagramChannel datagramChannel, int n) {
        try {
            DatagramSocket datagramSocket = datagramChannel.socket();
            datagramSocket.setSendBufferSize(n);
        }
        catch (IOException iOException) {
            Network.closeSocketNoThrow(datagramChannel);
            throw new SocketException(iOException);
        }
    }

    public static int getSendBufferSize(DatagramChannel datagramChannel) {
        int n;
        try {
            DatagramSocket datagramSocket = datagramChannel.socket();
            n = datagramSocket.getSendBufferSize();
        }
        catch (IOException iOException) {
            Network.closeSocketNoThrow(datagramChannel);
            throw new SocketException(iOException);
        }
        return n;
    }

    public static void setRecvBufferSize(DatagramChannel datagramChannel, int n) {
        try {
            DatagramSocket datagramSocket = datagramChannel.socket();
            datagramSocket.setReceiveBufferSize(n);
        }
        catch (IOException iOException) {
            Network.closeSocketNoThrow(datagramChannel);
            throw new SocketException(iOException);
        }
    }

    public static int getRecvBufferSize(DatagramChannel datagramChannel) {
        int n;
        try {
            DatagramSocket datagramSocket = datagramChannel.socket();
            n = datagramSocket.getReceiveBufferSize();
        }
        catch (IOException iOException) {
            Network.closeSocketNoThrow(datagramChannel);
            throw new SocketException(iOException);
        }
        return n;
    }

    public static InetSocketAddress getAddressForServer(String string, int n, int n2, boolean bl) {
        if (string == null || string.length() == 0) {
            try {
                if (n2 != 0) {
                    return new InetSocketAddress(InetAddress.getByName("::0"), n);
                }
                return new InetSocketAddress(InetAddress.getByName("0.0.0.0"), n);
            }
            catch (UnknownHostException unknownHostException) {
                assert (false);
                return null;
            }
            catch (SecurityException securityException) {
                throw new SocketException(securityException);
            }
        }
        return Network.getAddresses(string, n, n2, EndpointSelectionType.Ordered, bl, true).get(0);
    }

    public static int compareAddress(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
        byte[] byArray;
        if (inetSocketAddress == null) {
            if (inetSocketAddress2 == null) {
                return 0;
            }
            return -1;
        }
        if (inetSocketAddress2 == null) {
            return 1;
        }
        if (inetSocketAddress.getPort() < inetSocketAddress2.getPort()) {
            return -1;
        }
        if (inetSocketAddress2.getPort() < inetSocketAddress.getPort()) {
            return 1;
        }
        byte[] byArray2 = inetSocketAddress.getAddress().getAddress();
        if (byArray2.length < (byArray = inetSocketAddress2.getAddress().getAddress()).length) {
            return -1;
        }
        if (byArray.length < byArray2.length) {
            return 1;
        }
        assert (byArray2.length == byArray.length);
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] < byArray[i]) {
                return -1;
            }
            if (byArray[i] >= byArray2[i]) continue;
            return 1;
        }
        return 0;
    }

    public static InetAddress getLocalAddress(int n) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (inetAddress == null || !Network.isValidAddr(inetAddress, n)) {
            ArrayList<InetAddress> arrayList = Network.getLocalAddresses(n);
            Iterator<InetAddress> iterator = arrayList.iterator();
            while (inetAddress == null && iterator.hasNext()) {
                InetAddress inetAddress2 = iterator.next();
                if (n != 2 && !Network.isValidAddr(inetAddress2, n)) continue;
                inetAddress = inetAddress2;
            }
            if (inetAddress == null) {
                inetAddress = Network.getLoopbackAddresses(n)[0];
            }
        }
        assert (inetAddress != null);
        return inetAddress;
    }

    public static List<InetSocketAddress> getAddresses(String string, int n, int n2, EndpointSelectionType endpointSelectionType, boolean bl, boolean bl2) {
        if (!bl2) {
            ArrayList<InetSocketAddress> arrayList;
            block13: {
                if (!Network.isNumericAddress(string)) {
                    return null;
                }
                arrayList = new ArrayList<InetSocketAddress>();
                try {
                    arrayList.add(new InetSocketAddress(InetAddress.getByName(string), n));
                }
                catch (UnknownHostException unknownHostException) {
                    if ($assertionsDisabled) break block13;
                    throw new AssertionError();
                }
            }
            return arrayList;
        }
        ArrayList<InetSocketAddress> arrayList = new ArrayList<InetSocketAddress>();
        try {
            InetAddress[] inetAddressArray = string == null || string.length() == 0 ? Network.getLoopbackAddresses(n2) : InetAddress.getAllByName(string);
            for (InetAddress inetAddress : inetAddressArray) {
                if (n2 != 2 && !Network.isValidAddr(inetAddress, n2)) continue;
                arrayList.add(new InetSocketAddress(inetAddress, n));
            }
            if (endpointSelectionType == EndpointSelectionType.Random) {
                Collections.shuffle(arrayList);
            }
            if (n2 == 2) {
                if (bl) {
                    Collections.sort(arrayList, _preferIPv6Comparator);
                } else {
                    Collections.sort(arrayList, _preferIPv4Comparator);
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new DNSException(0, string, unknownHostException);
        }
        catch (SecurityException securityException) {
            throw new SocketException(securityException);
        }
        if (arrayList.isEmpty()) {
            throw new DNSException(0, string);
        }
        return arrayList;
    }

    public static ArrayList<InetAddress> getLocalAddresses(int n) {
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress() || n != 2 && !Network.isValidAddr(inetAddress, n)) continue;
                    arrayList.add(inetAddress);
                }
            }
        }
        catch (java.net.SocketException socketException) {
            throw new SocketException(socketException);
        }
        catch (SecurityException securityException) {
            throw new SocketException(securityException);
        }
        return arrayList;
    }

    public static SocketPair createPipe() {
        SocketPair socketPair = new SocketPair();
        try {
            Pipe pipe = Pipe.open();
            socketPair.sink = pipe.sink();
            socketPair.source = pipe.source();
        }
        catch (IOException iOException) {
            throw new SocketException(iOException);
        }
        return socketPair;
    }

    public static ArrayList<String> getHostsForEndpointExpand(String string, int n, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = string == null || string.length() == 0;
        if (!bl2) {
            try {
                bl2 = InetAddress.getByName(string).isAnyLocalAddress();
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (SecurityException securityException) {
                throw new SocketException(securityException);
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl2) {
            ArrayList<InetAddress> arrayList2 = Network.getLocalAddresses(n);
            for (InetAddress inetAddress : arrayList2) {
                if (inetAddress.isLinkLocalAddress()) continue;
                arrayList.add(inetAddress.getHostAddress());
            }
            if (bl || arrayList.isEmpty()) {
                if (n != 1) {
                    arrayList.add("127.0.0.1");
                }
                if (n != 0) {
                    arrayList.add("0:0:0:0:0:0:0:1");
                }
            }
        }
        return arrayList;
    }

    public static void setTcpBufSize(SocketChannel socketChannel, ProtocolInstance protocolInstance) {
        int n = 0;
        if (System.getProperty("os.name").startsWith("Windows")) {
            n = 131072;
        }
        int n2 = protocolInstance.properties().getPropertyAsIntWithDefault("Ice.TCP.RcvSize", n);
        int n3 = protocolInstance.properties().getPropertyAsIntWithDefault("Ice.TCP.SndSize", n);
        Network.setTcpBufSize(socketChannel, n2, n3, protocolInstance);
    }

    public static void setTcpBufSize(SocketChannel socketChannel, int n, int n2, ProtocolInstance protocolInstance) {
        BufSizeWarnInfo bufSizeWarnInfo;
        int n3;
        if (n > 0) {
            Network.setRecvBufferSize(socketChannel, n);
            n3 = Network.getRecvBufferSize(socketChannel);
            if (n3 < n) {
                bufSizeWarnInfo = protocolInstance.getBufSizeWarn((short)1);
                if (!bufSizeWarnInfo.rcvWarn || n != bufSizeWarnInfo.rcvSize) {
                    protocolInstance.logger().warning("TCP receive buffer size: requested size of " + n + " adjusted to " + n3);
                    protocolInstance.setRcvBufSizeWarn((short)1, n);
                }
            }
        }
        if (n2 > 0) {
            Network.setSendBufferSize(socketChannel, n2);
            n3 = Network.getSendBufferSize(socketChannel);
            if (n3 < n2) {
                bufSizeWarnInfo = protocolInstance.getBufSizeWarn((short)1);
                if (!bufSizeWarnInfo.sndWarn || n2 != bufSizeWarnInfo.sndSize) {
                    protocolInstance.logger().warning("TCP send buffer size: requested size of " + n2 + " adjusted to " + n3);
                    protocolInstance.setSndBufSizeWarn((short)1, n2);
                }
            }
        }
    }

    public static void setTcpBufSize(ServerSocketChannel serverSocketChannel, ProtocolInstance protocolInstance) {
        int n;
        int n2 = 0;
        if (System.getProperty("os.name").startsWith("Windows")) {
            n2 = 131072;
        }
        if ((n = protocolInstance.properties().getPropertyAsIntWithDefault("Ice.TCP.RcvSize", n2)) > 0) {
            Network.setRecvBufferSize(serverSocketChannel, n);
            int n3 = Network.getRecvBufferSize(serverSocketChannel);
            if (n3 < n) {
                BufSizeWarnInfo bufSizeWarnInfo = protocolInstance.getBufSizeWarn((short)1);
                if (!bufSizeWarnInfo.rcvWarn || n != bufSizeWarnInfo.rcvSize) {
                    protocolInstance.logger().warning("TCP receive buffer size: requested size of " + n + " adjusted to " + n3);
                    protocolInstance.setRcvBufSizeWarn((short)1, n);
                }
            }
        }
    }

    public static String fdToString(SelectableChannel selectableChannel, NetworkProxy networkProxy, InetSocketAddress inetSocketAddress) {
        if (selectableChannel == null) {
            return "<closed>";
        }
        InetAddress inetAddress = null;
        InetAddress inetAddress2 = null;
        int n = -1;
        int n2 = -1;
        if (selectableChannel instanceof SocketChannel) {
            Socket socket = ((SocketChannel)selectableChannel).socket();
            inetAddress = socket.getLocalAddress();
            n = socket.getLocalPort();
            inetAddress2 = socket.getInetAddress();
            n2 = socket.getPort();
        } else if (selectableChannel instanceof DatagramChannel) {
            DatagramSocket datagramSocket = ((DatagramChannel)selectableChannel).socket();
            inetAddress = datagramSocket.getLocalAddress();
            n = datagramSocket.getLocalPort();
            inetAddress2 = datagramSocket.getInetAddress();
            n2 = datagramSocket.getPort();
        } else assert (false);
        return Network.addressesToString(inetAddress, n, inetAddress2, n2, networkProxy, inetSocketAddress);
    }

    public static String fdToString(SelectableChannel selectableChannel) {
        if (selectableChannel == null) {
            return "<closed>";
        }
        InetAddress inetAddress = null;
        InetAddress inetAddress2 = null;
        int n = -1;
        int n2 = -1;
        if (selectableChannel instanceof SocketChannel) {
            Socket socket = ((SocketChannel)selectableChannel).socket();
            inetAddress = socket.getLocalAddress();
            n = socket.getLocalPort();
            inetAddress2 = socket.getInetAddress();
            n2 = socket.getPort();
        } else if (selectableChannel instanceof DatagramChannel) {
            DatagramSocket datagramSocket = ((DatagramChannel)selectableChannel).socket();
            inetAddress = datagramSocket.getLocalAddress();
            n = datagramSocket.getLocalPort();
            inetAddress2 = datagramSocket.getInetAddress();
            n2 = datagramSocket.getPort();
        } else assert (false);
        return Network.addressesToString(inetAddress, n, inetAddress2, n2);
    }

    public static String addressesToString(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, NetworkProxy networkProxy, InetSocketAddress inetSocketAddress) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("local address = ");
        stringBuilder.append(Network.addrToString(inetAddress, n));
        if (networkProxy != null) {
            if (inetAddress2 == null) {
                InetSocketAddress inetSocketAddress2 = networkProxy.getAddress();
                inetAddress2 = inetSocketAddress2.getAddress();
                n2 = inetSocketAddress2.getPort();
            }
            stringBuilder.append("\n");
            stringBuilder.append(networkProxy.getName());
            stringBuilder.append(" proxy address = ");
            stringBuilder.append(Network.addrToString(inetAddress2, n2));
            stringBuilder.append("\nremote address = ");
            stringBuilder.append(Network.addrToString(inetSocketAddress.getAddress(), inetSocketAddress.getPort()));
        } else {
            if (inetAddress2 == null && inetSocketAddress != null) {
                inetAddress2 = inetSocketAddress.getAddress();
                n2 = inetSocketAddress.getPort();
            }
            if (inetAddress2 == null) {
                stringBuilder.append("\nremote address = <not connected>");
            } else {
                stringBuilder.append("\nremote address = ");
                stringBuilder.append(Network.addrToString(inetAddress2, n2));
            }
        }
        return stringBuilder.toString();
    }

    public static String addressesToString(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) {
        return Network.addressesToString(inetAddress, n, inetAddress2, n2, null, null);
    }

    public static String addrToString(InetSocketAddress inetSocketAddress) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(inetSocketAddress.getAddress().getHostAddress());
        stringBuilder.append(':');
        stringBuilder.append(inetSocketAddress.getPort());
        return stringBuilder.toString();
    }

    public static boolean interrupted(IOException iOException) {
        return iOException instanceof InterruptedIOException;
    }

    private static boolean isValidAddr(InetAddress inetAddress, int n) {
        byte[] byArray = null;
        if (inetAddress != null) {
            byArray = inetAddress.getAddress();
        }
        return byArray != null && (byArray.length == 16 && n == 1 || byArray.length == 4 && n == 0);
    }

    public static String addrToString(InetAddress inetAddress, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (inetAddress == null || inetAddress.isAnyLocalAddress()) {
            stringBuffer.append("<not available>");
        } else {
            stringBuffer.append(inetAddress.getHostAddress());
        }
        if (n > 0) {
            stringBuffer.append(':');
            stringBuffer.append(n);
        }
        return stringBuffer.toString();
    }

    private static InetAddress[] getLoopbackAddresses(int n) {
        try {
            InetAddress[] inetAddressArray = new InetAddress[n == 2 ? 2 : 1];
            int n2 = 0;
            if (n != 1) {
                inetAddressArray[n2++] = InetAddress.getByName("127.0.0.1");
            }
            if (n != 0) {
                inetAddressArray[n2++] = InetAddress.getByName("::1");
            }
            return inetAddressArray;
        }
        catch (UnknownHostException unknownHostException) {
            assert (false);
            return null;
        }
        catch (SecurityException securityException) {
            throw new SocketException(securityException);
        }
    }

    public static InetSocketAddress getNumericAddress(String string) {
        InetSocketAddress inetSocketAddress = null;
        if (!string.isEmpty() && Network.isNumericAddress(string)) {
            try {
                inetSocketAddress = new InetSocketAddress(InetAddress.getByName(string), 0);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return inetSocketAddress;
    }

    static {
        block2: {
            IPV4_PATTERN = null;
            IPV6_PATTERN = null;
            try {
                IPV4_PATTERN = Pattern.compile(ipv4Pattern, 2);
                IPV6_PATTERN = Pattern.compile(ipv6Pattern, 2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        _preferIPv4Comparator = new IPAddressComparator(false);
        _preferIPv6Comparator = new IPAddressComparator(true);
    }

    static class IPAddressComparator
    implements Comparator<InetSocketAddress> {
        private final boolean _ipv6;

        IPAddressComparator(boolean bl) {
            this._ipv6 = bl;
        }

        @Override
        public int compare(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
            if (inetSocketAddress.getAddress().getAddress().length < inetSocketAddress2.getAddress().getAddress().length) {
                return this._ipv6 ? 1 : -1;
            }
            if (inetSocketAddress.getAddress().getAddress().length > inetSocketAddress2.getAddress().getAddress().length) {
                return this._ipv6 ? -1 : 1;
            }
            return 0;
        }
    }

    public static final class SocketPair {
        public AbstractSelectableChannel source;
        public WritableByteChannel sink;
    }
}

