/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Properties;
import IceInternal.MetricsAdminI;
import IceMX.Metrics;
import IceMX.MetricsFailures;
import IceMX.MetricsHelper;
import IceMX.Observer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class MetricsMap<T extends Metrics> {
    private final Map<String, String> _properties;
    private final List<String> _groupByAttributes;
    private final List<String> _groupBySeparators;
    private final int _retain;
    private final Map<String, Pattern> _accept;
    private final Map<String, Pattern> _reject;
    private final Class<T> _class;
    private final Map<String, Entry> _objects = new HashMap<String, Entry>();
    private final Map<String, SubMapCloneFactory<?>> _subMaps;
    private Deque<Entry> _detachedQueue;

    MetricsMap(String string, Class<T> clazz, Properties properties, Map<String, SubMapFactory<?>> map) {
        Object object;
        MetricsAdminI.validateProperties(string, properties);
        this._properties = properties.getPropertiesForPrefix(string);
        this._retain = properties.getPropertyAsIntWithDefault(string + "RetainDetached", 10);
        this._accept = this.parseRule(properties, string + "Accept");
        this._reject = this.parseRule(properties, string + "Reject");
        this._groupByAttributes = new ArrayList<String>();
        this._groupBySeparators = new ArrayList<String>();
        this._class = clazz;
        String string2 = properties.getPropertyWithDefault(string + "GroupBy", "id");
        if (!string2.isEmpty()) {
            boolean bl;
            object = "";
            boolean bl2 = bl = Character.isLetter(string2.charAt(0)) || Character.isDigit(string2.charAt(0));
            if (!bl) {
                this._groupByAttributes.add("");
            }
            for (char c : string2.toCharArray()) {
                boolean bl3;
                boolean bl4 = bl3 = Character.isLetter(c) || Character.isDigit(c) || c == '.';
                if (bl && !bl3) {
                    this._groupByAttributes.add((String)object);
                    object = "" + c;
                    bl = false;
                    continue;
                }
                if (!bl && bl3) {
                    this._groupBySeparators.add((String)object);
                    object = "" + c;
                    bl = true;
                    continue;
                }
                object = (String)object + c;
            }
            if (bl) {
                this._groupByAttributes.add((String)object);
            } else {
                this._groupBySeparators.add((String)object);
            }
        }
        if (map != null && !map.isEmpty()) {
            this._subMaps = new HashMap();
            object = new ArrayList();
            for (Map.Entry<String, SubMapFactory<?>> entry : map.entrySet()) {
                object.add(entry.getKey());
                String string3 = string + "Map.";
                String string4 = string3 + entry.getKey() + '.';
                if (properties.getPropertiesForPrefix(string4).isEmpty()) {
                    if (!properties.getPropertiesForPrefix(string3).isEmpty()) continue;
                    string4 = string;
                }
                this._subMaps.put(entry.getKey(), entry.getValue().createCloneFactory(string4, properties));
            }
        } else {
            this._subMaps = null;
        }
    }

    MetricsMap(MetricsMap<T> metricsMap) {
        this._properties = metricsMap._properties;
        this._groupByAttributes = metricsMap._groupByAttributes;
        this._groupBySeparators = metricsMap._groupBySeparators;
        this._retain = metricsMap._retain;
        this._accept = metricsMap._accept;
        this._reject = metricsMap._reject;
        this._class = metricsMap._class;
        this._subMaps = metricsMap._subMaps;
    }

    Map<String, String> getProperties() {
        return this._properties;
    }

    synchronized Metrics[] getMetrics() {
        Metrics[] metricsArray = new Metrics[this._objects.size()];
        int n = 0;
        for (Entry entry : this._objects.values()) {
            metricsArray[n++] = entry.clone();
        }
        return metricsArray;
    }

    synchronized MetricsFailures[] getFailures() {
        ArrayList<MetricsFailures> arrayList = new ArrayList<MetricsFailures>();
        for (Entry entry : this._objects.values()) {
            MetricsFailures metricsFailures = entry.getFailures();
            if (metricsFailures == null) continue;
            arrayList.add(metricsFailures);
        }
        return arrayList.toArray(new MetricsFailures[arrayList.size()]);
    }

    synchronized MetricsFailures getFailures(String string) {
        Entry entry = this._objects.get(string);
        if (entry != null) {
            return entry.getFailures();
        }
        return null;
    }

    public <S extends Metrics> SubMap<S> createSubMap(String string, Class<S> clazz) {
        if (this._subMaps == null) {
            return null;
        }
        SubMapCloneFactory<?> subMapCloneFactory = this._subMaps.get(string);
        if (subMapCloneFactory != null) {
            return subMapCloneFactory.create();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getMatching(MetricsHelper<T> metricsHelper, Entry entry) {
        Object object;
        Object object2;
        Map.Entry<String, Pattern> entry22;
        for (Map.Entry<String, Pattern> entry22 : this._accept.entrySet()) {
            if (this.match(entry22.getKey(), entry22.getValue(), metricsHelper, false)) continue;
            return null;
        }
        for (Map.Entry<String, Pattern> entry22 : this._reject.entrySet()) {
            if (!this.match(entry22.getKey(), entry22.getValue(), metricsHelper, true)) continue;
            return null;
        }
        try {
            if (this._groupByAttributes.size() == 1) {
                object2 = metricsHelper.resolve(this._groupByAttributes.get(0));
            } else {
                entry22 = new StringBuilder();
                object = this._groupBySeparators.iterator();
                for (String string : this._groupByAttributes) {
                    ((StringBuilder)((Object)entry22)).append(metricsHelper.resolve(string));
                    if (!object.hasNext()) continue;
                    ((StringBuilder)((Object)entry22)).append((String)object.next());
                }
                object2 = ((StringBuilder)((Object)entry22)).toString();
            }
        }
        catch (Exception exception) {
            return null;
        }
        entry22 = this;
        synchronized (entry22) {
            block15: {
                if (entry != null && ((Entry)entry)._object.id.equals(object2)) {
                    assert (this._objects.get(object2) == entry);
                    return entry;
                }
                object = this._objects.get(object2);
                if (object == null) {
                    try {
                        Metrics metrics = (Metrics)this._class.newInstance();
                        metrics.id = object2;
                        object = new Entry(this, metrics);
                        this._objects.put((String)object2, (Entry)object);
                    }
                    catch (Exception exception) {
                        if ($assertionsDisabled) break block15;
                        throw new AssertionError();
                    }
                }
            }
            ((Entry)object).attach(metricsHelper);
            return object;
        }
    }

    private void detached(Entry entry) {
        if (this._retain == 0) {
            return;
        }
        if (this._detachedQueue == null) {
            this._detachedQueue = new LinkedList<Entry>();
        }
        assert (this._detachedQueue.size() <= this._retain);
        Iterator<Entry> iterator = this._detachedQueue.iterator();
        while (iterator.hasNext()) {
            Entry entry2 = iterator.next();
            if (entry2 != entry && entry2.isDetached()) continue;
            iterator.remove();
        }
        if (this._detachedQueue.size() == this._retain) {
            this._objects.remove(((Entry)this._detachedQueue.pollFirst())._object.id);
        }
        this._detachedQueue.add(entry);
    }

    private Map<String, Pattern> parseRule(Properties properties, String string) {
        HashMap<String, Pattern> hashMap = new HashMap<String, Pattern>();
        Map<String, String> map = properties.getPropertiesForPrefix(string + '.');
        for (Map.Entry<String, String> entry : map.entrySet()) {
            hashMap.put(entry.getKey().substring(string.length() + 1), Pattern.compile(entry.getValue()));
        }
        return hashMap;
    }

    private boolean match(String string, Pattern pattern, MetricsHelper<T> metricsHelper, boolean bl) {
        String string2;
        try {
            string2 = metricsHelper.resolve(string);
        }
        catch (Exception exception) {
            return !bl;
        }
        return pattern.matcher(string2).matches();
    }

    static class SubMapFactory<S extends Metrics> {
        private final Class<S> _class;
        private final Field _field;

        SubMapFactory(Class<S> clazz, Field field) {
            this._class = clazz;
            this._field = field;
        }

        SubMapCloneFactory<S> createCloneFactory(String string, Properties properties) {
            return new SubMapCloneFactory<S>(new MetricsMap<S>(string, this._class, properties, null), this._field);
        }
    }

    static class SubMapCloneFactory<S extends Metrics> {
        private final MetricsMap<S> _map;
        private final Field _field;

        public SubMapCloneFactory(MetricsMap<S> metricsMap, Field field) {
            this._map = metricsMap;
            this._field = field;
        }

        public SubMap<S> create() {
            return new SubMap<S>(new MetricsMap<S>(this._map), this._field);
        }
    }

    static class SubMap<S extends Metrics> {
        private final MetricsMap<S> _map;
        private final Field _field;

        public SubMap(MetricsMap<S> metricsMap, Field field) {
            this._map = metricsMap;
            this._field = field;
        }

        public Entry getMatching(MetricsHelper<S> metricsHelper) {
            return this._map.getMatching(metricsHelper, null);
        }

        public void addSubMapToMetrics(Metrics metrics) {
            block2: {
                try {
                    this._field.set(metrics, this._map.getMetrics());
                }
                catch (Exception exception) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError();
                }
            }
        }
    }

    public static class Entry {
        private T _object;
        private Map<String, Integer> _failures;
        private Map<String, SubMap<?>> _subMaps;
        final /* synthetic */ MetricsMap this$0;

        Entry(T t) {
            this.this$0 = var1_1;
            this._object = t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failed(String string) {
            MetricsMap metricsMap = this.this$0;
            synchronized (metricsMap) {
                Integer n;
                ++((Metrics)this._object).failures;
                if (this._failures == null) {
                    this._failures = new HashMap<String, Integer>();
                }
                this._failures.put(string, new Integer((n = this._failures.get(string)) == null ? 1 : n + 1));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <S extends Metrics> Entry getMatching(String string, MetricsHelper<S> metricsHelper, Class<S> clazz) {
            SubMap<Object> subMap;
            MetricsMap metricsMap = this.this$0;
            synchronized (metricsMap) {
                SubMap<?> subMap2 = subMap = this._subMaps != null ? this._subMaps.get(string) : null;
                if (subMap == null) {
                    subMap = this.this$0.createSubMap(string, clazz);
                    if (subMap == null) {
                        return null;
                    }
                    if (this._subMaps == null) {
                        this._subMaps = new HashMap();
                    }
                    this._subMaps.put(string, subMap);
                }
            }
            return subMap.getMatching(metricsHelper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void detach(long l) {
            MetricsMap metricsMap = this.this$0;
            synchronized (metricsMap) {
                ((Metrics)this._object).totalLifetime += l;
                if (--((Metrics)this._object).current == 0) {
                    this.this$0.detached(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Observer.MetricsUpdate<T> metricsUpdate) {
            MetricsMap metricsMap = this.this$0;
            synchronized (metricsMap) {
                metricsUpdate.update(this._object);
            }
        }

        public MetricsMap<?> getMap() {
            return this.this$0;
        }

        private MetricsFailures getFailures() {
            if (this._failures == null) {
                return null;
            }
            MetricsFailures metricsFailures = new MetricsFailures();
            metricsFailures.id = ((Metrics)this._object).id;
            metricsFailures.failures = new HashMap<String, Integer>(this._failures);
            return metricsFailures;
        }

        private void attach(MetricsHelper<T> metricsHelper) {
            ++((Metrics)this._object).total;
            ++((Metrics)this._object).current;
            metricsHelper.initMetrics(this._object);
        }

        private boolean isDetached() {
            return ((Metrics)this._object).current == 0;
        }

        public Metrics clone() {
            Metrics metrics = this._object.clone();
            if (this._subMaps != null) {
                for (SubMap<?> subMap : this._subMaps.values()) {
                    subMap.addSubMapToMetrics(metrics);
                }
            }
            return metrics;
        }
    }
}

