/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Current;
import Ice.Logger;
import Ice.LongHolder;
import Ice.Properties;
import Ice.PropertiesAdminUpdateCallback;
import Ice.StringSeqHolder;
import Ice.Util;
import IceInternal.MetricsMap;
import IceInternal.MetricsViewI;
import IceInternal.Time;
import IceMX.Metrics;
import IceMX.MetricsFailures;
import IceMX.UnknownMetricsView;
import IceMX._MetricsAdminDisp;
import IceUtilInternal.StringUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MetricsAdminI
extends _MetricsAdminDisp
implements PropertiesAdminUpdateCallback {
    private static final String[] suffixes = new String[]{"Disabled", "GroupBy", "Accept.*", "Reject.*", "RetainDetached", "Map.*"};
    private Properties _properties;
    private final Logger _logger;
    private final Map<String, MetricsMapFactory<?>> _factories = new HashMap();
    private Map<String, MetricsViewI> _views = new HashMap<String, MetricsViewI>();
    private Set<String> _disabledViews = new HashSet<String>();

    static void validateProperties(String string, Properties properties) {
        Map<String, String> map = properties.getPropertiesForPrefix(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object : map.keySet()) {
            boolean bl = false;
            for (String string2 : suffixes) {
                if (!StringUtil.match(object, string + string2, false)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(object);
        }
        if (arrayList.size() != 0 && properties.getPropertyAsIntWithDefault("Ice.Warn.UnknownProperties", 1) > 0) {
            StringBuffer stringBuffer = new StringBuffer("found unknown IceMX properties for `");
            stringBuffer.append(string.substring(0, string.length() - 1));
            stringBuffer.append("':");
            for (String string3 : arrayList) {
                stringBuffer.append("\n    ");
                stringBuffer.append(string3);
            }
            Util.getProcessLogger().warning(stringBuffer.toString());
        }
    }

    public MetricsAdminI(Properties properties, Logger logger) {
        this._logger = logger;
        this._properties = properties;
        this.updateViews();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void updateViews() {
        HashSet hashSet = new HashSet();
        MetricsAdminI metricsAdminI = this;
        synchronized (metricsAdminI) {
            String object = "IceMX.Metrics.";
            Map<String, String> map = this._properties.getPropertiesForPrefix(object);
            Object object2 = new HashMap<String, MetricsViewI>();
            this._disabledViews.clear();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                void var10_17;
                void var8_10;
                String string = entry.getKey().substring(object.length());
                int n = string.indexOf(46);
                if (n > 0) {
                    String string2 = string.substring(0, n);
                }
                if (object2.containsKey(var8_10) || this._disabledViews.contains(var8_10)) continue;
                MetricsAdminI.validateProperties(object + (String)var8_10 + ".", this._properties);
                if (this._properties.getPropertyAsIntWithDefault(object + (String)var8_10 + ".Disabled", 0) > 0) {
                    this._disabledViews.add((String)var8_10);
                    continue;
                }
                MetricsViewI metricsViewI = this._views.get(var8_10);
                if (metricsViewI == null) {
                    MetricsViewI metricsViewI2 = new MetricsViewI((String)var8_10);
                }
                object2.put(var8_10, var10_17);
                for (Map.Entry<String, MetricsMapFactory<?>> entry2 : this._factories.entrySet()) {
                    if (!var10_17.addOrUpdateMap(this._properties, entry2.getKey(), entry2.getValue(), this._logger)) continue;
                    hashSet.add(entry2.getValue());
                }
            }
            Map<String, MetricsViewI> map2 = this._views;
            this._views = object2;
            object2 = map2;
            for (Map.Entry entry : object2.entrySet()) {
                if (this._views.containsKey(entry.getKey())) continue;
                for (String string : ((MetricsViewI)entry.getValue()).getMaps()) {
                    hashSet.add(this._factories.get(string));
                }
            }
        }
        for (MetricsMapFactory metricsMapFactory : hashSet) {
            metricsMapFactory.update();
        }
    }

    public synchronized String[] getMetricsViewNames(StringSeqHolder stringSeqHolder, Current current) {
        stringSeqHolder.value = this._disabledViews.toArray(new String[this._disabledViews.size()]);
        return this._views.keySet().toArray(new String[this._views.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableMetricsView(String string, Current current) throws UnknownMetricsView {
        MetricsAdminI metricsAdminI = this;
        synchronized (metricsAdminI) {
            this.getMetricsView(string);
            this._properties.setProperty("IceMX.Metrics." + string + ".Disabled", "0");
        }
        this.updateViews();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableMetricsView(String string, Current current) throws UnknownMetricsView {
        MetricsAdminI metricsAdminI = this;
        synchronized (metricsAdminI) {
            this.getMetricsView(string);
            this._properties.setProperty("IceMX.Metrics." + string + ".Disabled", "1");
        }
        this.updateViews();
    }

    public synchronized Map<String, Metrics[]> getMetricsView(String string, LongHolder longHolder, Current current) throws UnknownMetricsView {
        MetricsViewI metricsViewI = this.getMetricsView(string);
        longHolder.value = Time.currentMonotonicTimeMillis();
        if (metricsViewI != null) {
            return metricsViewI.getMetrics();
        }
        return new HashMap<String, Metrics[]>();
    }

    public synchronized MetricsFailures[] getMapMetricsFailures(String string, String string2, Current current) throws UnknownMetricsView {
        MetricsViewI metricsViewI = this.getMetricsView(string);
        if (metricsViewI != null) {
            return metricsViewI.getFailures(string2);
        }
        return new MetricsFailures[0];
    }

    public synchronized MetricsFailures getMetricsFailures(String string, String string2, String string3, Current current) throws UnknownMetricsView {
        MetricsViewI metricsViewI = this.getMetricsView(string);
        if (metricsViewI != null) {
            return metricsViewI.getFailures(string2, string3);
        }
        return new MetricsFailures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Metrics> void registerMap(String string, Class<T> clazz, Runnable runnable) {
        boolean bl;
        MetricsMapFactory<T> metricsMapFactory;
        MetricsAdminI metricsAdminI = this;
        synchronized (metricsAdminI) {
            metricsMapFactory = new MetricsMapFactory<T>(runnable, clazz);
            this._factories.put(string, metricsMapFactory);
            bl = this.addOrUpdateMap(string, metricsMapFactory);
        }
        if (bl) {
            metricsMapFactory.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <S extends Metrics> void registerSubMap(String string, String string2, Class<S> clazz, Field field) {
        boolean bl;
        MetricsMapFactory<?> metricsMapFactory;
        MetricsAdminI metricsAdminI = this;
        synchronized (metricsAdminI) {
            metricsMapFactory = this._factories.get(string);
            if (metricsMapFactory == null) {
                return;
            }
            metricsMapFactory.registerSubMap(string2, clazz, field);
            this.removeMap(string);
            bl = this.addOrUpdateMap(string, metricsMapFactory);
        }
        if (bl) {
            metricsMapFactory.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMap(String string) {
        boolean bl;
        MetricsMapFactory<?> metricsMapFactory;
        MetricsAdminI metricsAdminI = this;
        synchronized (metricsAdminI) {
            metricsMapFactory = this._factories.remove(string);
            if (metricsMapFactory == null) {
                return;
            }
            bl = this.removeMap(string);
        }
        if (bl) {
            metricsMapFactory.update();
        }
    }

    public <T extends Metrics> List<MetricsMap<T>> getMaps(String string, Class<T> clazz) {
        ArrayList<MetricsMap<T>> arrayList = new ArrayList<MetricsMap<T>>();
        for (MetricsViewI metricsViewI : this._views.values()) {
            MetricsMap<T> metricsMap = metricsViewI.getMap(string, clazz);
            if (metricsMap == null) continue;
            arrayList.add(metricsMap);
        }
        return arrayList;
    }

    public Logger getLogger() {
        return this._logger;
    }

    @Override
    public void updated(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey().indexOf("IceMX.") != 0) continue;
            try {
                this.updateViews();
            }
            catch (Exception exception) {
                this._logger.warning("unexpected exception while updating metrics view configuration:\n" + exception.toString());
            }
            return;
        }
    }

    private MetricsViewI getMetricsView(String string) throws UnknownMetricsView {
        MetricsViewI metricsViewI = this._views.get(string);
        if (metricsViewI == null) {
            if (!this._disabledViews.contains(string)) {
                throw new UnknownMetricsView();
            }
            return null;
        }
        return metricsViewI;
    }

    private boolean addOrUpdateMap(String string, MetricsMapFactory<?> metricsMapFactory) {
        boolean bl = false;
        for (MetricsViewI metricsViewI : this._views.values()) {
            bl |= metricsViewI.addOrUpdateMap(this._properties, string, metricsMapFactory, this._logger);
        }
        return bl;
    }

    private boolean removeMap(String string) {
        boolean bl = false;
        for (MetricsViewI metricsViewI : this._views.values()) {
            bl |= metricsViewI.removeMap(string);
        }
        return bl;
    }

    static class MetricsMapFactory<T extends Metrics> {
        private final Runnable _updater;
        private final Class<T> _class;
        private final Map<String, MetricsMap.SubMapFactory<?>> _subMaps = new HashMap();

        public MetricsMapFactory(Runnable runnable, Class<T> clazz) {
            this._updater = runnable;
            this._class = clazz;
        }

        public void update() {
            assert (this._updater != null);
            this._updater.run();
        }

        public MetricsMap<T> create(String string, Properties properties) {
            return new MetricsMap<T>(string, this._class, properties, this._subMaps);
        }

        public <S extends Metrics> void registerSubMap(String string, Class<S> clazz, Field field) {
            this._subMaps.put(string, new MetricsMap.SubMapFactory<S>(clazz, field));
        }
    }
}

