/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AsyncResult;
import Ice.Callback;
import Ice.CommunicatorDestroyedException;
import Ice.LocalException;
import Ice.LogMessage;
import Ice.LogMessageType;
import Ice.Logger;
import Ice.Object;
import Ice.OperationInterruptedException;
import Ice.Properties;
import Ice.RemoteLoggerPrx;
import Ice.RemoteLoggerPrxHelper;
import IceInternal.LoggerAdminI;
import IceInternal.LoggerAdminLogger;
import java.util.ArrayDeque;
import java.util.Calendar;
import java.util.Deque;
import java.util.List;

final class LoggerAdminLoggerI
implements LoggerAdminLogger,
Runnable {
    private final Logger _localLogger;
    private final LoggerAdminI _loggerAdmin;
    private boolean _destroyed = false;
    private Thread _sendLogThread;
    private final Deque<Job> _jobQueue = new ArrayDeque<Job>();
    private static final String _traceCategory = "Admin.Logger";

    @Override
    public void print(String string) {
        LogMessage logMessage = new LogMessage(LogMessageType.PrintMessage, LoggerAdminLoggerI.now(), "", string);
        this._localLogger.print(string);
        this.log(logMessage);
    }

    @Override
    public void trace(String string, String string2) {
        LogMessage logMessage = new LogMessage(LogMessageType.TraceMessage, LoggerAdminLoggerI.now(), string, string2);
        this._localLogger.trace(string, string2);
        this.log(logMessage);
    }

    @Override
    public void warning(String string) {
        LogMessage logMessage = new LogMessage(LogMessageType.WarningMessage, LoggerAdminLoggerI.now(), "", string);
        this._localLogger.warning(string);
        this.log(logMessage);
    }

    @Override
    public void error(String string) {
        LogMessage logMessage = new LogMessage(LogMessageType.ErrorMessage, LoggerAdminLoggerI.now(), "", string);
        this._localLogger.error(string);
        this.log(logMessage);
    }

    @Override
    public String getPrefix() {
        return this._localLogger.getPrefix();
    }

    @Override
    public Logger cloneWithPrefix(String string) {
        return this._localLogger.cloneWithPrefix(string);
    }

    @Override
    public Object getFacet() {
        return this._loggerAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Thread thread = null;
        LoggerAdminLoggerI loggerAdminLoggerI = this;
        synchronized (loggerAdminLoggerI) {
            if (this._sendLogThread != null) {
                thread = this._sendLogThread;
                this._sendLogThread = null;
                this._destroyed = true;
                this.notifyAll();
            }
        }
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                LoggerAdminLoggerI loggerAdminLoggerI2 = this;
                synchronized (loggerAdminLoggerI2) {
                    this._sendLogThread = thread;
                }
                throw new OperationInterruptedException();
            }
        }
        this._loggerAdmin.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this._loggerAdmin.getTraceLevel() > 1) {
            this._localLogger.trace(_traceCategory, "send log thread started");
        }
        Callback callback = new Callback(){

            @Override
            public void completed(AsyncResult asyncResult) {
                RemoteLoggerPrx remoteLoggerPrx = RemoteLoggerPrxHelper.uncheckedCast(asyncResult.getProxy());
                try {
                    remoteLoggerPrx.end_log(asyncResult);
                    if (LoggerAdminLoggerI.this._loggerAdmin.getTraceLevel() > 1) {
                        LoggerAdminLoggerI.this._localLogger.trace(LoggerAdminLoggerI._traceCategory, asyncResult.getOperation() + " on `" + remoteLoggerPrx.toString() + "' completed successfully");
                    }
                }
                catch (CommunicatorDestroyedException communicatorDestroyedException) {
                }
                catch (LocalException localException) {
                    LoggerAdminLoggerI.this._loggerAdmin.deadRemoteLogger(remoteLoggerPrx, LoggerAdminLoggerI.this._localLogger, localException, asyncResult.getOperation());
                }
            }
        };
        block7: while (true) {
            Job job = null;
            java.lang.Object object = this;
            synchronized (object) {
                while (!this._destroyed && this._jobQueue.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this._destroyed) {
                    break;
                }
                assert (!this._jobQueue.isEmpty());
                job = this._jobQueue.removeFirst();
            }
            object = job.remoteLoggers.iterator();
            while (true) {
                if (!object.hasNext()) continue block7;
                RemoteLoggerPrx remoteLoggerPrx = (RemoteLoggerPrx)object.next();
                if (this._loggerAdmin.getTraceLevel() > 1) {
                    this._localLogger.trace(_traceCategory, "sending log message to `" + remoteLoggerPrx.toString() + "'");
                }
                try {
                    remoteLoggerPrx.begin_log(job.logMessage, callback);
                }
                catch (LocalException localException) {
                    this._loggerAdmin.deadRemoteLogger(remoteLoggerPrx, this._localLogger, localException, "log");
                }
            }
            break;
        }
        if (this._loggerAdmin.getTraceLevel() > 1) {
            this._localLogger.trace(_traceCategory, "send log thread completed");
        }
    }

    LoggerAdminLoggerI(Properties properties, Logger logger) {
        this._localLogger = logger instanceof LoggerAdminLoggerI ? ((LoggerAdminLoggerI)logger).getLocalLogger() : logger;
        this._loggerAdmin = new LoggerAdminI(properties, this);
    }

    Logger getLocalLogger() {
        return this._localLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void log(LogMessage logMessage) {
        List<RemoteLoggerPrx> list = this._loggerAdmin.log(logMessage);
        if (list != null) {
            assert (!list.isEmpty());
            LoggerAdminLoggerI loggerAdminLoggerI = this;
            synchronized (loggerAdminLoggerI) {
                if (this._sendLogThread == null) {
                    this._sendLogThread = new Thread((Runnable)this, "Ice.SendLogThread");
                    this._sendLogThread.start();
                }
                this._jobQueue.addLast(new Job(list, logMessage));
                this.notifyAll();
            }
        }
    }

    private static long now() {
        return Calendar.getInstance().getTimeInMillis() * 1000L;
    }

    private static class Job {
        final List<RemoteLoggerPrx> remoteLoggers;
        final LogMessage logMessage;

        Job(List<RemoteLoggerPrx> list, LogMessage logMessage) {
            this.remoteLoggers = list;
            this.logMessage = logMessage;
        }
    }
}

