/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AsyncResult;
import Ice.Callback;
import Ice.Communicator;
import Ice.Current;
import Ice.Identity;
import Ice.InitializationData;
import Ice.LocalException;
import Ice.LogMessage;
import Ice.LogMessageType;
import Ice.Logger;
import Ice.ObjectNotExistException;
import Ice.ObjectPrx;
import Ice.Properties;
import Ice.RemoteLoggerAlreadyAttachedException;
import Ice.RemoteLoggerPrx;
import Ice.RemoteLoggerPrxHelper;
import Ice.StringHolder;
import Ice.Util;
import Ice._LoggerAdminDisp;
import IceInternal.LoggerAdminLoggerI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

final class LoggerAdminI
extends _LoggerAdminDisp {
    private final List<LogMessage> _queue = new LinkedList<LogMessage>();
    private int _logCount = 0;
    private final int _maxLogCount;
    private int _traceCount = 0;
    private final int _maxTraceCount;
    private final int _traceLevel;
    private int _oldestTrace = -1;
    private int _oldestLog = -1;
    private final Map<Identity, RemoteLoggerData> _remoteLoggerMap = new HashMap<Identity, RemoteLoggerData>();
    private final LoggerAdminLoggerI _logger;
    private Communicator _sendLogCommunicator = null;
    private boolean _destroyed = false;
    private static final String _traceCategory = "Admin.Logger";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachRemoteLogger(RemoteLoggerPrx remoteLoggerPrx, LogMessageType[] logMessageTypeArray, String[] stringArray, int n, Current current) throws RemoteLoggerAlreadyAttachedException {
        if (remoteLoggerPrx == null) {
            return;
        }
        RemoteLoggerPrx remoteLoggerPrx2 = RemoteLoggerPrxHelper.uncheckedCast(remoteLoggerPrx.ice_twoway());
        Filters filters = new Filters(logMessageTypeArray, stringArray);
        LinkedList<Object> linkedList = null;
        Object object = this;
        synchronized (object) {
            Identity identity;
            if (this._sendLogCommunicator == null) {
                if (this._destroyed) {
                    throw new ObjectNotExistException();
                }
                this._sendLogCommunicator = LoggerAdminI.createSendLogCommunicator(current.adapter.getCommunicator(), this._logger.getLocalLogger());
            }
            if (this._remoteLoggerMap.containsKey(identity = remoteLoggerPrx2.ice_getIdentity())) {
                if (this._traceLevel > 0) {
                    this._logger.trace(_traceCategory, "rejecting `" + remoteLoggerPrx2.toString() + "' with RemoteLoggerAlreadyAttachedException");
                }
                throw new RemoteLoggerAlreadyAttachedException();
            }
            this._remoteLoggerMap.put(identity, new RemoteLoggerData(LoggerAdminI.changeCommunicator(remoteLoggerPrx2, this._sendLogCommunicator), filters));
            linkedList = n != 0 ? new LinkedList<LogMessage>(this._queue) : new LinkedList();
        }
        if (this._traceLevel > 0) {
            this._logger.trace(_traceCategory, "attached `" + remoteLoggerPrx2.toString() + "'");
        }
        if (!linkedList.isEmpty()) {
            LoggerAdminI.filterLogMessages(linkedList, filters.messageTypes, filters.traceCategories, n);
        }
        object = new Callback(){

            @Override
            public void completed(AsyncResult asyncResult) {
                RemoteLoggerPrx remoteLoggerPrx = RemoteLoggerPrxHelper.uncheckedCast(asyncResult.getProxy());
                try {
                    remoteLoggerPrx.end_init(asyncResult);
                    if (LoggerAdminI.this._traceLevel > 1) {
                        LoggerAdminI.this._logger.trace(LoggerAdminI._traceCategory, asyncResult.getOperation() + " on `" + remoteLoggerPrx.toString() + "' completed successfully");
                    }
                }
                catch (LocalException localException) {
                    LoggerAdminI.this.deadRemoteLogger(remoteLoggerPrx, LoggerAdminI.this._logger, localException, asyncResult.getOperation());
                }
            }
        };
        try {
            remoteLoggerPrx2.begin_init(this._logger.getPrefix(), linkedList.toArray(new LogMessage[0]), (Callback)object);
        }
        catch (LocalException localException) {
            this.deadRemoteLogger(remoteLoggerPrx2, this._logger, localException, "init");
            throw localException;
        }
    }

    @Override
    public boolean detachRemoteLogger(RemoteLoggerPrx remoteLoggerPrx, Current current) {
        if (remoteLoggerPrx == null) {
            return false;
        }
        boolean bl = this.removeRemoteLogger(remoteLoggerPrx);
        if (this._traceLevel > 0) {
            if (bl) {
                this._logger.trace(_traceCategory, "detached `" + remoteLoggerPrx.toString() + "'");
            } else {
                this._logger.trace(_traceCategory, "cannot detach `" + remoteLoggerPrx.toString() + "': not found");
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogMessage[] getLog(LogMessageType[] logMessageTypeArray, String[] stringArray, int n, StringHolder stringHolder, Current current) {
        LinkedList<Object> linkedList = null;
        Object object = this;
        synchronized (object) {
            linkedList = n != 0 ? new LinkedList<LogMessage>(this._queue) : new LinkedList();
        }
        stringHolder.value = this._logger.getPrefix();
        if (!linkedList.isEmpty()) {
            object = new Filters(logMessageTypeArray, stringArray);
            LoggerAdminI.filterLogMessages(linkedList, ((Filters)object).messageTypes, ((Filters)object).traceCategories, n);
        }
        return linkedList.toArray(new LogMessage[0]);
    }

    LoggerAdminI(Properties properties, LoggerAdminLoggerI loggerAdminLoggerI) {
        this._maxLogCount = properties.getPropertyAsIntWithDefault("Ice.Admin.Logger.KeepLogs", 100);
        this._maxTraceCount = properties.getPropertyAsIntWithDefault("Ice.Admin.Logger.KeepTraces", 100);
        this._traceLevel = properties.getPropertyAsInt("Ice.Trace.Admin.Logger");
        this._logger = loggerAdminLoggerI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        Communicator communicator = null;
        LoggerAdminI loggerAdminI = this;
        synchronized (loggerAdminI) {
            if (!this._destroyed) {
                this._destroyed = true;
                communicator = this._sendLogCommunicator;
                this._sendLogCommunicator = null;
            }
        }
        if (communicator != null) {
            communicator.destroy();
        }
    }

    synchronized List<RemoteLoggerPrx> log(LogMessage logMessage) {
        ArrayList<RemoteLoggerPrx> arrayList = null;
        if (logMessage.type != LogMessageType.TraceMessage && this._maxLogCount > 0 || logMessage.type == LogMessageType.TraceMessage && this._maxTraceCount > 0) {
            int n;
            this._queue.add(logMessage);
            if (logMessage.type != LogMessageType.TraceMessage) {
                assert (this._maxLogCount > 0);
                if (this._logCount == this._maxLogCount) {
                    assert (this._oldestLog != -1);
                    this._queue.remove(this._oldestLog);
                    n = this._queue.size();
                    while (this._oldestLog < n && this._queue.get((int)this._oldestLog).type == LogMessageType.TraceMessage) {
                        ++this._oldestLog;
                    }
                    assert (this._oldestLog < n);
                } else {
                    assert (this._logCount < this._maxLogCount);
                    ++this._logCount;
                    if (this._oldestLog == -1) {
                        this._oldestLog = this._queue.size() - 1;
                    }
                }
            } else {
                assert (this._maxTraceCount > 0);
                if (this._traceCount == this._maxTraceCount) {
                    assert (this._oldestTrace != -1);
                    this._queue.remove(this._oldestTrace);
                    n = this._queue.size();
                    while (this._oldestTrace < n && this._queue.get((int)this._oldestTrace).type != LogMessageType.TraceMessage) {
                        ++this._oldestTrace;
                    }
                    assert (this._oldestTrace < n);
                } else {
                    assert (this._traceCount < this._maxTraceCount);
                    ++this._traceCount;
                    if (this._oldestTrace == -1) {
                        this._oldestTrace = this._queue.size() - 1;
                    }
                }
            }
            for (RemoteLoggerData remoteLoggerData : this._remoteLoggerMap.values()) {
                Filters filters = remoteLoggerData.filters;
                if (!filters.messageTypes.isEmpty() && !filters.messageTypes.contains(logMessage.type) || logMessage.type == LogMessageType.TraceMessage && !filters.traceCategories.isEmpty() && !filters.traceCategories.contains(logMessage.traceCategory)) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<RemoteLoggerPrx>();
                }
                arrayList.add(remoteLoggerData.remoteLogger);
            }
        }
        return arrayList;
    }

    void deadRemoteLogger(RemoteLoggerPrx remoteLoggerPrx, Logger logger, LocalException localException, String string) {
        if (this.removeRemoteLogger(remoteLoggerPrx) && this._traceLevel > 0) {
            logger.trace(_traceCategory, "detached `" + remoteLoggerPrx.toString() + "' because " + string + " raised:\n" + localException.toString());
        }
    }

    int getTraceLevel() {
        return this._traceLevel;
    }

    private synchronized boolean removeRemoteLogger(RemoteLoggerPrx remoteLoggerPrx) {
        return this._remoteLoggerMap.remove(remoteLoggerPrx.ice_getIdentity()) != null;
    }

    private static void filterLogMessages(List<LogMessage> list, Set<LogMessageType> set, Set<String> set2, int n) {
        assert (!list.isEmpty() && n != 0);
        if (!set.isEmpty() || !set2.isEmpty() || n > 0) {
            int n2 = 0;
            ListIterator<LogMessage> listIterator = list.listIterator(list.size());
            while (listIterator.hasPrevious()) {
                boolean bl = false;
                LogMessage logMessage = listIterator.previous();
                if ((set.isEmpty() || set.contains(logMessage.type)) && (logMessage.type != LogMessageType.TraceMessage || set2.isEmpty() || set2.contains(logMessage.traceCategory))) {
                    bl = true;
                }
                if (bl) {
                    if (n <= 0 || ++n2 < n) continue;
                    if (!listIterator.hasPrevious()) break;
                    int n3 = listIterator.previousIndex() + 1;
                    for (int i = 0; i < n3; ++i) {
                        list.remove(0);
                    }
                    break;
                }
                listIterator.remove();
            }
        }
    }

    private static RemoteLoggerPrx changeCommunicator(RemoteLoggerPrx remoteLoggerPrx, Communicator communicator) {
        if (remoteLoggerPrx == null) {
            return null;
        }
        ObjectPrx objectPrx = communicator.stringToProxy(remoteLoggerPrx.toString());
        return RemoteLoggerPrxHelper.uncheckedCast(objectPrx.ice_invocationTimeout(remoteLoggerPrx.ice_getInvocationTimeout()));
    }

    private static void copyProperties(String string, Properties properties, Properties properties2) {
        for (Map.Entry<String, String> entry : properties.getPropertiesForPrefix(string).entrySet()) {
            properties2.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private static Communicator createSendLogCommunicator(Communicator communicator, Logger logger) {
        InitializationData initializationData = new InitializationData();
        initializationData.logger = logger;
        initializationData.properties = Util.createProperties();
        Properties properties = communicator.getProperties();
        LoggerAdminI.copyProperties("Ice.Default.Locator", properties, initializationData.properties);
        LoggerAdminI.copyProperties("Ice.Plugin.IceSSL", properties, initializationData.properties);
        LoggerAdminI.copyProperties("IceSSL.", properties, initializationData.properties);
        String[] stringArray = properties.getPropertyAsList("Ice.Admin.Logger.Properties");
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string.startsWith("--")) continue;
                stringArray[i] = "--" + string;
            }
            initializationData.properties.parseCommandLineOptions("", stringArray);
        }
        return Util.initialize(initializationData);
    }

    private static class RemoteLoggerData {
        final RemoteLoggerPrx remoteLogger;
        final Filters filters;

        RemoteLoggerData(RemoteLoggerPrx remoteLoggerPrx, Filters filters) {
            this.remoteLogger = remoteLoggerPrx;
            this.filters = filters;
        }
    }

    private static class Filters {
        final Set<LogMessageType> messageTypes;
        final Set<String> traceCategories;

        Filters(LogMessageType[] logMessageTypeArray, String[] stringArray) {
            this.messageTypes = new HashSet<LogMessageType>(Arrays.asList(logMessageTypeArray));
            this.traceCategories = new HashSet<String>(Arrays.asList(stringArray));
        }
    }
}

