/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Holder;
import Ice.Identity;
import IceInternal.EndpointI;
import IceInternal.Reference;
import IceInternal.Time;
import java.util.HashMap;
import java.util.Map;

final class LocatorTable {
    private Map<String, EndpointTableEntry> _adapterEndpointsTable = new HashMap<String, EndpointTableEntry>();
    private Map<Identity, ReferenceTableEntry> _objectTable = new HashMap<Identity, ReferenceTableEntry>();

    LocatorTable() {
    }

    synchronized void clear() {
        this._adapterEndpointsTable.clear();
        this._objectTable.clear();
    }

    synchronized EndpointI[] getAdapterEndpoints(String string, int n, Holder<Boolean> holder) {
        if (n == 0) {
            holder.value = false;
            return null;
        }
        EndpointTableEntry endpointTableEntry = this._adapterEndpointsTable.get(string);
        if (endpointTableEntry != null) {
            holder.value = this.checkTTL(endpointTableEntry.time, n);
            return endpointTableEntry.endpoints;
        }
        holder.value = false;
        return null;
    }

    synchronized void addAdapterEndpoints(String string, EndpointI[] endpointIArray) {
        this._adapterEndpointsTable.put(string, new EndpointTableEntry(Time.currentMonotonicTimeMillis(), endpointIArray));
    }

    synchronized EndpointI[] removeAdapterEndpoints(String string) {
        EndpointTableEntry endpointTableEntry = this._adapterEndpointsTable.remove(string);
        return endpointTableEntry != null ? endpointTableEntry.endpoints : null;
    }

    synchronized Reference getObjectReference(Identity identity, int n, Holder<Boolean> holder) {
        if (n == 0) {
            holder.value = false;
            return null;
        }
        ReferenceTableEntry referenceTableEntry = this._objectTable.get(identity);
        if (referenceTableEntry != null) {
            holder.value = this.checkTTL(referenceTableEntry.time, n);
            return referenceTableEntry.reference;
        }
        holder.value = false;
        return null;
    }

    synchronized void addObjectReference(Identity identity, Reference reference) {
        this._objectTable.put(identity, new ReferenceTableEntry(Time.currentMonotonicTimeMillis(), reference));
    }

    synchronized Reference removeObjectReference(Identity identity) {
        ReferenceTableEntry referenceTableEntry = this._objectTable.remove(identity);
        return referenceTableEntry != null ? referenceTableEntry.reference : null;
    }

    private boolean checkTTL(long l, int n) {
        assert (n != 0);
        if (n < 0) {
            return true;
        }
        return Time.currentMonotonicTimeMillis() - l <= (long)n * 1000L;
    }

    private static final class ReferenceTableEntry {
        public final long time;
        public final Reference reference;

        public ReferenceTableEntry(long l, Reference reference) {
            this.time = l;
            this.reference = reference;
        }
    }

    private static final class EndpointTableEntry {
        public final long time;
        public final EndpointI[] endpoints;

        public EndpointTableEntry(long l, EndpointI[] endpointIArray) {
            this.time = l;
            this.endpoints = endpointIArray;
        }
    }
}

