/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.EncodingVersion;
import Ice.Identity;
import Ice.LocatorPrx;
import Ice.LocatorPrxHelper;
import Ice.ObjectPrxHelperBase;
import Ice.Properties;
import IceInternal.HashUtil;
import IceInternal.LocatorInfo;
import IceInternal.LocatorTable;
import IceInternal.Reference;
import java.util.HashMap;

public final class LocatorManager {
    private final boolean _background;
    private HashMap<LocatorPrx, LocatorInfo> _table = new HashMap();
    private HashMap<LocatorKey, LocatorTable> _locatorTables = new HashMap();
    private LocatorKey _lookupKey = new LocatorKey();

    LocatorManager(Properties properties) {
        this._background = properties.getPropertyAsInt("Ice.BackgroundLocatorCacheUpdates") > 0;
    }

    synchronized void destroy() {
        for (LocatorInfo locatorInfo : this._table.values()) {
            locatorInfo.destroy();
        }
        this._table.clear();
        this._locatorTables.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocatorInfo get(LocatorPrx locatorPrx) {
        if (locatorPrx == null) {
            return null;
        }
        LocatorPrx locatorPrx2 = LocatorPrxHelper.uncheckedCast(locatorPrx.ice_locator(null));
        LocatorManager locatorManager = this;
        synchronized (locatorManager) {
            LocatorInfo locatorInfo = this._table.get(locatorPrx2);
            if (locatorInfo == null) {
                LocatorTable locatorTable = this._locatorTables.get(this._lookupKey.set(locatorPrx2));
                if (locatorTable == null) {
                    locatorTable = new LocatorTable();
                    this._locatorTables.put(this._lookupKey.clone(), locatorTable);
                }
                locatorInfo = new LocatorInfo(locatorPrx2, locatorTable, this._background);
                this._table.put(locatorPrx2, locatorInfo);
            }
            return locatorInfo;
        }
    }

    private static final class LocatorKey
    implements Cloneable {
        private Identity _id;
        private EncodingVersion _encoding;

        private LocatorKey() {
        }

        public boolean equals(Object object) {
            assert (object instanceof LocatorKey);
            LocatorKey locatorKey = (LocatorKey)object;
            if (!locatorKey._id.equals(this._id)) {
                return false;
            }
            return locatorKey._encoding.equals(this._encoding);
        }

        public int hashCode() {
            int n = 5381;
            n = HashUtil.hashAdd(n, this._id);
            n = HashUtil.hashAdd(n, this._encoding);
            return n;
        }

        public LocatorKey clone() {
            LocatorKey locatorKey;
            block2: {
                locatorKey = null;
                try {
                    locatorKey = (LocatorKey)super.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError();
                }
            }
            return locatorKey;
        }

        LocatorKey set(LocatorPrx locatorPrx) {
            Reference reference = ((ObjectPrxHelperBase)((Object)locatorPrx)).__reference();
            this._id = reference.getIdentity();
            this._encoding = reference.getEncoding();
            return this;
        }
    }
}

