/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AdapterNotFoundException;
import Ice.Callback_Locator_findAdapterById;
import Ice.Callback_Locator_findObjectById;
import Ice.EndpointSelectionType;
import Ice.Holder;
import Ice.Identity;
import Ice.LocalException;
import Ice.LocatorPrx;
import Ice.LocatorRegistryPrx;
import Ice.NotRegisteredException;
import Ice.ObjectNotFoundException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.UserException;
import IceInternal.EndpointI;
import IceInternal.Instance;
import IceInternal.LocatorTable;
import IceInternal.Protocol;
import IceInternal.Reference;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class LocatorInfo {
    private final LocatorPrx _locator;
    private LocatorRegistryPrx _locatorRegistry;
    private final LocatorTable _table;
    private final boolean _background;
    private Map<String, Request> _adapterRequests = new HashMap<String, Request>();
    private Map<Identity, Request> _objectRequests = new HashMap<Identity, Request>();

    LocatorInfo(LocatorPrx locatorPrx, LocatorTable locatorTable, boolean bl) {
        this._locator = locatorPrx;
        this._table = locatorTable;
        this._background = bl;
    }

    public synchronized void destroy() {
        this._locatorRegistry = null;
        this._table.clear();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LocatorInfo) {
            return this._locator.equals(((LocatorInfo)object)._locator);
        }
        return false;
    }

    public int hashCode() {
        return this._locator.hashCode();
    }

    public LocatorPrx getLocator() {
        return this._locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocatorRegistryPrx getLocatorRegistry() {
        Object object = this;
        synchronized (object) {
            if (this._locatorRegistry != null) {
                return this._locatorRegistry;
            }
        }
        object = this._locator.getRegistry();
        if (object == null) {
            return null;
        }
        LocatorInfo locatorInfo = this;
        synchronized (locatorInfo) {
            this._locatorRegistry = (LocatorRegistryPrx)object.ice_locator(null).ice_endpointSelection(EndpointSelectionType.Ordered);
            return this._locatorRegistry;
        }
    }

    public void getEndpoints(Reference reference, int n, GetEndpointsCallback getEndpointsCallback) {
        this.getEndpoints(reference, null, n, getEndpointsCallback);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void getEndpoints(Reference reference, Reference reference2, int n, GetEndpointsCallback getEndpointsCallback) {
        assert (reference.isIndirect());
        EndpointI[] endpointIArray = null;
        Holder<Boolean> holder = new Holder<Boolean>();
        if (!reference.isWellKnown()) {
            endpointIArray = this._table.getAdapterEndpoints(reference.getAdapterId(), n, holder);
            if (!((Boolean)holder.value).booleanValue()) {
                if (this._background && endpointIArray != null) {
                    this.getAdapterRequest(reference).addCallback(reference, reference2, n, null);
                } else {
                    this.getAdapterRequest(reference).addCallback(reference, reference2, n, getEndpointsCallback);
                    return;
                }
            }
        } else {
            Reference reference3 = this._table.getObjectReference(reference.getIdentity(), n, holder);
            if (!((Boolean)holder.value).booleanValue()) {
                if (this._background && reference3 != null) {
                    this.getObjectRequest(reference).addCallback(reference, null, n, null);
                } else {
                    this.getObjectRequest(reference).addCallback(reference, null, n, getEndpointsCallback);
                    return;
                }
            }
            if (!reference3.isIndirect()) {
                endpointIArray = reference3.getEndpoints();
            } else if (!reference3.isWellKnown()) {
                this.getEndpoints(reference3, reference, n, getEndpointsCallback);
                return;
            }
        }
        assert (endpointIArray != null);
        if (reference.getInstance().traceLevels().location >= 1) {
            this.getEndpointsTrace(reference, endpointIArray, true);
        }
        if (getEndpointsCallback != null) {
            getEndpointsCallback.setEndpoints(endpointIArray, true);
        }
    }

    public void clearCache(Reference reference) {
        assert (reference.isIndirect());
        if (!reference.isWellKnown()) {
            EndpointI[] endpointIArray = this._table.removeAdapterEndpoints(reference.getAdapterId());
            if (endpointIArray != null && reference.getInstance().traceLevels().location >= 2) {
                this.trace("removed endpoints from locator table\n", reference, endpointIArray);
            }
        } else {
            Reference reference2 = this._table.removeObjectReference(reference.getIdentity());
            if (reference2 != null) {
                if (!reference2.isIndirect()) {
                    if (reference.getInstance().traceLevels().location >= 2) {
                        this.trace("removed endpoints from locator table", reference, reference2.getEndpoints());
                    }
                } else if (!reference2.isWellKnown()) {
                    this.clearCache(reference2);
                }
            }
        }
    }

    private void trace(String string, Reference reference, EndpointI[] endpointIArray) {
        assert (reference.isIndirect());
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(string);
        stringBuilder.append("\n");
        if (!reference.isWellKnown()) {
            stringBuilder.append("adapter = ");
            stringBuilder.append(reference.getAdapterId());
            stringBuilder.append("\n");
        } else {
            stringBuilder.append("object = ");
            stringBuilder.append(reference.getInstance().identityToString(reference.getIdentity()));
            stringBuilder.append("\n");
        }
        stringBuilder.append("endpoints = ");
        int n = endpointIArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(endpointIArray[i].toString());
            if (i + 1 >= n) continue;
            stringBuilder.append(":");
        }
        reference.getInstance().initializationData().logger.trace(reference.getInstance().traceLevels().locationCat, stringBuilder.toString());
    }

    private void getEndpointsException(Reference reference, Exception exception) {
        assert (reference.isIndirect());
        try {
            throw exception;
        }
        catch (AdapterNotFoundException adapterNotFoundException) {
            Serializable serializable;
            Instance instance = reference.getInstance();
            if (instance.traceLevels().location >= 1) {
                serializable = new StringBuilder(128);
                ((StringBuilder)serializable).append("adapter not found\n");
                ((StringBuilder)serializable).append("adapter = ");
                ((StringBuilder)serializable).append(reference.getAdapterId());
                instance.initializationData().logger.trace(instance.traceLevels().locationCat, ((StringBuilder)serializable).toString());
            }
            serializable = new NotRegisteredException();
            ((NotRegisteredException)serializable).kindOfObject = "object adapter";
            ((NotRegisteredException)serializable).id = reference.getAdapterId();
            throw serializable;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            Serializable serializable;
            Instance instance = reference.getInstance();
            if (instance.traceLevels().location >= 1) {
                serializable = new StringBuilder(128);
                ((StringBuilder)serializable).append("object not found\n");
                ((StringBuilder)serializable).append("object = ");
                ((StringBuilder)serializable).append(instance.identityToString(reference.getIdentity()));
                instance.initializationData().logger.trace(instance.traceLevels().locationCat, ((StringBuilder)serializable).toString());
            }
            serializable = new NotRegisteredException();
            ((NotRegisteredException)serializable).kindOfObject = "object";
            ((NotRegisteredException)serializable).id = instance.identityToString(reference.getIdentity());
            throw serializable;
        }
        catch (NotRegisteredException notRegisteredException) {
            throw notRegisteredException;
        }
        catch (LocalException localException) {
            Instance instance = reference.getInstance();
            if (instance.traceLevels().location >= 1) {
                StringBuilder stringBuilder = new StringBuilder(128);
                stringBuilder.append("couldn't contact the locator to retrieve adapter endpoints\n");
                if (reference.getAdapterId().length() > 0) {
                    stringBuilder.append("adapter = ");
                    stringBuilder.append(reference.getAdapterId());
                    stringBuilder.append("\n");
                } else {
                    stringBuilder.append("object = ");
                    stringBuilder.append(instance.identityToString(reference.getIdentity()));
                    stringBuilder.append("\n");
                }
                stringBuilder.append("reason = " + localException);
                instance.initializationData().logger.trace(instance.traceLevels().locationCat, stringBuilder.toString());
            }
            throw localException;
        }
        catch (Exception exception2) {
            assert (false);
            return;
        }
    }

    private void getEndpointsTrace(Reference reference, EndpointI[] endpointIArray, boolean bl) {
        if (endpointIArray != null && endpointIArray.length > 0) {
            if (bl) {
                this.trace("found endpoints in locator table", reference, endpointIArray);
            } else {
                this.trace("retrieved endpoints from locator, adding to locator table", reference, endpointIArray);
            }
        } else {
            Instance instance = reference.getInstance();
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("no endpoints configured for ");
            if (reference.getAdapterId().length() > 0) {
                stringBuilder.append("adapter\n");
                stringBuilder.append("adapter = ");
                stringBuilder.append(reference.getAdapterId());
                stringBuilder.append("\n");
            } else {
                stringBuilder.append("object\n");
                stringBuilder.append("object = ");
                stringBuilder.append(instance.identityToString(reference.getIdentity()));
                stringBuilder.append("\n");
            }
            instance.initializationData().logger.trace(instance.traceLevels().locationCat, stringBuilder.toString());
        }
    }

    private synchronized Request getAdapterRequest(Reference reference) {
        Object object;
        if (reference.getInstance().traceLevels().location >= 1) {
            object = reference.getInstance();
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("searching for adapter by id\n");
            stringBuilder.append("adapter = ");
            stringBuilder.append(reference.getAdapterId());
            ((Instance)object).initializationData().logger.trace(((Instance)object).traceLevels().locationCat, stringBuilder.toString());
        }
        if ((object = this._adapterRequests.get(reference.getAdapterId())) != null) {
            return object;
        }
        object = new AdapterRequest(this, reference);
        this._adapterRequests.put(reference.getAdapterId(), (Request)object);
        return object;
    }

    private synchronized Request getObjectRequest(Reference reference) {
        Object object;
        if (reference.getInstance().traceLevels().location >= 1) {
            object = reference.getInstance();
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("searching for object by id\n");
            stringBuilder.append("object = ");
            stringBuilder.append(((Instance)object).identityToString(reference.getIdentity()));
            ((Instance)object).initializationData().logger.trace(((Instance)object).traceLevels().locationCat, stringBuilder.toString());
        }
        if ((object = this._objectRequests.get(reference.getIdentity())) != null) {
            return object;
        }
        object = new ObjectRequest(this, reference);
        this._objectRequests.put(reference.getIdentity(), (Request)object);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishRequest(Reference reference, List<Reference> list, ObjectPrx objectPrx, boolean bl) {
        Object object;
        if (objectPrx == null || ((ObjectPrxHelperBase)objectPrx).__reference().isIndirect()) {
            for (Reference reference2 : list) {
                this._table.removeObjectReference(reference2.getIdentity());
            }
        }
        if (!reference.isWellKnown()) {
            if (objectPrx != null && !((ObjectPrxHelperBase)objectPrx).__reference().isIndirect()) {
                this._table.addAdapterEndpoints(reference.getAdapterId(), ((ObjectPrxHelperBase)objectPrx).__reference().getEndpoints());
            } else if (bl) {
                this._table.removeAdapterEndpoints(reference.getAdapterId());
            }
            object = this;
            synchronized (object) {
                assert (this._adapterRequests.get(reference.getAdapterId()) != null);
                this._adapterRequests.remove(reference.getAdapterId());
            }
        }
        if (objectPrx != null && !((ObjectPrxHelperBase)objectPrx).__reference().isWellKnown()) {
            this._table.addObjectReference(reference.getIdentity(), ((ObjectPrxHelperBase)objectPrx).__reference());
        } else if (bl) {
            this._table.removeObjectReference(reference.getIdentity());
        }
        object = this;
        synchronized (object) {
            assert (this._objectRequests.get(reference.getIdentity()) != null);
            this._objectRequests.remove(reference.getIdentity());
        }
    }

    private class AdapterRequest
    extends Request {
        public AdapterRequest(LocatorInfo locatorInfo2, Reference reference) {
            super(locatorInfo2, reference);
            assert (reference.isIndirect());
        }

        @Override
        protected void send() {
            try {
                this._locatorInfo.getLocator().begin_findAdapterById(this._ref.getAdapterId(), new Callback_Locator_findAdapterById(){

                    @Override
                    public void response(ObjectPrx objectPrx) {
                        AdapterRequest.this.response(objectPrx);
                    }

                    @Override
                    public void exception(UserException userException) {
                        AdapterRequest.this.exception(userException);
                    }

                    @Override
                    public void exception(LocalException localException) {
                        AdapterRequest.this.exception(localException);
                    }
                });
            }
            catch (Exception exception) {
                this.exception(exception);
            }
        }
    }

    private class ObjectRequest
    extends Request {
        public ObjectRequest(LocatorInfo locatorInfo2, Reference reference) {
            super(locatorInfo2, reference);
            assert (reference.isWellKnown());
        }

        @Override
        protected void send() {
            try {
                this._locatorInfo.getLocator().begin_findObjectById(this._ref.getIdentity(), new Callback_Locator_findObjectById(){

                    @Override
                    public void response(ObjectPrx objectPrx) {
                        ObjectRequest.this.response(objectPrx);
                    }

                    @Override
                    public void exception(UserException userException) {
                        ObjectRequest.this.exception(userException);
                    }

                    @Override
                    public void exception(LocalException localException) {
                        ObjectRequest.this.exception(localException);
                    }
                });
            }
            catch (Exception exception) {
                this.exception(exception);
            }
        }
    }

    private abstract class Request {
        protected final LocatorInfo _locatorInfo;
        protected final Reference _ref;
        private List<RequestCallback> _callbacks = new ArrayList<RequestCallback>();
        private List<Reference> _wellKnownRefs = new ArrayList<Reference>();
        private boolean _sent;
        private boolean _response;
        private ObjectPrx _proxy;
        private Exception _exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addCallback(Reference reference, Reference reference2, int n, GetEndpointsCallback getEndpointsCallback) {
            RequestCallback requestCallback = new RequestCallback(reference, n, getEndpointsCallback);
            Request request = this;
            synchronized (request) {
                if (!this._response && this._exception == null) {
                    this._callbacks.add(requestCallback);
                    if (reference2 != null) {
                        this._wellKnownRefs.add(reference2);
                    }
                    if (!this._sent) {
                        this._sent = true;
                        this.send();
                    }
                    return;
                }
            }
            if (this._response) {
                requestCallback.response(this._locatorInfo, this._proxy);
            } else {
                assert (this._exception != null);
                requestCallback.exception(this._locatorInfo, this._exception);
            }
        }

        Request(LocatorInfo locatorInfo2, Reference reference) {
            this._locatorInfo = locatorInfo2;
            this._ref = reference;
            this._sent = false;
            this._response = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void response(ObjectPrx objectPrx) {
            Request request = this;
            synchronized (request) {
                this._locatorInfo.finishRequest(this._ref, this._wellKnownRefs, objectPrx, false);
                this._response = true;
                this._proxy = objectPrx;
                this.notifyAll();
            }
            for (RequestCallback requestCallback : this._callbacks) {
                requestCallback.response(this._locatorInfo, objectPrx);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void exception(Exception exception) {
            Request request = this;
            synchronized (request) {
                this._locatorInfo.finishRequest(this._ref, this._wellKnownRefs, null, exception instanceof UserException);
                this._exception = exception;
                this.notifyAll();
            }
            for (RequestCallback requestCallback : this._callbacks) {
                requestCallback.exception(this._locatorInfo, exception);
            }
        }

        protected abstract void send();
    }

    private static class RequestCallback {
        final Reference _ref;
        final int _ttl;
        final GetEndpointsCallback _callback;

        public void response(LocatorInfo locatorInfo, ObjectPrx objectPrx) {
            EndpointI[] endpointIArray = null;
            if (objectPrx != null) {
                Reference reference = ((ObjectPrxHelperBase)objectPrx).__reference();
                if (!this._ref.isWellKnown() || Protocol.isSupported(this._ref.getEncoding(), reference.getEncoding())) {
                    if (!reference.isIndirect()) {
                        endpointIArray = reference.getEndpoints();
                    } else if (this._ref.isWellKnown() && !reference.isWellKnown()) {
                        locatorInfo.getEndpoints(reference, this._ref, this._ttl, this._callback);
                        return;
                    }
                }
            }
            if (this._ref.getInstance().traceLevels().location >= 1) {
                locatorInfo.getEndpointsTrace(this._ref, endpointIArray, false);
            }
            if (this._callback != null) {
                this._callback.setEndpoints(endpointIArray == null ? new EndpointI[]{} : endpointIArray, false);
            }
        }

        public void exception(LocatorInfo locatorInfo, Exception exception) {
            block2: {
                try {
                    locatorInfo.getEndpointsException(this._ref, exception);
                }
                catch (LocalException localException) {
                    if (this._callback == null) break block2;
                    this._callback.setException(localException);
                }
            }
        }

        RequestCallback(Reference reference, int n, GetEndpointsCallback getEndpointsCallback) {
            this._ref = reference;
            this._ttl = n;
            this._callback = getEndpointsCallback;
        }
    }

    static interface GetEndpointsCallback {
        public void setEndpoints(EndpointI[] var1, boolean var2);

        public void setException(LocalException var1);
    }
}

